/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaConfigBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractSenchaMojo
extends AbstractMojo {
    @Parameter
    private String toolkit = "classic";
    @Parameter(defaultValue="${project.build.directory}/ext", readonly=true)
    private String extFrameworkDir;
    @Parameter(defaultValue="${project.build.directory}/packages", readonly=true)
    private String packagesDir;
    @Parameter(defaultValue="${project.groupId}:${project.artifactId}")
    private String remotePackagesArtifact;
    @Parameter(defaultValue="((net\\.jangaroo\\.com)|(com\\.coremedia))\\.sencha:ext-js(-pkg)?(-gpl)?")
    private String extFrameworkArtifactRegexp;
    @Parameter(property="senchaLogLevel")
    private String senchaLogLevel;
    private volatile Pattern extFrameworkArtifactPattern;

    public String getToolkit() {
        return this.toolkit;
    }

    public String getExtFrameworkDir() {
        return this.extFrameworkDir;
    }

    public Pattern getExtFrameworkArtifactPattern() {
        if (this.extFrameworkArtifactPattern == null) {
            this.extFrameworkArtifactPattern = Pattern.compile(this.getExtFrameworkArtifactRegexp());
        }
        return this.extFrameworkArtifactPattern;
    }

    public String getExtFrameworkArtifactRegexp() {
        return this.extFrameworkArtifactRegexp;
    }

    public String getPackagesDir() {
        return this.packagesDir;
    }

    public String getRemotePackagesArtifact() {
        return this.remotePackagesArtifact;
    }

    public void setExtFrameworkDir(String extFrameworkDir) {
        this.extFrameworkDir = extFrameworkDir;
    }

    public void setPackagesDir(String packagesDir) {
        this.packagesDir = packagesDir;
    }

    public String getSenchaLogLevel() {
        return this.senchaLogLevel;
    }

    protected static void configureDefaults(SenchaConfigBuilder configBuilder, String defaultsFileName) throws MojoExecutionException {
        try {
            configBuilder.defaults(defaultsFileName);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot load " + defaultsFileName, (Exception)e);
        }
    }

    protected void writeFile(@Nonnull SenchaConfigBuilder configBuilder, @Nonnull String destinationFileDir, @Nonnull String destinationFileName, @Nullable String comment) throws MojoExecutionException {
        String tmpDestFileName = destinationFileName + ".tmp";
        File tmpDestFile = new File(destinationFileDir, tmpDestFileName);
        File destFile = new File(destinationFileDir, destinationFileName);
        configBuilder.destFile(tmpDestFile);
        if (comment != null) {
            configBuilder.destFileComment(comment);
        }
        try {
            configBuilder.buildFile();
        }
        catch (IOException io) {
            try {
                Files.delete(tmpDestFile.toPath());
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to delete temporary file " + tmpDestFile.getAbsolutePath()), (Throwable)e);
            }
            throw new MojoExecutionException(String.format("Writing %s failed", tmpDestFile.getName()), (Exception)io);
        }
        try {
            Files.move(tmpDestFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Moving %s to %s failed", tmpDestFile.getName(), destFile.getAbsolutePath()), (Exception)e);
        }
    }

    protected boolean isExtFrameworkArtifact(Artifact artifact) {
        return this.isExtFramework(artifact.getGroupId(), artifact.getArtifactId());
    }

    protected boolean isExtFrameworkDependency(Dependency dependency) {
        return this.isExtFramework(dependency.getGroupId(), dependency.getArtifactId());
    }

    private boolean isExtFramework(String groupId, String artifactId) {
        String key = groupId + ":" + artifactId;
        return this.getExtFrameworkArtifactPattern().matcher(key).matches();
    }
}

