/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenDependencyHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenPluginHelper;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

@Mojo(name="extract-remote-packages", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class RemotePackagesMojo
extends AbstractSenchaMojo {
    private static final String PACKAGES_DIRECTORY = "/packages/";
    private static final String EXT_FRAMEWORK_DIRECTORY = "/ext/";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${localRepository}", required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Inject
    private ArchiverManager archiverManager;
    @Inject
    protected RepositorySystem repositorySystem;
    @Inject
    private ArtifactResolver artifactResolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String remotePackagesTargetDir = RemotePackagesMojo.getRemotePackagesDirectory(this.project);
        Set dependencyArtifacts = this.project.getArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            if (!"pkg".equals(artifact.getType())) continue;
            this.unpackArtifact(remotePackagesTargetDir, artifact);
        }
        String myVersion = ((Artifact)this.project.getPluginArtifactMap().get("net.jangaroo:jangaroo-maven-plugin")).getVersion();
        Artifact artifactFromHelper = MavenPluginHelper.getArtifact(this.localRepository, this.remoteRepositories, this.artifactResolver, this.repositorySystem, "net.jangaroo", "sencha-app-template", myVersion, "runtime", "jar");
        this.unpackArtifact(remotePackagesTargetDir, artifactFromHelper);
        Artifact testArtifactFromHelper = MavenPluginHelper.getArtifact(this.localRepository, this.remoteRepositories, this.artifactResolver, this.repositorySystem, "net.jangaroo", "sencha-test-app-template", myVersion, "runtime", "jar");
        this.unpackArtifact(remotePackagesTargetDir, testArtifactFromHelper);
    }

    private void unpackArtifact(String targetDir, Artifact artifact) throws MojoExecutionException {
        try {
            Dependency currentArtifactDependency = MavenDependencyHelper.fromArtifact(artifact);
            String groupId = artifact.getGroupId();
            String artifactId = artifact.getArtifactId();
            String version = artifact.getVersion();
            File packageTargetDir = this.isExtFrameworkDependency(currentArtifactDependency) ? new File(RemotePackagesMojo.getExtFrameworkDirectory(this.project)) : new File(targetDir, SenchaUtils.getSenchaPackageName(groupId, artifactId));
            File mavenStampFile = this.mavenStampFile(packageTargetDir, groupId, artifactId, version);
            long artifactLastModified = artifact.getFile().lastModified();
            if (mavenStampFile.exists() && mavenStampFile.lastModified() == artifactLastModified) {
                this.getLog().info((CharSequence)String.format("Already unpacked, skipping %s", artifact));
                return;
            }
            if (packageTargetDir.exists()) {
                this.getLog().info((CharSequence)String.format("Cleaning %s", packageTargetDir));
                this.clean(packageTargetDir);
            }
            this.getLog().info((CharSequence)String.format("Extracting %s to %s", artifact, packageTargetDir));
            UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
            unArchiver.setSourceFile(artifact.getFile());
            FileHelper.ensureDirectory(packageTargetDir);
            unArchiver.setDestDirectory(packageTargetDir);
            unArchiver.extract();
            this.touch(mavenStampFile, artifactLastModified);
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Could not find zipUnArchiver.", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Could not extract: " + artifact, (Exception)((Object)e));
        }
    }

    private void clean(File dir) throws MojoExecutionException {
        try {
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to clean directory " + dir.getAbsolutePath(), (Exception)e);
        }
    }

    private void touch(File file, long timestamp) throws MojoExecutionException {
        try {
            FileUtils.touch((File)file);
            file.setLastModified(timestamp);
        }
        catch (IOException e) {
            throw new MojoExecutionException("unable to create file " + file.getAbsolutePath(), (Exception)e);
        }
    }

    private File mavenStampFile(File packageTargetDir, String groupId, String artifactId, String version) {
        String fileName = "." + groupId + '_' + artifactId + '_' + version;
        return new File(packageTargetDir, fileName);
    }

    static String getRemotePackagesDirectory(MavenProject remotePackagesProject) {
        return remotePackagesProject.getBuild().getDirectory() + PACKAGES_DIRECTORY;
    }

    static String getExtFrameworkDirectory(MavenProject remotePackagesProject) {
        return remotePackagesProject.getBuild().getDirectory() + EXT_FRAMEWORK_DIRECTORY;
    }
}

