/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.sencha.configbuilder;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;

public class SenchaConfigBuilder<T extends SenchaConfigBuilder> {
    protected Map<String, Object> config = new LinkedHashMap<String, Object>();
    private File destFile = null;
    private String destFileComment = null;

    T nameValue(@Nonnull String name, @Nullable Object value) {
        SenchaConfigBuilder.handleNewValue(this.config, name, this.config.get(name), value);
        return (T)this;
    }

    private static void mergeMap(@Nonnull Map<String, Object> baseMap, @Nonnull Map<String, Object> mapWithNewValues) {
        for (Map.Entry<String, Object> entry : mapWithNewValues.entrySet()) {
            String key = entry.getKey();
            SenchaConfigBuilder.handleNewValue(baseMap, key, baseMap.get(key), entry.getValue());
        }
    }

    private static void handleNewValue(@Nonnull Map<String, Object> baseMap, @Nonnull String key, @Nullable Object currentValue, @Nullable Object newValue) {
        boolean isListValue = newValue instanceof List;
        boolean isMapValue = newValue instanceof Map;
        if (currentValue == null || newValue == null || !isListValue && !isMapValue) {
            baseMap.put(key, newValue);
        } else if (isMapValue) {
            SenchaConfigBuilder.addToMapRecursively(baseMap, key, currentValue, (Map)newValue);
        } else {
            SenchaConfigBuilder.addToList(baseMap, key, currentValue, (Collection)newValue);
        }
    }

    private static void addToList(@Nonnull Map<String, Object> baseMap, @Nonnull String key, @Nonnull Object currentValue, @Nonnull Collection<?> additionalValues) {
        if (!(currentValue instanceof List)) {
            String errorMessage = String.format("Expected a list as value for property name %s, but got %s", key, currentValue);
            throw new IllegalArgumentException(errorMessage);
        }
        List currentValueAsList = (List)currentValue;
        ArrayList currentList = new ArrayList();
        currentList.addAll(currentValueAsList);
        currentList.addAll(additionalValues);
        baseMap.put(key, currentList);
    }

    private static void addToMapRecursively(@Nonnull Map<String, Object> baseMap, @Nonnull String key, @Nonnull Object currentValue, @Nonnull Map<String, Object> additionalMap) {
        if (!(currentValue instanceof Map)) {
            throw new IllegalArgumentException(String.format("Expected a map as value for property name %s, but got %s", key, currentValue));
        }
        Map currentValueAsMap = (Map)currentValue;
        HashMap<String, Object> currentSubMap = new HashMap<String, Object>();
        currentSubMap.putAll(currentValueAsMap);
        SenchaConfigBuilder.mergeMap(currentSubMap, additionalMap);
        baseMap.put(key, currentSubMap);
    }

    public T namesValues(@Nonnull Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.nameValue(entry.getKey(), entry.getValue());
        }
        return (T)this;
    }

    public T destFile(File destFile) {
        this.destFile = destFile;
        return (T)this;
    }

    public T destFileComment(String comment) {
        this.destFileComment = comment;
        return (T)this;
    }

    @Nonnull
    public Map<String, Object> build() {
        return Collections.unmodifiableMap(this.config);
    }

    public File buildFile() throws IOException {
        if (this.destFile == null) {
            throw new IllegalStateException("Cannot build file without file path being set.");
        }
        try (PrintWriter pw = new PrintWriter((Writer)new FileWriter(this.destFile), false);){
            if (this.destFileComment != null) {
                pw.println("/**");
                pw.println(" * " + this.destFileComment);
                pw.println(" */");
            }
            SenchaUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValue((Writer)pw, this.build());
        }
        return this.destFile;
    }

    public T defaults(String jsonFileName) throws IOException {
        return this.namesValues(this.readDefaultJson(jsonFileName));
    }

    private Map<String, Object> readDefaultJson(String jsonFileName) throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream(jsonFileName);
        return (Map)SenchaUtils.getObjectMapper().readValue(inputStream, Map.class);
    }

    <I> T addToList(I item, String ... pathArcs) {
        LinkedHashMap<String, Object> node = this.config;
        for (int i = 0; i < pathArcs.length - 1; ++i) {
            String pathArc = pathArcs[i];
            LinkedHashMap<String, Object> nextNode = (LinkedHashMap<String, Object>)node.get(pathArc);
            if (nextNode == null) {
                nextNode = new LinkedHashMap<String, Object>();
                node.put(pathArc, nextNode);
            }
            node = nextNode;
        }
        String key = pathArcs[pathArcs.length - 1];
        ArrayList<I> newValue = new ArrayList<I>();
        List value = (List)node.get(key);
        if (value != null && !value.isEmpty()) {
            newValue.addAll(value);
        }
        newValue.add(item);
        node.put(key, Collections.unmodifiableList(newValue));
        return (T)this;
    }
}

