/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.RemotePackagesMojo;
import net.jangaroo.jooc.mvnplugin.Type;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaWorkspaceConfigBuilder;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import net.jangaroo.jooc.mvnplugin.util.MavenDependencyHelper;
import net.jangaroo.jooc.mvnplugin.util.PomManipulator;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-workspace", requiresDependencyCollection=ResolutionScope.TEST, threadSafe=true)
public class SenchaGenerateWorkspaceMojo
extends AbstractSenchaMojo {
    private static final String SENCHA_TEST_APP_LOCATION_SUFFIX = "/test-classes";
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${basedir}", readonly=true)
    private File workingDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String remotePackagesFromConfiguration = this.getRemotePackagesArtifact();
        MavenProject remotePackagesProject = this.getRemotePackagesProject(remotePackagesFromConfiguration);
        if (this.isWorkspaceDir()) {
            this.addDirectoryLocations(remotePackagesProject);
            this.updateRemotePackages(remotePackagesProject);
            this.addRemotePackagesProject(remotePackagesProject);
            this.createAndPrepareSenchaModule();
        } else {
            this.addRemotePackagesProject(remotePackagesProject);
        }
    }

    private void createAndPrepareSenchaModule() throws MojoExecutionException {
        FileHelper.ensureDirectory(this.workingDirectory);
        if (null == SenchaUtils.findClosestSenchaWorkspaceDir(this.workingDirectory.getParentFile())) {
            String extDirectory = SenchaUtils.generateAbsolutePathUsingPlaceholder("workspace", this.getExtFrameworkDir());
            SenchaUtils.generateSenchaWorkspace(this.workingDirectory, extDirectory, this.getLog(), this.getSenchaLogLevel());
            SenchaWorkspaceConfigBuilder configBuilder = new SenchaWorkspaceConfigBuilder();
            SenchaGenerateWorkspaceMojo.configureDefaults(configBuilder, "default.workspace.json");
            this.configurePackagesAndApp(configBuilder);
            this.writeFile(configBuilder, this.workingDirectory.getPath(), "workspace.json", "DO NOT CHANGE - This file was automatically generated by the jangaroo-maven-plugin and it will be overwritten by the next call of the plugin's goal \"generate-workspace\".");
        } else {
            this.getLog().info((CharSequence)"Skipping creation of workspace because there already is a workspace in the directory hierarchy");
        }
    }

    private void configurePackagesAndApp(SenchaWorkspaceConfigBuilder configBuilder) throws MojoExecutionException {
        ArrayList<String> appPaths = new ArrayList<String>();
        ArrayList<String> packagePaths = new ArrayList<String>();
        packagePaths.add(SenchaUtils.PLACEHOLDERS.get("workspace"));
        List projectsInReactor = this.project.getCollectedProjects();
        if (null != projectsInReactor) {
            for (MavenProject projectInReactor : projectsInReactor) {
                String packageType = projectInReactor.getPackaging();
                if ("jangaroo-pkg".equals(packageType)) {
                    SenchaGenerateWorkspaceMojo.addIfAbsent(packagePaths, SenchaUtils.PLACEHOLDERS.get("workspace") + "/" + this.getRelativePathForSubProject(projectInReactor));
                    SenchaGenerateWorkspaceMojo.addIfAbsent(appPaths, this.getRelativePathForSubProject(projectInReactor, "") + SENCHA_TEST_APP_LOCATION_SUFFIX);
                    continue;
                }
                if (!"jangaroo-app".equals(packageType)) continue;
                SenchaGenerateWorkspaceMojo.addIfAbsent(appPaths, this.getRelativePathForSubProject(projectInReactor));
            }
        }
        Collections.sort(packagePaths);
        Collections.sort(appPaths);
        configBuilder.packagesDirs(packagePaths);
        configBuilder.apps(appPaths);
        configBuilder.packagesExtract(SenchaUtils.generateAbsolutePathUsingPlaceholder("workspace", this.getPackagesDir()));
    }

    private String getRelativePathForSubProject(MavenProject subProject) throws MojoExecutionException {
        String localPathToSrc = "jangaroo-app".equals(subProject.getPackaging()) ? "/app" : "/packages/";
        return this.getRelativePathForSubProject(subProject, localPathToSrc);
    }

    private String getRelativePathForSubProject(MavenProject subProject, String localPathToSrc) throws MojoExecutionException {
        Path path;
        Path rootPath = this.project.getBasedir().toPath().normalize();
        Path relativePath = rootPath.relativize(path = Paths.get(subProject.getBuild().getDirectory() + localPathToSrc, new String[0]));
        String relativePathString = FilenameUtils.separatorsToUnix((String)relativePath.toString());
        if (relativePathString.isEmpty()) {
            throw new MojoExecutionException("Cannot handle project because not relative path to root workspace could be build");
        }
        return relativePathString;
    }

    private void addDirectoryLocations(MavenProject remotePackagesProject) throws MojoExecutionException {
        String remotePackagesPath = this.getPathRelativeToCurrentProjectFrom(RemotePackagesMojo.getRemotePackagesDirectory(remotePackagesProject));
        this.setPackagesDir(remotePackagesPath);
        String extPath = this.getPathRelativeToCurrentProjectFrom(RemotePackagesMojo.getExtFrameworkDirectory(remotePackagesProject));
        this.setExtFrameworkDir(extPath);
    }

    private boolean isWorkspaceDir() {
        return this.project.equals((Object)this.session.getTopLevelProject());
    }

    @Nonnull
    private MavenProject getRemotePackagesProject(@Nullable String remotePackageArtifactId) throws MojoExecutionException {
        if (StringUtils.isEmpty((CharSequence)remotePackageArtifactId)) {
            return this.session.getCurrentProject();
        }
        List allReactorProjects = this.session.getProjects();
        for (MavenProject reactorProject : allReactorProjects) {
            if (!this.isRemoteAggregator(reactorProject)) continue;
            return reactorProject;
        }
        throw new MojoExecutionException("Could not find local remote-packages module with coordinates " + remotePackageArtifactId);
    }

    public void updateRemotePackages(MavenProject remoteAggregatorProject) throws MojoExecutionException {
        this.getLog().debug((CharSequence)String.format("Update remotes packages for project %s", this.project));
        long startTime = System.nanoTime();
        ArrayList<Dependency> remotePackagesDependencies = new ArrayList<Dependency>();
        List localProjects = this.session.getProjects();
        for (MavenProject localProject : localProjects) {
            if (!Type.containsJangarooSources(localProject)) continue;
            this.collectRemoteDependencies(remotePackagesDependencies, localProjects, localProject, remoteAggregatorProject);
        }
        for (Artifact artifact : remoteAggregatorProject.getDependencyArtifacts()) {
            Dependency pkgDependency = SenchaGenerateWorkspaceMojo.convertToPkgDependency(MavenDependencyHelper.fromArtifact(artifact), remoteAggregatorProject);
            MavenDependencyHelper.remove(remotePackagesDependencies, pkgDependency);
        }
        PomManipulator.addDependencies(remoteAggregatorProject, remotePackagesDependencies, this.getLog());
        this.getLog().debug((CharSequence)String.format("Needed %d ns to update remotes for project %s", System.nanoTime() - startTime, this.project));
    }

    private void collectRemoteDependencies(List<Dependency> remotePackages, List<MavenProject> localProjects, MavenProject currentProject, MavenProject remoteAggregator) {
        Dependency remotePackageDependency = MavenDependencyHelper.fromKey(this.getRemotePackagesArtifact());
        for (Artifact artifact : currentProject.getArtifacts()) {
            Dependency dependency = MavenDependencyHelper.fromArtifact(artifact);
            if (this.isExtFrameworkDependency(dependency) || !SenchaUtils.isRequiredSenchaDependency(dependency, remotePackageDependency)) continue;
            Dependency pkgDependency = SenchaGenerateWorkspaceMojo.convertToPkgDependency(dependency, remoteAggregator);
            MavenProject projectFromArtifact = SenchaGenerateWorkspaceMojo.createProjectFromArtifact(artifact);
            if (MavenDependencyHelper.contains(remotePackages, pkgDependency) || localProjects.contains(projectFromArtifact)) continue;
            this.getLog().info((CharSequence)String.format("Using remote dependency \"%s\" from project \"%s\"", artifact.getId(), currentProject.getId()));
            remotePackages.add(pkgDependency);
        }
    }

    private void addRemotePackagesProject(@Nonnull MavenProject remotesProject) throws MojoExecutionException {
        if (!remotesProject.equals((Object)this.project) && Type.containsJangarooSources(this.project) && !SenchaGenerateWorkspaceMojo.containsProject(this.project.getDependencies(), remotesProject)) {
            Dependency remotesDependency = !Objects.equals(remotesProject.getVersion(), this.project.getVersion()) ? MavenDependencyHelper.createDependency(remotesProject.getGroupId(), remotesProject.getArtifactId(), "pom", remotesProject.getVersion()) : MavenDependencyHelper.createDependency(remotesProject.getGroupId(), remotesProject.getArtifactId(), "pom", "${project.version}");
            PomManipulator.addDependency(this.project, remotesDependency, this.getLog());
            this.getLog().info((CharSequence)String.format("Add dependency %s as remote packaging module to the module %s", remotesDependency, this.project));
        }
    }

    private static boolean containsProject(@Nonnull List<Dependency> dependencies, @Nonnull MavenProject project) {
        for (Dependency dependency : dependencies) {
            if (!Objects.equals(dependency.getArtifactId(), project.getArtifactId()) || !Objects.equals(dependency.getGroupId(), project.getGroupId())) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    private static MavenProject createProjectFromArtifact(@Nonnull Artifact artifact) {
        MavenProject mavenProject = new MavenProject();
        mavenProject.setArtifactId(artifact.getArtifactId());
        mavenProject.setGroupId(artifact.getGroupId());
        mavenProject.setVersion(artifact.getVersion());
        return mavenProject;
    }

    private static Dependency convertToPkgDependency(@Nullable Dependency dependency, @Nonnull MavenProject project) {
        if (dependency == null) {
            return null;
        }
        if (SenchaGenerateWorkspaceMojo.isDependencyManaged(project, dependency)) {
            dependency.setVersion(null);
        }
        dependency.setScope(null);
        dependency.setType("pkg");
        return dependency;
    }

    private static boolean isDependencyManaged(@Nonnull MavenProject project, final @Nonnull Dependency dependency) {
        return project.getDependencyManagement() != null && Iterables.tryFind((Iterable)project.getDependencyManagement().getDependencies(), (Predicate)new Predicate<Dependency>(){

            public boolean apply(@Nullable Dependency input) {
                return input != null && Objects.equals(input.getArtifactId(), dependency.getArtifactId()) && Objects.equals(input.getGroupId(), dependency.getGroupId());
            }
        }).isPresent();
    }

    private String getPathRelativeToCurrentProjectFrom(@Nonnull String remotePackagePath) throws MojoExecutionException {
        Path absolutePathToCurrentProject = this.project.getBasedir().toPath().normalize();
        Path absolutePathFromProperty = Paths.get(remotePackagePath, new String[0]).normalize();
        return FilenameUtils.separatorsToUnix((String)absolutePathToCurrentProject.relativize(absolutePathFromProperty).toString());
    }

    private boolean isRemoteAggregator(@Nonnull MavenProject project) {
        Dependency dependency = MavenDependencyHelper.fromProject(project);
        Dependency remotePackagesDependency = MavenDependencyHelper.fromKey(this.getRemotePackagesArtifact());
        return MavenDependencyHelper.equalsGroupIdAndArtifactId(dependency, remotePackagesDependency);
    }

    private static void addIfAbsent(List<String> aList, String value) {
        if (!aList.contains(value)) {
            aList.add(value);
        }
    }
}

