/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PhantomJsTestRunner {
    public static final Pattern LOG_LEVEL_PATTERN = Pattern.compile("^\\[([A-Z]+)\\]\\s*(.*)$");
    private static int INITIAL_RESOURCE_TIMEOUT_MS = 5000;
    private static volatile Boolean phantomjsExecutableFound;
    private final String testPageUrl;
    private final boolean phantomjsDebug;
    private final boolean phantomjsWebSecurity;
    private String testResultFilename;
    private final String phantomjs;
    private final Log log;
    private final String testRunner;
    private final int timeout;
    private final int maxRetriesOnCrashes;

    public PhantomJsTestRunner(String phantomjs, String testPageUrl, String testResultFilename, String testRunner, int timeout, int maxRetriesOnCrashes, boolean phantomjsDebug, boolean phantomjsWebSecurity, Log log) {
        this.phantomjs = PhantomJsTestRunner.makeOsSpecific(phantomjs);
        this.testPageUrl = testPageUrl;
        this.testResultFilename = testResultFilename;
        this.testRunner = testRunner;
        this.timeout = timeout;
        this.maxRetriesOnCrashes = maxRetriesOnCrashes;
        this.log = log;
        this.phantomjsDebug = phantomjsDebug;
        this.phantomjsWebSecurity = phantomjsWebSecurity;
    }

    private static String makeOsSpecific(String phantomjs) {
        if (SystemUtils.IS_OS_WINDOWS && !StringUtils.isBlank((String)phantomjs) && phantomjs.charAt(phantomjs.length() - 4) != '.') {
            return phantomjs + ".exe";
        }
        return phantomjs;
    }

    public boolean execute() throws CommandLineException {
        int resourceTimeoutMs = INITIAL_RESOURCE_TIMEOUT_MS;
        long started = System.currentTimeMillis() + 100L;
        LoggingStreamConsumer outConsumer = new LoggingStreamConsumer();
        WarningStreamConsumer errConsumer = new WarningStreamConsumer();
        for (int tryCount = 0; tryCount <= this.maxRetriesOnCrashes; ++tryCount) {
            int returnCode;
            Commandline cmd = this.createCommandLine(resourceTimeoutMs);
            if (tryCount == 0) {
                this.log.info((CharSequence)("executing phantomjs cmd: " + cmd.toString()));
            }
            if ((returnCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)outConsumer, (StreamConsumer)errConsumer, (int)this.getTimeoutInSeconds(started))) >= 0 && returnCode <= 4) {
                return returnCode == 0;
            }
            this.log.warn((CharSequence)String.format("unexpected result %d from phantomjs run #%d (resource timeout %d ms)", returnCode, tryCount + 1, resourceTimeoutMs));
            try {
                Thread.sleep(resourceTimeoutMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resourceTimeoutMs += 500;
        }
        this.log.error((CharSequence)String.format("Got %d unexpected results from phantomjs, giving up.", this.maxRetriesOnCrashes + 1));
        return false;
    }

    private int getTimeoutInSeconds(long started) {
        return (int)((long)this.timeout - (System.currentTimeMillis() - started)) / 1000;
    }

    public boolean canRun() {
        return this.testResultFilename != null && this.testRunner != null && this.phantomjs != null && this.isExecutableAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isExecutableAvailable() {
        if (phantomjsExecutableFound != null) return phantomjsExecutableFound;
        Class<PhantomJsTestRunner> clazz = PhantomJsTestRunner.class;
        synchronized (PhantomJsTestRunner.class) {
            phantomjsExecutableFound = new File(this.phantomjs).canExecute() || this.canExecutePhantomJs();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return phantomjsExecutableFound;
        }
    }

    private boolean canExecutePhantomJs() {
        String[] directoryNames;
        String path = System.getenv("PATH");
        for (String directoryName : directoryNames = org.apache.commons.lang3.StringUtils.split((String)path, (char)File.pathSeparatorChar)) {
            File[] files = new File(directoryName).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return PhantomJsTestRunner.this.phantomjs.equals(name);
                }
            });
            if (files == null || files.length == 0) continue;
            return true;
        }
        this.log.warn((CharSequence)(this.phantomjs + " not found in " + path));
        return false;
    }

    private Commandline createCommandLine(int resourceTimeout) {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.phantomjs);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("--debug=" + String.valueOf(this.phantomjsDebug));
        arguments.add("--web-security=" + String.valueOf(this.phantomjsWebSecurity));
        arguments.add(this.testRunner);
        arguments.add(this.testPageUrl);
        arguments.add(this.testResultFilename);
        arguments.add(String.valueOf(resourceTimeout));
        commandline.addArguments(arguments.toArray(new String[arguments.size()]));
        return commandline;
    }

    public String toString() {
        return "PhantomJsTestRunner{phantomjs=" + this.phantomjs + ", testRunner='" + this.testRunner + '\'' + ", testPageUrl='" + this.testPageUrl + '\'' + ", testResultFilename=" + this.testResultFilename + '}';
    }

    private class WarningStreamConsumer
    implements StreamConsumer {
        private WarningStreamConsumer() {
        }

        public void consumeLine(String line) {
            PhantomJsTestRunner.this.log.warn((CharSequence)line);
        }
    }

    private class LoggingStreamConsumer
    implements StreamConsumer {
        private LoggingStreamConsumer() {
        }

        public void consumeLine(String line) {
            String msg;
            String logLevel;
            Matcher matcher = LOG_LEVEL_PATTERN.matcher(line);
            if (matcher.matches()) {
                logLevel = matcher.group(1);
                msg = matcher.group(2);
            } else {
                logLevel = "DEBUG";
                msg = line;
            }
            if ("ERROR".equals(logLevel)) {
                PhantomJsTestRunner.this.log.error((CharSequence)msg);
            } else if ("WARN".equals(logLevel)) {
                PhantomJsTestRunner.this.log.warn((CharSequence)msg);
            } else if ("INFO".equals(logLevel)) {
                PhantomJsTestRunner.this.log.info((CharSequence)msg);
            } else {
                PhantomJsTestRunner.this.log.debug((CharSequence)msg);
            }
        }
    }
}

