/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.mvnplugin.AbstractJangarooMojo;
import net.jangaroo.properties.Propc;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

@Mojo(name="properties", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class PropertiesMojo
extends AbstractJangarooMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter
    private FileSet properties;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/joo")
    private File apiOutputDirectory;
    @Component
    private MavenProjectHelper projectHelper;

    public File getApiOutputDirectory() {
        return this.apiOutputDirectory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.apiOutputDirectory.exists()) {
            this.getLog().info((CharSequence)("generating AS3 localization api stubs into: " + this.apiOutputDirectory.getPath()));
            this.getLog().debug((CharSequence)("created " + this.apiOutputDirectory.mkdirs()));
        }
        File resourceDirectory = this.getSourceDirectory();
        if (this.properties == null) {
            this.properties = new FileSet();
            this.properties.setDirectory(resourceDirectory.getAbsolutePath());
            this.properties.addInclude("**/*.properties");
        }
        ArrayList<File> sourceFiles = new ArrayList<File>(10);
        for (String srcFileRelativePath : new FileSetManager().getIncludedFiles(this.properties)) {
            sourceFiles.add(new File(resourceDirectory, srcFileRelativePath));
        }
        Propc generator = new Propc();
        try {
            List<File> sourcePath = Collections.singletonList(resourceDirectory.getCanonicalFile());
            generator.generateApi(sourceFiles, sourcePath, this.apiOutputDirectory);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Generation failure", e);
        }
    }
}

