/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.mvnplugin.AbstractCompilerMojo;
import net.jangaroo.jooc.mvnplugin.Type;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class CompilerMojo
extends AbstractCompilerMojo {
    @Parameter(defaultValue="${project.build.directory}")
    private String buildDirectoryPath;
    private File packageOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}/app")
    private File appOutputDirectory;
    @Parameter(defaultValue="${project.build.directory}/temp")
    private File reportOutputDirectory;
    @Parameter
    private Set<String> includes = new HashSet<String>();
    @Parameter
    private Set<String> excludes = new HashSet<String>();
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/joo-api")
    private File apiOutputDirectory;

    @Override
    public File getApiOutputDirectory() {
        return Type.containsJangarooSources(this.getProject()) ? this.apiOutputDirectory : null;
    }

    @Override
    protected List<File> getActionScriptClassPath() {
        return this.getMavenPluginHelper().getActionScriptClassPath(false);
    }

    @Override
    protected List<File> getCompileSourceRoots() {
        return Arrays.asList(this.getSourceDirectory(), this.getGeneratedSourcesDirectory());
    }

    @Override
    protected File getOutputDirectory() {
        return "jangaroo-pkg".equals(this.getProject().getPackaging()) ? this.getPackageOutputDirectory() : this.appOutputDirectory;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    protected Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    protected JoocConfiguration createJoocConfiguration(Log log) throws MojoExecutionException, MojoFailureException {
        JoocConfiguration joocConfiguration = super.createJoocConfiguration(log);
        if (joocConfiguration != null) {
            joocConfiguration.setCatalogOutputDirectory(this.getCatalogOutputDirectory());
            joocConfiguration.setReportOutputDirectory(this.getReportOutputDirectory());
        }
        return joocConfiguration;
    }

    private File getPackageOutputDirectory() {
        if (this.packageOutputDirectory == null) {
            this.packageOutputDirectory = new File(this.buildDirectoryPath + SenchaUtils.getPackagesPath(this.getProject()));
        }
        return this.packageOutputDirectory;
    }
}

