/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaAppConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdExecutor;
import net.jangaroo.jooc.mvnplugin.test.PhantomJsTestRunner;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.eclipse.jetty.maven.plugin.JettyWebAppContext;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class JooTestMojo
extends AbstractMojo {
    private static final int MAXIMUM_NUMBER_OF_RETRIES = 30;
    private static final int WAITING_TIME = 1000;
    private static final String DEFAULT_TEST_APP_JSON = "default.test.app.json";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testOutputDirectory;
    @Parameter(defaultValue="false")
    protected boolean debugTests;
    @Parameter(defaultValue="${project.testResources}")
    protected List<Resource> testResources;
    @Parameter(property="jooUnitJettyPortUpperBound", defaultValue="10200")
    private int jooUnitJettyPortUpperBound;
    @Parameter(property="jooUnitJettyPortLowerBound", defaultValue="10100")
    private int jooUnitJettyPortLowerBound;
    @Parameter(property="jooUnitJettyHost", defaultValue="localhost")
    private String jooUnitJettyHost;
    @Parameter(defaultValue="classic")
    private String toolkit;
    @Inject
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${localRepository}", required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    private File testSourceDirectory;
    @Parameter(defaultValue="${maven.test.skip}")
    private boolean skip;
    @Parameter(defaultValue="${skipTests}")
    private boolean skipTests;
    @Parameter(defaultValue="${skipJooUnitTests}")
    private boolean skipJooUnitTests;
    @Parameter(defaultValue="${interactiveJooUnitTests}")
    private boolean interactiveJooUnitTests;
    @Parameter(defaultValue="${project.build.directory}/surefire-reports/")
    private File testResultOutputDirectory;
    @Parameter
    private String testResultFileName;
    @Parameter(defaultValue="30000")
    private int jooUnitTestExecutionTimeout = 30000;
    @Parameter(defaultValue="5")
    private int jooUnitMaxRetriesOnCrashes = 5;
    @Parameter(defaultValue="localhost")
    private String jooUnitSeleniumRCHost = "localhost";
    @Parameter
    private String testSuite = null;
    @Parameter(defaultValue="4444")
    private int jooUnitSeleniumRCPort = 4444;
    @Parameter(defaultValue="*firefox")
    private String jooUnitSeleniumBrowserStartCommand = "*firefox";
    @Parameter(defaultValue="${maven.test.failure.ignore}")
    private boolean testFailureIgnore;
    @Parameter(property="phantomjs.bin", defaultValue="phantomjs")
    private String phantomBin;
    @Parameter(property="senchaLogLevel")
    private String senchaLogLevel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        boolean doSkip;
        boolean bl = doSkip = this.skip || this.skipTests || this.skipJooUnitTests;
        if (doSkip || this.testSuite == null) {
            this.getLog().info((CharSequence)("Skipping generation of Jangaroo test app: " + (doSkip ? "tests skipped." : "no tests found.")));
        } else {
            this.getLog().info((CharSequence)("Creating Jangaroo test app below " + this.testOutputDirectory));
            this.createWebApp(this.testOutputDirectory);
            new SenchaCmdExecutor(this.testOutputDirectory, "config -prop skip.sass=1 -prop skip.resources=1 then app refresh", this.getLog(), this.senchaLogLevel).execute();
            Server server = this.jettyRunTest(!this.interactiveJooUnitTests);
            String url = this.getTestUrl(server);
            this.getLog().info((CharSequence)("Test-URL: " + url));
            try {
                if (this.interactiveJooUnitTests) {
                    try {
                        server.join();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.checkServerState(server);
                    this.runTests(url);
                }
            }
            finally {
                this.stopServerIgnoreException(server);
            }
        }
    }

    private void checkServerState(Server server) {
        for (int i = 0; i < 30 && !server.isStarted(); ++i) {
            try {
                this.getLog().info((CharSequence)("Server not ready yet i=" + i));
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!server.isStarted()) {
            this.getLog().error((CharSequence)"Could not start jetty server");
        }
    }

    private void runTests(String url) throws MojoFailureException, MojoExecutionException {
        try {
            File testResultOutputFile = new File(this.testResultOutputDirectory, this.getTestResultFileName());
            File phantomTestRunner = new File(this.testResultOutputDirectory, "phantomjs-joounit-page-runner.js");
            FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/net/jangaroo/jooc/mvnplugin/phantomjs-joounit-page-runner.js"), (File)phantomTestRunner);
            PhantomJsTestRunner phantomJsTestRunner = new PhantomJsTestRunner(this.phantomBin, url, testResultOutputFile.getPath(), phantomTestRunner.getPath(), this.jooUnitTestExecutionTimeout, this.jooUnitMaxRetriesOnCrashes, this.getLog());
            if (phantomJsTestRunner.canRun()) {
                this.executePhantomJs(testResultOutputFile, phantomJsTestRunner);
            } else {
                this.executeSelenium(url);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot create local copy of phantomjs-joounit-page-runner.js", (Exception)e);
        }
    }

    private void executePhantomJs(File testResultOutputFile, PhantomJsTestRunner phantomJsTestRunner) throws MojoFailureException, MojoExecutionException {
        this.getLog().info((CharSequence)("running phantomjs: " + phantomJsTestRunner.toString()));
        try {
            boolean exitCode = phantomJsTestRunner.execute();
            if (exitCode) {
                this.evalTestOutput(new FileReader(testResultOutputFile));
            } else {
                JooTestMojo.signalError();
            }
        }
        catch (IOException | ParserConfigurationException | CommandLineException | SAXException e) {
            throw this.wrap((Exception)e);
        }
    }

    protected void createWebApp(File webappDirectory) throws MojoExecutionException {
        if (SenchaUtils.doesSenchaAppExist(webappDirectory)) {
            this.getLog().info((CharSequence)"Sencha app already exists, skip generating one");
            return;
        }
        this.getLog().info((CharSequence)String.format("Generating Sencha App %s for unit tests...", webappDirectory));
        FileHelper.ensureDirectory(webappDirectory);
        SenchaUtils.generateSenchaTestAppFromTemplate(webappDirectory, this.project, SenchaUtils.getSenchaPackageName(this.project), this.testSuite, this.toolkit, this.getLog(), this.senchaLogLevel);
        this.createAppJson();
    }

    private static boolean isTestDependency(Dependency dependency) {
        return "test".equals(dependency.getScope()) && "jar".equals(dependency.getType());
    }

    public void createAppJson() throws MojoExecutionException {
        File appJsonFile = new File(this.project.getBuild().getTestOutputDirectory(), "app.json");
        this.getLog().info((CharSequence)String.format("Generating Sencha App %s for unit tests...", appJsonFile.getPath()));
        SenchaAppConfigBuilder configBuilder = new SenchaAppConfigBuilder();
        try {
            configBuilder.destFile(appJsonFile);
            configBuilder.defaults(DEFAULT_TEST_APP_JSON);
            configBuilder.destFileComment("Auto-generated test application configuration. DO NOT EDIT!");
            configBuilder.require(SenchaUtils.getSenchaPackageName(this.project));
            List projectDependencies = this.project.getDependencies();
            for (Dependency dependency : projectDependencies) {
                if (!JooTestMojo.isTestDependency(dependency)) continue;
                configBuilder.require(SenchaUtils.getSenchaPackageName(dependency.getGroupId(), dependency.getArtifactId()));
            }
            configBuilder.buildFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not build test app.json", (Exception)e);
        }
    }

    protected String getJettyUrl(Server server) {
        String url = "http://" + this.jooUnitJettyHost;
        Connector connector = server.getConnectors()[0];
        if (connector instanceof AbstractNetworkConnector) {
            AbstractNetworkConnector networkConnector = (AbstractNetworkConnector)connector;
            url = url + ":" + (networkConnector.getLocalPort() <= 0 ? networkConnector.getPort() : networkConnector.getLocalPort());
        }
        return url;
    }

    protected Server jettyRunTest(boolean tryPortRange) throws MojoExecutionException {
        JettyWebAppContext handler;
        try {
            handler = new JettyWebAppContext();
            handler.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            ArrayList<org.eclipse.jetty.util.resource.Resource> baseResources = new ArrayList<org.eclipse.jetty.util.resource.Resource>();
            File workspaceDir = SenchaUtils.findClosestSenchaWorkspaceDir(this.project.getBasedir());
            baseResources.add(this.toResource(workspaceDir));
            handler.setBaseResource((org.eclipse.jetty.util.resource.Resource)new ResourceCollection(baseResources.toArray(new org.eclipse.jetty.util.resource.Resource[baseResources.size()])));
            this.getLog().info((CharSequence)("Using base resources " + baseResources));
            ServletHolder servletHolder = new ServletHolder("default", DefaultServlet.class);
            servletHolder.setInitParameter("cacheControl", "no-store, no-cache, must-revalidate, max-age=0");
            handler.addServlet(servletHolder, "/");
            this.getLog().info((CharSequence)"Set servlet cache control to 'do not cache'.");
        }
        catch (Exception e) {
            throw this.wrap(e);
        }
        return this.startJetty((Handler)handler, tryPortRange);
    }

    private org.eclipse.jetty.util.resource.Resource toResource(File file) {
        return org.eclipse.jetty.util.resource.Resource.newResource((File)file);
    }

    private Server startJetty(Handler handler, boolean tryPortRange) throws MojoExecutionException {
        if (tryPortRange && this.jooUnitJettyPortUpperBound != this.jooUnitJettyPortLowerBound) {
            return this.startJettyOnRandomPort(handler);
        }
        try {
            return this.startJettyOnPort(handler, this.jooUnitJettyPortLowerBound);
        }
        catch (Exception e) {
            throw this.wrapJettyException(e, this.jooUnitJettyPortLowerBound);
        }
    }

    private Server startJettyOnRandomPort(Handler handler) throws MojoExecutionException {
        ArrayList<Integer> ports = new ArrayList<Integer>(this.jooUnitJettyPortUpperBound - this.jooUnitJettyPortLowerBound + 1);
        for (int i = this.jooUnitJettyPortLowerBound; i <= this.jooUnitJettyPortUpperBound; ++i) {
            ports.add(i);
        }
        Collections.shuffle(ports);
        int lastPort = (Integer)ports.get(ports.size() - 1);
        Exception finalException = null;
        Iterator iterator = ports.iterator();
        while (iterator.hasNext()) {
            int jooUnitJettyPort = (Integer)iterator.next();
            try {
                return this.startJettyOnPort(handler, jooUnitJettyPort);
            }
            catch (Exception e) {
                if (jooUnitJettyPort != lastPort) {
                    this.getLog().info((CharSequence)String.format("Starting Jetty on port %d failed. Retrying ...", jooUnitJettyPort));
                    continue;
                }
                finalException = e;
            }
        }
        throw this.wrapJettyException(finalException, lastPort);
    }

    private Server startJettyOnPort(Handler handler, int jettyPort) throws Exception {
        Server server = new Server(jettyPort);
        try {
            server.setHandler(handler);
            server.start();
            this.getLog().info((CharSequence)String.format("Started Jetty for unit tests on port %d.", jettyPort));
        }
        catch (Exception e) {
            this.stopServerIgnoreException(server);
            throw e;
        }
        return server;
    }

    protected MojoExecutionException wrap(Exception e) {
        return new MojoExecutionException(e.toString(), e);
    }

    private MojoExecutionException wrapJettyException(Exception e, int jettyPort) {
        this.getLog().error((CharSequence)String.format("Starting Jetty on port %d failed.", jettyPort));
        return new MojoExecutionException(String.format("Cannot start jetty server on port %d.", jettyPort), e);
    }

    protected void stopServerIgnoreException(Server server) {
        try {
            server.stop();
        }
        catch (Exception e1) {
            this.getLog().warn((CharSequence)"Stopping Jetty failed. Never mind.");
        }
    }

    protected String getTestUrl(Server server) throws MojoExecutionException {
        File workspaceDir = SenchaUtils.findClosestSenchaWorkspaceDir(this.project.getBasedir());
        if (workspaceDir == null) {
            throw new MojoExecutionException("No Sencha workspace.json found starting from " + this.project.getBasedir());
        }
        String path = workspaceDir.toURI().relativize(this.testOutputDirectory.toURI()).getPath();
        StringBuilder builder = new StringBuilder(this.getJettyUrl(server)).append("/").append(path).append("?cache");
        if (this.debugTests) {
            builder.append("#joo.debug");
        }
        return builder.toString();
    }

    void executeSelenium(String testsHtmlUrl) throws MojoExecutionException, MojoFailureException {
        this.jooUnitSeleniumRCHost = System.getProperty("SELENIUM_RC_HOST", this.jooUnitSeleniumRCHost);
        try {
            InetAddress.getAllByName(this.jooUnitSeleniumRCHost);
        }
        catch (UnknownHostException e) {
            throw new MojoExecutionException("Cannot resolve host " + this.jooUnitSeleniumRCHost + ". Please specify a host running the selenium remote control or skip tests" + " by -DskipTests", (Exception)e);
        }
        this.getLog().info((CharSequence)("JooTest report directory: " + this.testResultOutputDirectory.getAbsolutePath()));
        DefaultSelenium selenium = new DefaultSelenium(this.jooUnitSeleniumRCHost, this.jooUnitSeleniumRCPort, this.jooUnitSeleniumBrowserStartCommand, testsHtmlUrl);
        try {
            selenium.start();
            this.getLog().debug((CharSequence)("Opening " + testsHtmlUrl));
            selenium.open(testsHtmlUrl);
            this.getLog().debug((CharSequence)("Waiting for test results for " + this.jooUnitTestExecutionTimeout + "ms ..."));
            selenium.waitForCondition("selenium.browserbot.getCurrentWindow().result != null || selenium.browserbot.getCurrentWindow().classLoadingError != null", Integer.toString(this.jooUnitTestExecutionTimeout));
            String classLoadingError = selenium.getEval("selenium.browserbot.getCurrentWindow().classLoadingError");
            if (classLoadingError != null && !classLoadingError.equals("null")) {
                throw new MojoExecutionException(classLoadingError);
            }
            String testResultXml = selenium.getEval("selenium.browserbot.getCurrentWindow().result");
            this.writeResultToFile(testResultXml);
            this.evalTestOutput(new StringReader(testResultXml));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write test results to file", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Cannot create a simple XML Builder", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Cannot parse test result", (Exception)e);
        }
        catch (SeleniumException e) {
            throw new MojoExecutionException("Selenium setup exception", (Exception)((Object)e));
        }
        finally {
            selenium.stop();
        }
    }

    File writeResultToFile(String testResultXml) throws IOException {
        File result = new File(this.testResultOutputDirectory, this.getTestResultFileName());
        FileUtils.writeStringToFile((File)result, (String)testResultXml);
        if (!result.setLastModified(System.currentTimeMillis())) {
            this.getLog().warn((CharSequence)("could not set modification time of file " + result));
        }
        return result;
    }

    private String getTestResultFileName() {
        return this.testResultFileName != null ? this.testResultFileName : "TEST-" + this.project.getArtifactId() + ".xml";
    }

    void evalTestOutput(Reader inStream) throws ParserConfigurationException, IOException, SAXException, MojoFailureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inSource = new InputSource(inStream);
        Document d = dBuilder.parse(inSource);
        NodeList nl = d.getChildNodes();
        NamedNodeMap namedNodeMap = nl.item(0).getAttributes();
        String failures = namedNodeMap.getNamedItem("failures").getNodeValue();
        String errors = namedNodeMap.getNamedItem("errors").getNodeValue();
        String tests = namedNodeMap.getNamedItem("tests").getNodeValue();
        String time = namedNodeMap.getNamedItem("time").getNodeValue();
        String name = namedNodeMap.getNamedItem("name").getNodeValue();
        this.getLog().info((CharSequence)(name + " tests run: " + tests + ", Failures: " + failures + ", Errors: " + errors + ", time: " + time + " ms"));
        if (Integer.parseInt(errors) > 0 || Integer.parseInt(failures) > 0) {
            this.signalFailure();
        }
    }

    private static void signalError() throws MojoExecutionException {
        throw new MojoExecutionException("There are errors");
    }

    private void signalFailure() throws MojoFailureException {
        if (!this.testFailureIgnore) {
            throw new MojoFailureException("There are test failures");
        }
    }

    public void setSkip(boolean b) {
        this.skip = b;
    }

    public void setSkipTests(boolean b) {
        this.skipTests = b;
    }

    public void setTestSourceDirectory(File f) {
        this.testSourceDirectory = f;
    }

    public void setTestResources(List<Resource> resources) {
        this.testResources = resources;
    }

    public void setTestFailureIgnore(boolean b) {
        this.testFailureIgnore = b;
    }

    static {
        org.eclipse.jetty.util.resource.Resource.setDefaultUseCaches((boolean)false);
    }
}

