/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.sencha.executor;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.jangaroo.jooc.mvnplugin.sencha.executor.SenchaCmdLogOutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.Executor;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

public class SenchaCmdExecutor {
    static final long MAX_EXECUTION_TIME = -1L;
    private File workingDirectory;
    private String arguments;
    private final Log log;
    private String senchaLogLevel;

    public SenchaCmdExecutor(File workingDirectory, String arguments, Log log, String senchaLogLevel) {
        this.workingDirectory = workingDirectory;
        this.arguments = arguments;
        this.log = log;
        this.senchaLogLevel = senchaLogLevel;
    }

    public void execute() throws MojoExecutionException {
        String line = "sencha --time " + this.getSenchaLogLevelCmd();
        if (!StringUtils.isEmpty((String)this.arguments)) {
            line = line + " " + this.arguments;
        }
        try {
            CommandLine cmdLine = this.getCommandLine(line);
            this.log.info((CharSequence)String.format("Executing Sencha Cmd '%s' in directory '%s'", line, this.workingDirectory));
            this.internalExecute(cmdLine);
            this.log.debug((CharSequence)"Executed Sencha Cmd successfully");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Execution of Sencha Cmd failed.", (Exception)e);
        }
    }

    private void internalExecute(CommandLine cmdLine) throws IOException {
        Executor executor = this.getExecutor();
        ExecuteWatchdog watchdog = this.getExecuteWatchdog();
        executor.setWatchdog(watchdog);
        executor.setWorkingDirectory(this.workingDirectory);
        executor.setExitValue(0);
        SenchaCmdLogOutputStream logOutputStream = new SenchaCmdLogOutputStream(this.log);
        PumpStreamHandler psh = new PumpStreamHandler((OutputStream)((Object)logOutputStream));
        executor.setStreamHandler((ExecuteStreamHandler)psh);
        executor.execute(cmdLine);
        if (watchdog.killedProcess()) {
            throw new ExecuteException(String.format("Watchdog killed Sencha Cmd process after %s ms.", -1L), 0);
        }
    }

    private String getSenchaLogLevelCmd() {
        String logLevelToUse = this.senchaLogLevel != null ? this.senchaLogLevel : this.getMavenLogLevel();
        String result = "--info";
        if ("debug".equalsIgnoreCase(logLevelToUse)) {
            result = "--debug";
        } else if ("trace".equalsIgnoreCase(logLevelToUse)) {
            result = "--trace";
        } else if ("warn".equalsIgnoreCase(logLevelToUse)) {
            result = "--quiet";
        }
        return result;
    }

    private String getMavenLogLevel() {
        String result = "error";
        if (this.log.isDebugEnabled()) {
            result = "debug";
        } else if (this.log.isInfoEnabled()) {
            result = "info";
        } else if (this.log.isWarnEnabled()) {
            result = "warn";
        }
        return result;
    }

    protected CommandLine getCommandLine(String line) {
        return CommandLine.parse((String)line);
    }

    protected Executor getExecutor() {
        return new DefaultExecutor();
    }

    protected ExecuteWatchdog getExecuteWatchdog() {
        return new ExecuteWatchdog(-1L);
    }
}

