/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.util.FileHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-app", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class SenchaGenerateAppMojo
extends AbstractSenchaMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/app", readonly=true)
    private File workingDirectory;
    @Parameter
    private String applicationClass;

    public String getType() {
        return "app";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"jangaroo-app".equals(this.project.getPackaging())) {
            throw new MojoExecutionException("This goal only supports projects with packaging type \"jangaroo-app\"");
        }
        if (StringUtils.isBlank((CharSequence)this.applicationClass)) {
            throw new MojoExecutionException("\"applicationClass\" is missing. This configuration is mandatory for \"jangaroo-app\" packaging.");
        }
        this.createModule();
    }

    public void createModule() throws MojoExecutionException {
        FileHelper.ensureDirectory(this.workingDirectory);
        if (SenchaUtils.doesSenchaAppExist(this.workingDirectory)) {
            this.getLog().info((CharSequence)"Sencha app already exists, skip generating one");
            return;
        }
        String senchaAppName = SenchaUtils.getSenchaPackageName(this.project);
        SenchaUtils.generateSenchaAppFromTemplate(this.workingDirectory, senchaAppName, this.applicationClass, this.getToolkit(), this.getLog(), this.getSenchaLogLevel());
    }
}

