/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.jangaroo.jooc.mvnplugin.AbstractSenchaMojo;
import net.jangaroo.jooc.mvnplugin.MavenSenchaProfileConfiguration;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaProfileConfiguration;
import net.jangaroo.jooc.mvnplugin.sencha.SenchaUtils;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaPackageConfigBuilder;
import net.jangaroo.jooc.mvnplugin.sencha.configbuilder.SenchaPackageOrAppConfigBuilder;
import net.jangaroo.jooc.mvnplugin.util.MavenDependencyHelper;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractSenchaPackageOrAppMojo<T extends SenchaPackageOrAppConfigBuilder>
extends AbstractSenchaMojo
implements SenchaProfileConfiguration {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    @Component
    private ProjectBuilder projectBuilder;
    @Component
    protected ArtifactHandlerManager artifactHandlerManager;
    @Parameter
    private MavenSenchaProfileConfiguration production;
    @Parameter
    private MavenSenchaProfileConfiguration testing;
    @Parameter
    private MavenSenchaProfileConfiguration development;
    @Parameter
    private List<String> requiredClasses;
    @Parameter
    private List<String> additionalCssNonBundle;
    @Parameter
    private List<String> additionalJsNonBundle;
    @Parameter
    private List<String> additionalCssIncludeInBundle;
    @Parameter
    private List<String> additionalJsIncludeInBundle;
    @Parameter
    private String theme;
    @Parameter(defaultValue="${project.basedir}/src/main/sencha")
    private File senchaSrcDir;

    public abstract String getType();

    public abstract String getJsonConfigFileName();

    protected void configure(SenchaPackageOrAppConfigBuilder configBuilder) throws MojoExecutionException {
        this.configureMetadata(configBuilder);
        this.configureRequires(configBuilder);
        this.configureModule(configBuilder);
        this.configureProfile(configBuilder, null, this);
        this.configureProfile(configBuilder, "production", this.getProduction());
        this.configureProfile(configBuilder, "testing", this.getTesting());
        this.configureProfile(configBuilder, "development", this.getDevelopment());
        this.configureCustomProperties(configBuilder);
    }

    private void configureCustomProperties(SenchaPackageOrAppConfigBuilder configBuilder) throws MojoExecutionException {
        File jsonFile = new File(this.project.getBasedir(), this.getJsonConfigFileName());
        if (jsonFile.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(jsonFile);){
                configBuilder.namesValues((Map)SenchaUtils.getObjectMapper().readValue((InputStream)fileInputStream, Map.class));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not read json file", (Exception)e);
            }
        }
    }

    protected void configureMetadata(SenchaPackageOrAppConfigBuilder configBuilder) throws MojoExecutionException {
        String version = SenchaUtils.getSenchaVersionForMavenVersion(this.project.getVersion());
        if (null == version) {
            throw new MojoExecutionException("Could not determine Sencha version from maven version");
        }
        configBuilder.name(SenchaUtils.getSenchaPackageName(this.project.getGroupId(), this.project.getArtifactId()));
        configBuilder.version(version);
        configBuilder.creator(StringUtils.defaultString((Object)(this.project.getOrganization() != null ? this.project.getOrganization().getName() : "")));
        configBuilder.summary(StringUtils.defaultString((Object)this.project.getDescription()));
    }

    protected void configureProfile(SenchaPackageOrAppConfigBuilder configBuilder, String profileName, SenchaProfileConfiguration senchaProfileConfiguration) throws MojoExecutionException {
        if (null == profileName) {
            AbstractSenchaPackageOrAppMojo.configureProfile(senchaProfileConfiguration, configBuilder);
        } else {
            T profileConfigBuilder = this.createSenchaConfigBuilder();
            AbstractSenchaPackageOrAppMojo.configureProfile(senchaProfileConfiguration, profileConfigBuilder);
            configBuilder.profile(profileName, ((SenchaConfigBuilder)profileConfigBuilder).build());
        }
    }

    protected static void configureProfile(SenchaProfileConfiguration senchaProfileConfiguration, SenchaPackageOrAppConfigBuilder configBuilder) throws MojoExecutionException {
        AbstractSenchaPackageOrAppMojo.addAdditionalResources(configBuilder, "css", senchaProfileConfiguration == null ? Collections.emptyList() : senchaProfileConfiguration.getAdditionalCssNonBundle(), senchaProfileConfiguration == null ? Collections.emptyList() : senchaProfileConfiguration.getAdditionalCssIncludeInBundle());
        AbstractSenchaPackageOrAppMojo.addAdditionalResources(configBuilder, "js", senchaProfileConfiguration == null ? Collections.emptyList() : senchaProfileConfiguration.getAdditionalJsNonBundle(), senchaProfileConfiguration == null ? Collections.emptyList() : senchaProfileConfiguration.getAdditionalJsIncludeInBundle());
    }

    protected void configureRequires(SenchaPackageOrAppConfigBuilder configBuilder) throws MojoExecutionException {
        for (String dependency : this.getRequiredDependencies()) {
            configBuilder.require(dependency);
        }
    }

    protected void configureModule(SenchaPackageOrAppConfigBuilder configBuilder) throws MojoExecutionException {
        String themePackageName;
        boolean useExtend = false;
        if ("code".equals(this.getType())) {
            configBuilder.toolkit(this.getToolkit());
        }
        if ("theme".equals(this.getType())) {
            configBuilder.toolkit(this.getToolkit());
            useExtend = true;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(themePackageName = this.getThemePackageName()))) {
            if (useExtend) {
                ((SenchaPackageConfigBuilder)configBuilder).extend(themePackageName);
            } else {
                configBuilder.theme(themePackageName);
            }
        }
        if ("code".equals(this.getType()) || "theme".equals(this.getType())) {
            this.configureResourcesEntry(configBuilder);
        }
    }

    protected void configureResourcesEntry(SenchaPackageOrAppConfigBuilder configBuilder) {
        configBuilder.resource(SenchaUtils.generateAbsolutePathUsingPlaceholder(this.getType(), "resources"));
    }

    private Set<String> getRequiredDependencies() throws MojoExecutionException {
        LinkedHashSet<String> requiredDependencies = new LinkedHashSet<String>();
        Dependency themeDependency = SenchaUtils.getThemeDependency(this.getTheme(), this.project);
        Dependency remotePackageDependency = MavenDependencyHelper.fromKey(this.getRemotePackagesArtifact());
        List<Dependency> projectDependencies = this.resolveRequiredDependencies(this.project, remotePackageDependency);
        for (Dependency dependency : projectDependencies) {
            String senchaPackageNameForArtifact = SenchaUtils.getSenchaPackageName(dependency.getGroupId(), dependency.getArtifactId());
            if (this.isExtFrameworkDependency(dependency) || !SenchaUtils.isRequiredSenchaDependency(dependency, remotePackageDependency) || MavenDependencyHelper.equalsGroupIdAndArtifactId(dependency, themeDependency)) continue;
            requiredDependencies.add(senchaPackageNameForArtifact);
        }
        return requiredDependencies;
    }

    @Nonnull
    private List<Dependency> resolveRequiredDependencies(@Nonnull MavenProject project, Dependency remotePackages) throws MojoExecutionException {
        ArrayList<Dependency> resolvedDependencies = new ArrayList<Dependency>();
        for (Dependency dependency : project.getDependencies()) {
            if ("pom".equalsIgnoreCase(dependency.getType()) && !MavenDependencyHelper.equalsGroupIdAndArtifactId(dependency, remotePackages)) {
                MavenProject projectFromPom = this.createProjectFromPomDependency(dependency);
                List<Dependency> fromPomDependencies = this.resolveRequiredDependencies(projectFromPom, remotePackages);
                if (fromPomDependencies.isEmpty()) continue;
                resolvedDependencies.addAll(fromPomDependencies);
                continue;
            }
            resolvedDependencies.add(dependency);
        }
        return resolvedDependencies;
    }

    @Nonnull
    private MavenProject createProjectFromPomDependency(@Nonnull Dependency dependency) throws MojoExecutionException {
        DefaultArtifact artifactFromDependency = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getScope(), dependency.getType(), dependency.getClassifier(), this.artifactHandlerManager.getArtifactHandler(dependency.getType()));
        DefaultProjectBuildingRequest request = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        request.setValidationLevel(0);
        request.setProcessPlugins(false);
        request.setResolveDependencies(false);
        try {
            ProjectBuildingResult result = this.projectBuilder.build((Artifact)artifactFromDependency, (ProjectBuildingRequest)request);
            return result.getProject();
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Could not resolve required dependencies of POM dependency " + artifactFromDependency, (Exception)((Object)e));
        }
    }

    protected static void addAdditionalResources(SenchaPackageOrAppConfigBuilder configBuilder, String resourceType, List<String> resourcesNonBundle, List<String> resourcesIncludeInBundle) {
        for (String resource : resourcesNonBundle) {
            configBuilder.cssOrJs(resourceType, resource, false, false);
        }
        for (String resource : resourcesIncludeInBundle) {
            configBuilder.cssOrJs(resourceType, resource, false, true);
        }
    }

    @Nonnull
    private String getThemePackageName() {
        String themePackageName;
        Dependency themeDependency = SenchaUtils.getThemeDependency(this.getTheme(), this.project);
        if (themeDependency == null) {
            themePackageName = org.apache.commons.lang3.StringUtils.defaultString((String)this.getTheme());
            if (this.getTheme() != null) {
                this.getLog().warn((CharSequence)String.format("Could not identify theme dependency. Using theme  \"%s\" from configuration instead.", themePackageName));
            }
        } else {
            themePackageName = SenchaUtils.getSenchaPackageName(themeDependency.getGroupId(), themeDependency.getArtifactId());
            this.getLog().info((CharSequence)String.format("Setting theme to \"%s\"", themePackageName));
        }
        return themePackageName;
    }

    protected abstract T createSenchaConfigBuilder();

    public File getSenchaSrcDir() {
        return this.senchaSrcDir;
    }

    public SenchaProfileConfiguration getProduction() {
        return this.production;
    }

    public SenchaProfileConfiguration getDevelopment() {
        return this.development;
    }

    public SenchaProfileConfiguration getTesting() {
        return this.testing;
    }

    @Override
    @Nonnull
    public List<String> getRequiredClasses() {
        return this.requiredClasses == null ? Collections.emptyList() : this.requiredClasses;
    }

    public String getTheme() {
        return this.theme;
    }

    @Override
    @Nonnull
    public List<String> getAdditionalCssNonBundle() {
        return this.additionalCssNonBundle != null ? ImmutableList.copyOf(this.additionalCssNonBundle) : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<String> getAdditionalJsNonBundle() {
        return this.additionalJsNonBundle != null ? ImmutableList.copyOf(this.additionalJsNonBundle) : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<String> getAdditionalCssIncludeInBundle() {
        return this.additionalCssIncludeInBundle != null ? ImmutableList.copyOf(this.additionalCssIncludeInBundle) : Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<String> getAdditionalJsIncludeInBundle() {
        return this.additionalJsIncludeInBundle != null ? ImmutableList.copyOf(this.additionalJsIncludeInBundle) : Collections.emptyList();
    }
}

