/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.json.JsonArray;
import net.jangaroo.jooc.mvnplugin.JangarooMojo;
import net.jangaroo.utils.CompilerUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.util.IOUtil;

public class GenerateModuleAMDMojo
extends JangarooMojo {
    private File resourceDirectory;
    File outputDirectory;
    private File packageSourceDirectory;
    private File moduleScriptFile;
    protected MavenProject project;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository localRepository;
    private List remoteRepositories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifact artifact = this.project.getArtifact();
        String amdName = GenerateModuleAMDMojo.computeAMDName(artifact.getGroupId(), artifact.getArtifactId());
        File sourceAMDFile = new File(this.resourceDirectory, "META-INF/resources/amd/" + amdName + ".js");
        if (sourceAMDFile.exists()) {
            this.getLog().info((CharSequence)("  existing AMD file " + sourceAMDFile.getPath() + " found, skipping generation."));
            return;
        }
        this.getLog().info((CharSequence)("  no source AMD file " + sourceAMDFile.getPath() + " found, generating one based on Maven dependencies."));
        Writer amdWriter = null;
        try {
            amdWriter = this.createAMDFile(amdName);
            amdWriter.write(String.format("define(%s, ", CompilerUtils.quote((String)amdName)));
            List<String> dependencies = this.getDependencies();
            String amdLibName = amdName + ".lib";
            if (this.getAMDFile(amdLibName).exists()) {
                dependencies.add("lib!" + amdLibName);
            }
            amdWriter.write(new JsonArray(dependencies.toArray()).toString(2, 0));
            amdWriter.write(", function() {\n");
            if (this.moduleScriptFile.exists()) {
                this.getLog().info((CharSequence)("  including " + this.moduleScriptFile.getPath() + " into AMD file..."));
                IOUtil.copy((Reader)new FileReader(this.moduleScriptFile), (Writer)amdWriter);
            } else {
                this.getLog().info((CharSequence)("  no file " + this.moduleScriptFile.getPath() + " found to include into AMD file."));
            }
            amdWriter.write("});");
            amdWriter.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create generated AMD output file.", (Exception)e);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Failed to collect dependencies.", (Exception)((Object)e));
        }
        finally {
            if (amdWriter != null) {
                try {
                    amdWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    protected MavenProject getProject() {
        return this.project;
    }

    protected File getOutputDirectory() {
        return this.isJangarooPackaging() ? new File(this.outputDirectory, "META-INF/resources") : this.packageSourceDirectory;
    }

    public static String computeAMDName(String groupId, String artifactId) {
        return "lib/" + groupId.replace('.', '/') + "/" + artifactId;
    }

    private File getAMDFile(String amdName) {
        return new File(this.getOutputDirectory(), String.format("amd/%s.js", amdName));
    }

    Writer createAMDFile(String amdName) throws IOException {
        File f = this.getAMDFile(amdName);
        if (f.getParentFile().mkdirs()) {
            this.getLog().debug((CharSequence)("created AMD output directory '" + f.getParent() + "'."));
        }
        this.getLog().info((CharSequence)("Creating AMD script '" + f.getAbsolutePath() + "'."));
        return new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
    }

    private List<String> getDependencies() throws ProjectBuildingException {
        return GenerateModuleAMDMojo.getDependencies(this.project, this.getLog(), new String[]{"compile", "runtime"}, this.mavenProjectBuilder, this.remoteRepositories, this.localRepository);
    }

    public static List<String> getDependencies(MavenProject project, Log log, String[] scopes, MavenProjectBuilder mavenProjectBuilder, List remoteRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        HashMap<String, Artifact> artifactByInternalId = new HashMap<String, Artifact>();
        for (Artifact artifact : GenerateModuleAMDMojo.getArtifacts(project)) {
            artifactByInternalId.put(GenerateModuleAMDMojo.getInternalId(artifact), artifact);
        }
        return GenerateModuleAMDMojo.getDependencies(artifactByInternalId, project, log, scopes, mavenProjectBuilder, remoteRepositories, localRepository);
    }

    private static List<String> getDependencies(Map<String, Artifact> artifactByInternalId, MavenProject project, Log log, String[] scopes, MavenProjectBuilder mavenProjectBuilder, List remoteRepositories, ArtifactRepository localRepository) throws ProjectBuildingException {
        LinkedList<String> deps = new LinkedList<String>();
        for (Artifact dep : GenerateModuleAMDMojo.getDependentArtifacts(artifactByInternalId, project)) {
            if (!ArrayUtils.contains((Object[])scopes, (Object)dep.getScope())) continue;
            if ("jar".equals(dep.getType())) {
                String amdName = GenerateModuleAMDMojo.computeAMDName(dep.getGroupId(), dep.getArtifactId());
                File jarFile = dep.getFile();
                try {
                    ZipFile jarZipFile = new ZipFile(jarFile);
                    if (jarZipFile.getEntry("META-INF/resources/amd/" + amdName + ".js") != null) {
                        log.info((CharSequence)("  Adding dependency to AMD module " + amdName + " found in artifact " + jarFile + "."));
                        deps.add(amdName);
                        continue;
                    }
                    log.info((CharSequence)("  No AMD module " + amdName + " found in META-INF/resoures/amd of dependent artifact JAR " + jarFile + ", dependency skipped."));
                }
                catch (IOException e) {
                    log.warn((CharSequence)("Cannot open dependent artifact JAR " + jarFile + ", no dependency generated."));
                }
                continue;
            }
            if (!"pom".equals(dep.getType())) continue;
            MavenProject subProject = mavenProjectBuilder.buildFromRepository(dep, remoteRepositories, localRepository, true);
            deps.addAll(GenerateModuleAMDMojo.getDependencies(artifactByInternalId, subProject, log, scopes, mavenProjectBuilder, remoteRepositories, localRepository));
        }
        return deps;
    }

    public static List<Artifact> getDependentArtifacts(Map<String, Artifact> artifactByInternalId, MavenProject project) throws ProjectBuildingException {
        List<Dependency> dependencies = GenerateModuleAMDMojo.getDependencies(project);
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        for (Dependency dependency : dependencies) {
            Artifact artifact = artifactByInternalId.get(GenerateModuleAMDMojo.getInternalId(dependency));
            if (artifact == null) continue;
            result.add(artifact);
        }
        return result;
    }

    private static String getInternalId(Dependency dep) {
        return dep.getGroupId() + ":" + dep.getArtifactId();
    }

    private static String getInternalId(Artifact art) {
        return art.getGroupId() + ":" + art.getArtifactId();
    }

    public static List<Dependency> getDependencies(MavenProject project) {
        return project.getDependencies();
    }

    private static Set<Artifact> getArtifacts(MavenProject project) {
        return project.getArtifacts();
    }
}

