/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.mvnplugin.AbstractCompilerMojo;
import net.jangaroo.jooc.mvnplugin.GenerateModuleAMDMojo;
import net.jangaroo.utils.CompilerUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;

public class TestCompilerMojo
extends AbstractCompilerMojo {
    private File generatedTestSourcesDirectory;
    private File testOutputDirectory;
    private File testPackageSourceDirectory;
    private File sourceDirectory;
    private File testSourceDirectory;
    private Set<String> testIncludes = new HashSet<String>();
    private Set<String> testExcludes = new HashSet<String>();
    private File tempTestClassesOutputDirectory;
    private String moduleTestClassesJsFile;
    private String testSuite;
    protected boolean skip;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository localRepository;
    private List remoteRepositories;

    @Override
    protected File getApiOutputDirectory() {
        return null;
    }

    @Override
    protected List<File> getCompileSourceRoots() {
        return Arrays.asList(this.testSourceDirectory, this.generatedTestSourcesDirectory);
    }

    @Override
    protected File getOutputDirectory() {
        return this.isJangarooPackaging() ? this.testOutputDirectory : this.testPackageSourceDirectory;
    }

    @Override
    protected File getTempClassesOutputDirectory() {
        return this.tempTestClassesOutputDirectory;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.testIncludes;
    }

    @Override
    protected Set<String> getExcludes() {
        return this.testExcludes;
    }

    @Override
    public String getModuleClassesJsFileName() {
        return this.moduleTestClassesJsFile;
    }

    @Override
    protected List<File> getActionScriptClassPath() {
        ArrayList<File> classPath = new ArrayList<File>(this.getMavenPluginHelper().getActionScriptClassPath(true));
        classPath.add(0, this.sourceDirectory);
        classPath.add(0, this.getGeneratedSourcesDirectory());
        return classPath;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            super.execute();
            if (this.testSuite != null) {
                this.generateTestsAMD();
            }
        }
    }

    private void generateTestsAMD() throws MojoExecutionException {
        File testsAmdFile = new File(this.testOutputDirectory, "amd/tests.js");
        this.getLog().info((CharSequence)"  generating tests.js AMD file based on Maven dependencies...");
        Writer amdWriter = null;
        try {
            amdWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(testsAmdFile), "UTF-8");
            amdWriter.write(String.format("define(\"as3/__TestSuite\", [\n  \"as3/net/jangaroo/joounit/runner/BrowserRunner\",\n  \"as3/%s\"\n], function(BrowserRunner, TestSuite) {\n  return {_: {main: function() {\n        return BrowserRunner._.main(TestSuite._);\n      }}};\n});\n", this.testSuite.replace('.', '/')));
            Artifact artifact = this.getProject().getArtifact();
            String amdLibName = GenerateModuleAMDMojo.computeAMDName(artifact.getGroupId(), artifact.getArtifactId());
            String amdTestLibName = amdLibName + "-test";
            amdWriter.write(String.format("define(%s, [\n", CompilerUtils.quote((String)amdTestLibName)));
            amdWriter.write("  " + CompilerUtils.quote((String)amdLibName));
            List<String> testDependencies = this.getTestDependencies();
            for (String testDependency : testDependencies) {
                amdWriter.write(",\n");
                amdWriter.write("  " + CompilerUtils.quote((String)testDependency));
            }
            amdWriter.write("\n], function() {});\n");
            amdWriter.write("require([\"run!" + amdTestLibName + "!__TestSuite\"]);\n");
            amdWriter.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create generated AMD output file.", (Exception)e);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Failed to collect dependencies.", (Exception)((Object)e));
        }
        finally {
            if (amdWriter != null) {
                try {
                    amdWriter.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private List<String> getTestDependencies() throws ProjectBuildingException {
        return GenerateModuleAMDMojo.getDependencies(this.getProject(), this.getLog(), new String[]{"test"}, this.mavenProjectBuilder, this.remoteRepositories, this.localRepository);
    }
}

