/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class PackageMojo
extends AbstractMojo {
    private MavenProject project;
    private File targetDir;
    private MavenProjectHelper projectHelper;
    private String[] excludes;
    private String finalName;
    private JarArchiver archiver;
    private File manifest;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File defaultManifestFile;
    private boolean useDefaultManifestFile;
    private File outputDirectory;

    public void execute() throws MojoExecutionException {
        File jarFile = new File(this.targetDir, this.finalName + "." + "jar");
        MavenArchiver mavenArchiver = new MavenArchiver();
        mavenArchiver.setArchiver(this.archiver);
        mavenArchiver.setOutputFile(jarFile);
        try {
            if (this.archive.getManifestFile() == null) {
                if (this.useDefaultManifestFile && this.defaultManifestFile.exists()) {
                    this.getLog().info((CharSequence)("Adding existing MANIFEST to archive. Found under: " + this.defaultManifestFile.getPath()));
                    this.archive.setManifestFile(this.defaultManifestFile);
                } else if (this.manifest != null) {
                    this.archive.setManifestFile(this.manifest);
                } else {
                    this.archive.setManifestFile(PackageMojo.createDefaultManifest(this.project));
                }
            }
            if (this.outputDirectory.exists()) {
                this.archiver.addDirectory(this.outputDirectory);
            }
            String groupId = this.project.getGroupId();
            String artifactId = this.project.getArtifactId();
            mavenArchiver.getArchiver().addFile(this.project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            mavenArchiver.createArchive(this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        this.project.getArtifact().setFile(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createDefaultManifest(MavenProject project) throws ManifestException, IOException, ArchiverException {
        Manifest manifest = new Manifest();
        Manifest.Attribute attr = new Manifest.Attribute("Created-By", "Apache Maven");
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Title", project.getName());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Version", project.getVersion());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Vendor-Id", project.getGroupId());
        manifest.addConfiguredAttribute(attr);
        if (project.getOrganization() != null) {
            String vendor = project.getOrganization().getName();
            attr = new Manifest.Attribute("Implementation-Vendor", vendor);
            manifest.addConfiguredAttribute(attr);
        }
        attr = new Manifest.Attribute("Built-By", System.getProperty("user.name"));
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Class-Path", PackageMojo.jangarooDependencies(project));
        manifest.addConfiguredAttribute(attr);
        File mf = File.createTempFile("maven", ".mf");
        mf.deleteOnExit();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(mf));
            manifest.write(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        return mf;
    }

    private static String jangarooDependencies(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            if (!"jar".equals(artifact.getType()) && !"jangaroo".equals(artifact.getType())) continue;
            sb.append(artifact.getArtifactId()).append("-").append(artifact.getVersion()).append(".jar ");
        }
        return sb.toString();
    }
}

