/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceExcerptProvider;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.NamespaceConfiguration;
import net.jangaroo.jooc.mvnplugin.AbstractCompilerMojo;
import net.jangaroo.jooc.mvnplugin.GenerateModuleAMDMojo;
import net.jangaroo.utils.CompilerUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class CompilerMojo
extends AbstractCompilerMojo {
    private File outputDirectory;
    private File packageSourceDirectory;
    private File tempClassesOutputDirectory;
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private String moduleClassesJsFile;
    private String apiOutputDirectory;
    private NamespaceConfiguration[] namespaces;
    private boolean failOnWarning;
    private String encoding;

    @Override
    public File getApiOutputDirectory() {
        return this.isJangarooPackaging() ? new File(this.apiOutputDirectory) : null;
    }

    @Override
    protected List<File> getActionScriptClassPath() {
        return this.getMavenPluginHelper().getActionScriptClassPath(false);
    }

    @Override
    protected List<File> getCompileSourceRoots() {
        return Arrays.asList(this.sourceDirectory, this.getGeneratedSourcesDirectory());
    }

    @Override
    protected File getOutputDirectory() {
        return this.isJangarooPackaging() ? new File(this.outputDirectory, "META-INF/resources") : this.packageSourceDirectory;
    }

    @Override
    protected File getTempClassesOutputDirectory() {
        return this.tempClassesOutputDirectory;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.includes;
    }

    @Override
    protected Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public String getModuleClassesJsFileName() {
        return this.moduleClassesJsFile;
    }

    @Override
    protected JoocConfiguration createJoocConfiguration() throws MojoExecutionException, MojoFailureException {
        JoocConfiguration joocConfiguration = super.createJoocConfiguration();
        if (this.namespaces != null) {
            joocConfiguration.setNamespaces(Arrays.asList(this.namespaces));
        }
        return joocConfiguration;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        try {
            this.processAllJsFiles();
        }
        catch (RuntimeException exc) {
            throw exc;
        }
        catch (MojoFailureException exc) {
            throw exc;
        }
        catch (MojoExecutionException exc) {
            throw exc;
        }
        catch (Exception exc) {
            throw new MojoExecutionException("wrap: " + exc.getMessage(), exc);
        }
    }

    private void processAllJsFiles() throws Exception {
        File aggregationOutputBaseDir = new File(this.getOutputDirectory(), "amd");
        File sourceDirectory = new File(aggregationOutputBaseDir, "as3");
        if (!sourceDirectory.exists()) {
            this.getLog().debug((CharSequence)("generate-lib: source directory " + sourceDirectory + " does not exist; skipping *.lib.js generation."));
            return;
        }
        File aggregationOutputFile = new File(aggregationOutputBaseDir, GenerateModuleAMDMojo.computeAMDName(this.getProject().getGroupId(), this.getProject().getArtifactId()) + ".lib.js");
        aggregationOutputFile.getParentFile().mkdirs();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        scanner.setIncludes(new String[]{"**/*.js"});
        scanner.setExcludes(new String[]{"**/*_properties_*.js"});
        scanner.scan();
        String[] sources = scanner.getIncludedFiles();
        this.getLog().debug((CharSequence)"start generating compressed library");
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        final MessageFormatter messageFormatter = options.errorFormat.toFormatter((SourceExcerptProvider)compiler, false);
        compiler.setErrorManager((ErrorManager)new BasicErrorManager(){
            private int suppressedWarningsCount = 0;

            public void println(CheckLevel level, JSError error) {
                if (level == CheckLevel.ERROR) {
                    CompilerMojo.this.getLog().error((CharSequence)error.format(level, messageFormatter));
                } else if (level == CheckLevel.WARNING) {
                    if ("JSC_PARSE_ERROR".equals(error.getType().key) && error.description.contains("Non-JSDoc comment has annotations")) {
                        ++this.suppressedWarningsCount;
                    } else {
                        CompilerMojo.this.getLog().warn((CharSequence)error.format(level, messageFormatter));
                    }
                }
            }

            protected void printSummary() {
                CompilerMojo.this.getLog().info((CharSequence)String.format("GCC: %d error(s), %d warning(s)%n", this.getErrorCount(), this.getWarningCount() - this.suppressedWarningsCount));
            }
        });
        CompilationLevel.SIMPLE_OPTIMIZATIONS.setOptionsForCompilationLevel(options);
        options.setWarningLevel(DiagnosticGroups.NON_STANDARD_JSDOC, CheckLevel.OFF);
        options.variableRenaming = VariableRenamingPolicy.ALL;
        if (this.isGenerateSourceMaps()) {
            options.sourceMapFormat = SourceMap.Format.V3;
            options.sourceMapOutputPath = aggregationOutputFile.getParent();
            options.sourceMapDetailLevel = SourceMap.DetailLevel.ALL;
            options.sourceMapLocationMappings = new ArrayList();
            String sourcePath = sourceDirectory.getCanonicalPath().replace(File.separatorChar, '/');
            String relativePath = CompilerUtils.getRelativePath((File)aggregationOutputFile.getParentFile(), (File)sourceDirectory, (boolean)false).replace(File.separatorChar, '/');
            options.sourceMapLocationMappings.add(new SourceMap.LocationMapping(sourcePath, relativePath));
        }
        options.setOutputCharset(this.encoding);
        Charset charset = Charset.forName(this.encoding);
        ArrayList<SourceFile> inputs = new ArrayList<SourceFile>();
        for (String source : sources) {
            inputs.add(SourceFile.fromFile((File)new File(sourceDirectory, source), (Charset)charset));
        }
        Result result = compiler.compile(Collections.emptyList(), inputs, options);
        if (this.failOnWarning && result.warnings.length > 0) {
            throw new MojoFailureException("warnings while generating lib => failure! See log: " + result.debugLog);
        }
        if (!result.success) {
            throw new MojoFailureException("errors while generating lib => failure!");
        }
        this.getLog().info((CharSequence)("writing library file " + aggregationOutputFile.getCanonicalPath()));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(aggregationOutputFile), this.encoding);
        writer.write(compiler.toSource());
        if (this.isGenerateSourceMaps()) {
            writer.write("\n//# sourceMappingURL=" + aggregationOutputFile.getName() + ".map");
        }
        IOUtil.close((Writer)writer);
        if (this.isGenerateSourceMaps()) {
            this.getLog().info((CharSequence)"projecting library source map...");
            StringWriter sourceMapWriter = new StringWriter();
            result.sourceMap.appendTo((Appendable)sourceMapWriter, aggregationOutputFile.getName());
            JSONObject sourceMapJson = new JSONObject(sourceMapWriter.toString());
            JSONArray jsSources = (JSONArray)sourceMapJson.get("sources");
            this.getLog().info((CharSequence)("projecting " + jsSources.length() + " *.js source names to *.as."));
            ArrayList<String> asSources = new ArrayList<String>(jsSources.length());
            for (int i = 0; i < jsSources.length(); ++i) {
                String source = (String)jsSources.get(i);
                source = source.replaceFirst(".js$", ".as");
                asSources.add(source);
            }
            sourceMapJson.put("sources", (Object)new JSONArray(asSources));
            String libSourceMapFileName = aggregationOutputFile.getCanonicalPath() + ".map";
            this.getLog().info((CharSequence)("writing library source map " + libSourceMapFileName));
            OutputStreamWriter sourceMapFileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(libSourceMapFileName), this.encoding);
            sourceMapFileWriter.write(sourceMapJson.toString());
            IOUtil.close((Writer)sourceMapFileWriter);
        }
        this.getLog().debug((CharSequence)"end generating compressed library");
    }
}

