/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.mortbay.jetty.plugin.JettyWebAppContext;

public abstract class JooTestMojoBase
extends AbstractMojo {
    protected MavenProject project;
    private File outputDirectory;
    protected File testOutputDirectory;
    protected String testsHtml;
    protected boolean debugTests;
    protected List<Resource> testResources;
    private int jooUnitJettyPortUpperBound = 10200;
    private int jooUnitJettyPortLowerBound = 10100;

    protected static String getJettyUrl(Server server) throws MojoExecutionException {
        String url;
        try {
            url = "http://" + InetAddress.getLocalHost().getCanonicalHostName() + ":" + server.getConnectors()[0].getPort();
        }
        catch (UnknownHostException e) {
            throw new MojoExecutionException("I just don't know my own hostname ... ", (Exception)e);
        }
        return url;
    }

    protected boolean isTestAvailable() {
        for (Resource r : this.testResources) {
            File testFile = new File(r.getDirectory(), this.testsHtml);
            if (!testFile.exists()) continue;
            return true;
        }
        this.getLog().info((CharSequence)("The tests.html file '" + this.testsHtml + "' could not be found. Skipping."));
        return false;
    }

    protected Server jettyRunTest(boolean tryPortRange) throws MojoExecutionException {
        JettyWebAppContext handler;
        try {
            handler = new JettyWebAppContext();
            handler.setWebInfLib(this.findJars());
            handler.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            ArrayList<org.eclipse.jetty.util.resource.Resource> baseResources = new ArrayList<org.eclipse.jetty.util.resource.Resource>();
            baseResources.add(this.toResource(new File(this.outputDirectory, "META-INF/resources")));
            baseResources.add(this.toResource(this.testOutputDirectory));
            for (Resource r : this.testResources) {
                File testResourceDirectory = new File(r.getDirectory());
                if (!testResourceDirectory.exists()) continue;
                baseResources.add(this.toResource(testResourceDirectory));
            }
            handler.setBaseResource((org.eclipse.jetty.util.resource.Resource)new ResourceCollection(baseResources.toArray(new org.eclipse.jetty.util.resource.Resource[baseResources.size()])));
            this.getLog().info((CharSequence)("Using base resources " + baseResources));
            ServletHolder servletHolder = new ServletHolder("default", DefaultServlet.class);
            servletHolder.setInitParameter("cacheControl", "no-store, no-cache, must-revalidate, max-age=0");
            handler.addServlet(servletHolder, "/");
            this.getLog().info((CharSequence)"Set servlet cache control to 'do not cache'.");
        }
        catch (Exception e) {
            throw this.wrap(e);
        }
        return this.startJetty((Handler)handler, tryPortRange);
    }

    protected List<File> findJars() throws DependencyResolutionRequiredException {
        ArrayList<File> jars = new ArrayList<File>();
        for (Object jarUrl : this.project.getTestClasspathElements()) {
            File file = new File((String)jarUrl);
            if (file.isFile()) {
                jars.add(file);
                this.getLog().info((CharSequence)("Test classpath: " + jarUrl));
                continue;
            }
            this.getLog().info((CharSequence)("Ignoring test classpath: " + jarUrl));
        }
        return jars;
    }

    private org.eclipse.jetty.util.resource.Resource toResource(File file) throws MojoExecutionException {
        try {
            return org.eclipse.jetty.util.resource.Resource.newResource((File)file);
        }
        catch (IOException e) {
            throw this.wrap(e);
        }
    }

    private Server startJetty(Handler handler, boolean tryPortRange) throws MojoExecutionException {
        if (tryPortRange && this.jooUnitJettyPortUpperBound != this.jooUnitJettyPortLowerBound) {
            return this.startJettyOnRandomPort(handler);
        }
        try {
            return this.startJettyOnPort(handler, this.jooUnitJettyPortLowerBound);
        }
        catch (Exception e) {
            throw this.wrapJettyException(e, this.jooUnitJettyPortLowerBound);
        }
    }

    private Server startJettyOnRandomPort(Handler handler) throws MojoExecutionException {
        ArrayList<Integer> ports = new ArrayList<Integer>(this.jooUnitJettyPortUpperBound - this.jooUnitJettyPortLowerBound + 1);
        for (int i = this.jooUnitJettyPortLowerBound; i <= this.jooUnitJettyPortUpperBound; ++i) {
            ports.add(i);
        }
        Collections.shuffle(ports);
        int lastPort = (Integer)ports.get(ports.size() - 1);
        Exception finalException = null;
        Iterator i$ = ports.iterator();
        while (i$.hasNext()) {
            int jooUnitJettyPort = (Integer)i$.next();
            try {
                return this.startJettyOnPort(handler, jooUnitJettyPort);
            }
            catch (Exception e) {
                if (jooUnitJettyPort != lastPort) {
                    this.getLog().info((CharSequence)String.format("Starting Jetty on port %d failed. Retrying ...", jooUnitJettyPort));
                    continue;
                }
                finalException = e;
            }
        }
        throw this.wrapJettyException(finalException, lastPort);
    }

    private Server startJettyOnPort(Handler handler, int jettyPort) throws Exception {
        Server server = new Server(jettyPort);
        try {
            server.setHandler(handler);
            server.start();
            this.getLog().info((CharSequence)String.format("Started Jetty for unit tests on port %d.", jettyPort));
        }
        catch (Exception e) {
            this.stopServerIgnoreException(server);
            throw e;
        }
        return server;
    }

    protected MojoExecutionException wrap(Exception e) {
        return new MojoExecutionException(e.toString(), e);
    }

    private MojoExecutionException wrapJettyException(Exception e, int jettyPort) {
        this.getLog().error((CharSequence)String.format("Starting Jetty on port %d failed.", jettyPort));
        return new MojoExecutionException(String.format("Cannot start jetty server on port %d.", jettyPort), e);
    }

    protected void stopServerIgnoreException(Server server) {
        try {
            server.stop();
        }
        catch (Exception e1) {
            this.getLog().warn((CharSequence)"Stopping Jetty failed. Never mind.");
        }
    }

    protected String getTestUrl(Server server) throws MojoExecutionException {
        StringBuilder builder = new StringBuilder(JooTestMojoBase.getJettyUrl(server)).append("/").append(this.testsHtml.replace(File.separatorChar, '/'));
        if (this.debugTests) {
            builder.append("#joo.debug");
        }
        return builder.toString();
    }
}

