/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PhantomJsTestRunner {
    private final String testPageUrl;
    private String testResultFilename;
    private final String phantomjs;
    private final Log log;
    private final String testRunner;
    private final int timeout;

    public PhantomJsTestRunner(String phantomjs, String testPageUrl, String testResultFilename, String testRunner, int timeout, Log log) {
        this.phantomjs = phantomjs;
        this.testPageUrl = testPageUrl;
        this.testResultFilename = testResultFilename;
        this.testRunner = testRunner;
        this.timeout = timeout;
        this.log = log;
    }

    public boolean execute() throws CommandLineException {
        Commandline cmd = this.createCommandLine();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.testRunner);
        arguments.add(this.testPageUrl);
        arguments.add(this.testResultFilename);
        arguments.add(String.valueOf(this.timeout));
        cmd.addArguments(arguments.toArray(new String[arguments.size()]));
        StreamConsumer outConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                PhantomJsTestRunner.this.log.debug((CharSequence)line);
            }
        };
        StreamConsumer errConsumer = new StreamConsumer(){

            public void consumeLine(String line) {
                PhantomJsTestRunner.this.log.warn((CharSequence)line);
            }
        };
        this.log.info((CharSequence)("executing phantomjs cmd: " + cmd.toString()));
        int returnCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)outConsumer, (StreamConsumer)errConsumer, (int)this.timeout);
        return returnCode == 0;
    }

    public boolean canRun() {
        return this.testResultFilename != null && this.testRunner != null && this.phantomjs != null && (new File(this.phantomjs).canExecute() || this.canExecutePhantomJs());
    }

    private boolean canExecutePhantomJs() {
        Commandline commandline = this.createCommandLine();
        commandline.addArguments(new String[]{"--version"});
        final StringBuilder buffer = new StringBuilder();
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                buffer.append(line);
            }
        };
        boolean canExecute = false;
        try {
            boolean bl = canExecute = CommandLineUtils.executeCommandLine((Commandline)commandline, (StreamConsumer)consumer, (StreamConsumer)consumer, (int)1) == 0;
            if (canExecute) {
                this.log.info((CharSequence)("Found phantomjs version: " + buffer.toString()));
            } else {
                this.log.info((CharSequence)("Cannot determine phantomjs version: " + buffer.toString()));
            }
        }
        catch (CommandLineException e) {
            this.log.error((CharSequence)"cannot execute phantomjs", (Throwable)e);
        }
        return canExecute;
    }

    private Commandline createCommandLine() {
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.phantomjs);
        return commandline;
    }

    public String toString() {
        return "PhantomJsTestRunner{phantomjs=" + this.phantomjs + ", testRunner='" + this.testRunner + '\'' + ", testPageUrl='" + this.testPageUrl + '\'' + ", testResultFilename=" + this.testResultFilename + '}';
    }
}

