/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.jangaroo.jooc.mvnplugin.test.JooTestMojoBase;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.jetty.server.Server;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JooTestMojo
extends JooTestMojoBase {
    private File testSourceDirectory;
    private boolean skip;
    private boolean skipTests;
    private File testResultOutputDirectory;
    private String testResultFileName;
    private int jooUnitTestExecutionTimeout = 30000;
    private String jooUnitSeleniumRCHost = "localhost";
    private int jooUnitSeleniumRCPort = 4444;
    private String jooUnitSeleniumBrowserStartCommand = "*firefox";
    private boolean testFailureIgnore;
    private String phantomBin;
    private String phantomTestRunner;
    private String phantomTestSuite;
    private String phantomArgs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip && !this.skipTests && this.isTestAvailable()) {
            this.executeSelenium();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeSelenium() throws MojoExecutionException, MojoFailureException {
        this.jooUnitSeleniumRCHost = System.getProperty("SELENIUM_RC_HOST", this.jooUnitSeleniumRCHost);
        try {
            InetAddress.getAllByName(this.jooUnitSeleniumRCHost);
        }
        catch (UnknownHostException e) {
            throw new MojoExecutionException("Cannot resolve host " + this.jooUnitSeleniumRCHost + ". Please specify a host running the selenium remote control or skip tests" + " by -DskipTests", (Exception)e);
        }
        this.getLog().info((CharSequence)("JooTest report directory: " + this.testResultOutputDirectory.getAbsolutePath()));
        Server server = this.jettyRunTest(true);
        String url = JooTestMojo.getJettyUrl(server);
        DefaultSelenium selenium = new DefaultSelenium(this.jooUnitSeleniumRCHost, this.jooUnitSeleniumRCPort, this.jooUnitSeleniumBrowserStartCommand, url);
        try {
            selenium.start();
            String testsHtmlUrl = url + "/" + this.testsHtml.replace(File.separatorChar, '/');
            this.getLog().debug((CharSequence)("Opening " + testsHtmlUrl));
            selenium.open(testsHtmlUrl);
            this.getLog().debug((CharSequence)("Waiting for test results for " + this.jooUnitTestExecutionTimeout + "ms ..."));
            selenium.waitForCondition("selenium.browserbot.getCurrentWindow().result != null || selenium.browserbot.getCurrentWindow().classLoadingError != null", "" + this.jooUnitTestExecutionTimeout);
            String classLoadingError = selenium.getEval("selenium.browserbot.getCurrentWindow().classLoadingError");
            if (classLoadingError != null && !classLoadingError.equals("null")) {
                throw new MojoExecutionException(classLoadingError);
            }
            String testResultXml = selenium.getEval("selenium.browserbot.getCurrentWindow().result");
            this.writeResultToFile(testResultXml);
            this.evalTestOutput(testResultXml);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write test results to file", (Exception)e);
        }
        catch (ParserConfigurationException e) {
            throw new MojoExecutionException("Cannot create a simple XML Builder", (Exception)e);
        }
        catch (SAXException e) {
            throw new MojoExecutionException("Cannot parse test result", (Exception)e);
        }
        catch (SeleniumException e) {
            if (!this.testFailureIgnore) {
                throw new MojoExecutionException("Selenium setup failure", (Exception)((Object)e));
            }
            this.getLog().warn((CharSequence)"Selenium setup failure", (Throwable)e);
        }
        finally {
            selenium.stop();
            try {
                server.stop();
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    void writeResultToFile(String testResultXml) throws IOException {
        File result = new File(this.testResultOutputDirectory, this.getTestResultFileName());
        FileUtils.writeStringToFile((File)result, (String)testResultXml);
        if (!result.setLastModified(System.currentTimeMillis())) {
            this.getLog().warn((CharSequence)("could not set modification time of file " + result));
        }
    }

    private String getTestResultFileName() {
        if (this.testResultFileName != null) {
            return this.testResultFileName;
        }
        String result = this.phantomTestSuite != null ? this.phantomTestSuite : "TEST-" + this.project.getArtifactId();
        return result + ".xml";
    }

    void evalTestOutput(String testResultXml) throws ParserConfigurationException, IOException, SAXException, MojoFailureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = documentBuilderFactory.newDocumentBuilder();
        StringReader inStream = new StringReader(testResultXml);
        InputSource inSource = new InputSource(inStream);
        Document d = dBuilder.parse(inSource);
        NodeList nl = d.getChildNodes();
        NamedNodeMap namedNodeMap = nl.item(0).getAttributes();
        String failures = namedNodeMap.getNamedItem("failures").getNodeValue();
        String errors = namedNodeMap.getNamedItem("errors").getNodeValue();
        String tests = namedNodeMap.getNamedItem("tests").getNodeValue();
        String time = namedNodeMap.getNamedItem("time").getNodeValue();
        String name = namedNodeMap.getNamedItem("name").getNodeValue();
        this.getLog().info((CharSequence)(name + " tests run: " + tests + ", Failures: " + failures + ", Errors: " + errors + ", time: " + time + " ms"));
        if (Integer.parseInt(errors) > 0 || Integer.parseInt(failures) > 0) {
            this.getLog().info((CharSequence)testResultXml);
            this.signalFailure();
        }
    }

    private void signalFailure() throws MojoFailureException {
        if (!this.testFailureIgnore) {
            throw new MojoFailureException("There are test failures");
        }
    }

    public void setSkip(boolean b) {
        this.skip = b;
    }

    public void setSkipTests(boolean b) {
        this.skipTests = b;
    }

    public void setTestSourceDirectory(File f) {
        this.testSourceDirectory = f;
    }

    public void setTestResources(ArrayList<Resource> resources) {
        this.testResources = resources;
    }

    public void setTestFailureIgnore(boolean b) {
        this.testFailureIgnore = b;
    }

    public void setTestOutputDirectory(File testOutputDirectory) {
        this.testOutputDirectory = testOutputDirectory;
    }
}

