/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PhantomJsTestRunner {
    private static final String JANGAROO_MAVEN_PLUGIN = "jangaroo-maven-plugin";
    private final String testSuite;
    private final String args;
    private final File testOutputDirectory;
    private final File phantomjs;
    private final Log log;
    private final String testRunner;
    private final int timeout;
    private final StringBuffer result = new StringBuffer();

    public PhantomJsTestRunner(File phantomjs, File testOutputDirectory, String testRunner, String testSuite, String phantomArgs, int timeout, Log log) {
        this.phantomjs = phantomjs;
        this.testOutputDirectory = testOutputDirectory;
        this.testRunner = testRunner;
        this.testSuite = testSuite;
        this.args = phantomArgs;
        this.timeout = timeout;
        this.log = log;
    }

    public boolean execute() throws CommandLineException {
        Commandline cmd = new Commandline();
        cmd.setExecutable(this.phantomjs.getAbsolutePath());
        cmd.setWorkingDirectory(this.testOutputDirectory);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.testRunner);
        String startString = "<jangaroo-maven-plugin>";
        String endString = "</jangaroo-maven-plugin>";
        StringBuilder argString = new StringBuilder("(function(c){").append("if(!c['testSuiteName']){ c['testSuiteName'] = '").append(this.testSuite).append("';}").append("if(!c['timeout']){ c['timeout'] = ").append(this.timeout).append(";}").append("if(!c['outputTestResult']){ c['outputTestResult'] = function(s){").append(" if(!joo._outputTestResult){ joo._outputTestResult = function(s){console.error(s)};}").append(" joo._outputTestResult('").append("<jangaroo-maven-plugin>").append("'+s+'").append("</jangaroo-maven-plugin>").append("');}").append("};").append("return c;})").append('(');
        if (this.args != null) {
            argString.append(this.args.replace('\n', ' '));
        } else {
            argString.append("{}");
        }
        argString.append(')');
        String argsFormated = Os.isFamily((String)"unix") ? argString.toString().replace("'", "\"") : argString.toString();
        arguments.add(argsFormated);
        cmd.addArguments(arguments.toArray(new String[arguments.size()]));
        StreamConsumer consumer = new StreamConsumer(){
            int state = 0;

            public void consumeLine(String line) {
                if (this.state == 0) {
                    int index = line.indexOf("<jangaroo-maven-plugin>");
                    if (index > -1) {
                        PhantomJsTestRunner.this.result.append(line.substring(index + "<jangaroo-maven-plugin>".length())).append('\n');
                        ++this.state;
                    } else {
                        PhantomJsTestRunner.this.log.info((CharSequence)line);
                    }
                } else if (this.state == 1) {
                    int index = line.indexOf("</jangaroo-maven-plugin>");
                    if (index > -1) {
                        PhantomJsTestRunner.this.result.append(line.substring(0, index));
                        ++this.state;
                    } else {
                        PhantomJsTestRunner.this.result.append(line);
                    }
                    PhantomJsTestRunner.this.result.append('\n');
                } else {
                    PhantomJsTestRunner.this.log.info((CharSequence)line);
                }
            }
        };
        this.log.info((CharSequence)("executing phantomjs cmd: " + cmd.toString()));
        return 0 == CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)consumer, (StreamConsumer)consumer, (int)this.timeout) && this.result.length() > 0;
    }

    public boolean isTestAvailable() {
        return this.testOutputDirectory != null && (this.testSuiteExists() || this.testsHtmlExists());
    }

    private boolean testsHtmlExists() {
        File file = new File(this.testOutputDirectory, "tests.html");
        boolean exists = file.exists();
        if (!exists) {
            this.log.warn((CharSequence)("cannot find " + file.getAbsolutePath()));
        }
        return exists;
    }

    private boolean testSuiteExists() {
        boolean exists = false;
        if (this.testSuite != null) {
            String fileName = this.testSuite.replace(".", "/");
            File file = new File(this.testOutputDirectory, "/joo/classes/" + fileName + ".js");
            exists = file.exists();
            if (!exists) {
                this.log.warn((CharSequence)("cannot find test suite: " + file.getAbsolutePath()));
            }
        }
        return exists;
    }

    public boolean canRun() {
        return this.testOutputDirectory != null && this.testOutputDirectory.exists() && this.phantomjs != null && this.phantomjs.canExecute() && this.testRunner != null;
    }

    public String toString() {
        return "PhantomJsTestRunner{phantomjs=" + this.phantomjs + ", testRunner='" + this.testRunner + '\'' + ", testSuite='" + this.testSuite + '\'' + ", args='" + this.args + '\'' + ", testOutputDirectory=" + this.testOutputDirectory + '}';
    }

    public String getTestResult() {
        return this.result.toString();
    }
}

