/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import net.jangaroo.jooc.mvnplugin.PackageApplicationMojo;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.FileUtils;

public class JooGenerateTestResourcesMojo
extends PackageApplicationMojo {
    private File outputDirectory;
    private File testPackageSourceDirectory;
    private File testOutputDirectory;
    private boolean skip;
    private boolean skipTests;
    private List<Resource> testResources;

    @Override
    public File getPackageSourceDirectory() {
        return "jangaroo".equals(this.project.getPackaging()) ? this.outputDirectory : this.testPackageSourceDirectory;
    }

    protected boolean isTestAvailable() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException {
        if (!this.skip && !this.skipTests) {
            try {
                if (!this.isTestAvailable()) return;
                this.getLog().info((CharSequence)("Unpacking jangaroo dependencies to " + this.testOutputDirectory));
                this.createWebapp(this.testOutputDirectory);
                for (Resource r : this.testResources) {
                    File testResourceDirectory = new File(r.getDirectory());
                    if (!testResourceDirectory.exists()) continue;
                    FileUtils.copyDirectoryStructureIfModified((File)testResourceDirectory, (File)this.testOutputDirectory);
                }
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot unpack jangaroo dependencies/generate html test page", (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Skipping generation of test resources");
        }
    }

    @Override
    protected void writeThisJangarooModuleScript(File scriptDirectory, Writer jangarooApplicationWriter, Writer jangarooApplicationAllWriter) throws IOException {
        super.writeThisJangarooModuleScript(scriptDirectory, jangarooApplicationWriter, jangarooApplicationAllWriter);
        this.writeModule(scriptDirectory, this.project.getGroupId(), this.project.getArtifactId() + "-test", this.project.getVersion(), jangarooApplicationWriter, jangarooApplicationAllWriter);
    }
}

