/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class PhantomJsTestRunner {
    private final String testSuite;
    private final String args;
    private final File testOutputDirectory;
    private final File phantomjs;
    private final Log log;
    private final String testRunner;

    public PhantomJsTestRunner(File phantomjs, File testOutputDirectory, String testRunner, String testSuite, String args, Log log) {
        this.phantomjs = phantomjs;
        this.testOutputDirectory = testOutputDirectory;
        this.testRunner = testRunner;
        this.testSuite = testSuite;
        this.log = log;
        this.args = args;
    }

    public boolean execute() throws CommandLineException {
        Commandline cmd = new Commandline();
        cmd.setExecutable(this.phantomjs.getAbsolutePath());
        cmd.setWorkingDirectory(this.testOutputDirectory);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.testRunner);
        arguments.add("test=" + this.testSuite);
        if (this.args != null) {
            arguments.add(this.args);
        }
        cmd.addArguments(arguments.toArray(new String[arguments.size()]));
        StreamConsumer consumer = new StreamConsumer(){

            public void consumeLine(String line) {
                PhantomJsTestRunner.this.log.info((CharSequence)line);
            }
        };
        return 0 == CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)consumer, (StreamConsumer)consumer);
    }

    public boolean isTestAvailable() {
        if (this.testOutputDirectory != null && this.testSuite != null) {
            String fileName = this.testSuite.replace(".", "/");
            File file = new File(this.testOutputDirectory, "/joo/classes/" + fileName + ".js");
            boolean exists = file.exists();
            if (!exists) {
                this.log.warn((CharSequence)("cannot find test suite: " + file.getAbsolutePath()));
            }
            return exists;
        }
        return false;
    }

    public boolean canRun() {
        return this.testOutputDirectory != null && this.testOutputDirectory.exists() && this.phantomjs != null && this.phantomjs.canExecute() && this.testRunner != null && this.testSuite != null;
    }

    public String toString() {
        return "PhantomJsTestRunner{phantomjs=" + this.phantomjs + ", testRunner='" + this.testRunner + '\'' + ", testSuite='" + this.testSuite + '\'' + ", args='" + this.args + '\'' + ", testOutputDirectory=" + this.testOutputDirectory + '}';
    }
}

