/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.jangaroo.properties.PropcException;
import net.jangaroo.properties.PropertyClassGenerator;
import net.jangaroo.utils.FileLocations;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public class PropertiesMojo
extends AbstractMojo {
    private MavenProject project;
    private File resourceDirectory;
    private FileSet properties;
    private File generatedSourcesDirectory;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.generatedSourcesDirectory.exists()) {
            this.getLog().info((CharSequence)("generating sources into: " + this.generatedSourcesDirectory.getPath()));
            this.getLog().debug((CharSequence)("created " + this.generatedSourcesDirectory.mkdirs()));
        }
        if (this.properties == null) {
            this.properties = new FileSet();
            this.properties.setDirectory(this.resourceDirectory.getAbsolutePath());
            this.properties.addInclude("**/*.properties");
        }
        FileLocations config = new FileLocations();
        config.setOutputDirectory(this.generatedSourcesDirectory);
        for (String srcFileRelativePath : new FileSetManager().getIncludedFiles(this.properties)) {
            config.addSourceFile(new File(this.resourceDirectory, srcFileRelativePath));
        }
        try {
            config.setSourcePath(Arrays.asList(this.resourceDirectory));
        }
        catch (IOException e) {
            throw new MojoExecutionException("configuration failure", (Exception)e);
        }
        PropertyClassGenerator generator = new PropertyClassGenerator(config);
        try {
            generator.generate();
        }
        catch (PropcException e) {
            throw new MojoExecutionException("Generation failure", (Exception)((Object)e));
        }
    }
}

