/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.jangaroo.properties.PropertiesFileScanner;
import net.jangaroo.properties.PropertyClassGenerator;
import net.jangaroo.properties.model.LocalizationSuite;
import net.jangaroo.utils.log.Log;
import net.jangaroo.utils.log.LogHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.model.fileset.FileSet;

public class PropertiesMojo
extends AbstractMojo {
    private MavenProject project;
    private File resourceDirectory;
    private FileSet properties;
    private File generatedSourcesDirectory;
    MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.generatedSourcesDirectory.exists()) {
            this.getLog().info((CharSequence)("generating sources into: " + this.generatedSourcesDirectory.getPath()));
            this.getLog().debug((CharSequence)("created " + this.generatedSourcesDirectory.mkdirs()));
        }
        MavenLogHandler logHandler = new MavenLogHandler();
        Log.setLogHandler((LogHandler)logHandler);
        if (this.properties == null) {
            this.properties = new FileSet();
            this.properties.setDirectory(this.resourceDirectory.getAbsolutePath());
            this.properties.addInclude("**/*.properties");
        }
        LocalizationSuite suite = new LocalizationSuite(this.properties, this.generatedSourcesDirectory);
        PropertiesFileScanner scanner = new PropertiesFileScanner(suite);
        try {
            scanner.scan();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Scan failure", (Exception)e);
        }
        PropertyClassGenerator generator = new PropertyClassGenerator(suite);
        try {
            generator.generate();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Generation failure", (Exception)e);
        }
        catch (TemplateException e) {
            throw new MojoExecutionException("Generation failure", (Exception)((Object)e));
        }
    }

    class MavenLogHandler
    implements LogHandler {
        List<String> errors = new ArrayList<String>();
        List<String> warnings = new ArrayList<String>();
        Exception lastException;
        String exceptionMsg;
        File currentFile;

        MavenLogHandler() {
        }

        public void setCurrentFile(File file) {
            this.currentFile = file;
        }

        public void error(String message, int lineNumber, int columnNumber) {
            this.errors.add(String.format("ERROR in %s, line %s, column %s: %s", this.currentFile, lineNumber, columnNumber, message));
        }

        public void error(String message, Exception exception) {
            this.exceptionMsg = message;
            if (this.currentFile != null) {
                this.exceptionMsg = this.exceptionMsg + String.format(" in file: %s", this.currentFile);
            }
            this.lastException = exception;
        }

        public void error(String message) {
            this.errors.add(message);
        }

        public void warning(String message) {
            this.warnings.add(message);
        }

        public void warning(String message, int lineNumber, int columnNumber) {
            this.warnings.add(String.format("WARNING in %s, line %s, column %s: %s", this.currentFile, lineNumber, columnNumber, message));
        }

        public void info(String message) {
            PropertiesMojo.this.getLog().info((CharSequence)message);
        }

        public void debug(String message) {
            PropertiesMojo.this.getLog().debug((CharSequence)message);
        }
    }
}

