/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.resource.FileResource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JooTestMojo
extends AbstractMojo {
    protected MavenProject project;
    private File outputDirectory;
    protected File testOutputDirectory;
    protected File testSourceDirectory;
    protected String testsHtml;
    protected List<Resource> testResources;
    protected boolean skip;
    protected boolean skipTests;
    private List<MavenProject> projects;
    private File testResultOutputDirectory;
    private int jooUnitJettyPortUpperBound = 10200;
    private int jooUnitJettyPortLowerBound = 10100;
    private int jooUnitTestExecutionTimeout = 3000;
    private String jooUnitSeleniumRCHost = "localhost";
    private int jooUnitSeleniumRCPort = 4444;
    private String jooUnitSeleniumBrowserStartCommand = "*firefox";
    protected boolean testFailureIgnore;

    protected boolean isTestAvailable() {
        for (Resource r : this.testResources) {
            File testFile = new File(r.getDirectory(), this.testsHtml);
            if (!testFile.exists()) continue;
            return true;
        }
        this.getLog().info((CharSequence)("The tests.html file '" + this.testsHtml + "' could not be found. Skipping."));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip && !this.skipTests && this.isTestAvailable()) {
            String url;
            this.jooUnitSeleniumRCHost = System.getProperty("SELENIUM_RC_HOST", this.jooUnitSeleniumRCHost);
            try {
                InetAddress.getAllByName(this.jooUnitSeleniumRCHost);
            }
            catch (UnknownHostException e) {
                throw new MojoExecutionException("Cannot resolve host " + this.jooUnitSeleniumRCHost + ". Please specify a host running the selenium remote control or skip tests" + " by -DskipTests", (Exception)e);
            }
            this.getLog().info((CharSequence)("JooTest report directory:" + this.testResultOutputDirectory.getAbsolutePath()));
            ResourceHandler handler = new ResourceHandler();
            try {
                handler.setBaseResource((org.eclipse.jetty.util.resource.Resource)new FileResource(this.testOutputDirectory.toURI().toURL()));
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.toString(), (Exception)e);
            }
            catch (URISyntaxException e) {
                throw new MojoExecutionException(e.toString(), (Exception)e);
            }
            Server server = this.startJetty((Handler)handler);
            try {
                url = "http://" + InetAddress.getLocalHost().getHostName() + ":" + server.getConnectors()[0].getPort();
            }
            catch (UnknownHostException e) {
                throw new MojoExecutionException("I just don't know my own hostname ... ", (Exception)e);
            }
            DefaultSelenium selenium = new DefaultSelenium(this.jooUnitSeleniumRCHost, this.jooUnitSeleniumRCPort, this.jooUnitSeleniumBrowserStartCommand, url);
            try {
                selenium.start();
                String testsHtmlUrl = url + "/" + this.testsHtml.replace(File.separatorChar, '/');
                this.getLog().debug((CharSequence)("Opening " + testsHtmlUrl));
                selenium.open(testsHtmlUrl);
                this.getLog().debug((CharSequence)("Waiting for test results for " + this.jooUnitTestExecutionTimeout + "ms ..."));
                selenium.waitForCondition("selenium.browserbot.getCurrentWindow().result != null || selenium.browserbot.getCurrentWindow().classLoadingError != null", "" + this.jooUnitTestExecutionTimeout);
                String classLoadingError = selenium.getEval("selenium.browserbot.getCurrentWindow().classLoadingError");
                if (classLoadingError != null && !classLoadingError.equals("null")) {
                    throw new MojoExecutionException(classLoadingError);
                }
                String testResultXml = selenium.getEval("selenium.browserbot.getCurrentWindow().result");
                this.evalTestOutput(testResultXml);
                File result = new File(this.testResultOutputDirectory, "TEST-" + this.project.getArtifactId() + ".xml");
                FileUtils.writeStringToFile((File)result, (String)testResultXml);
                result.setLastModified(System.currentTimeMillis());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write test results to file", (Exception)e);
            }
            catch (ParserConfigurationException e) {
                throw new MojoExecutionException("Cannot create a simple XML Builder", (Exception)e);
            }
            catch (SAXException e) {
                throw new MojoExecutionException("Cannot parse test result", (Exception)e);
            }
            catch (SeleniumException e) {
                if (!this.testFailureIgnore) {
                    throw new MojoExecutionException("Selenium setup failure", (Exception)((Object)e));
                }
                this.getLog().warn((CharSequence)"Selenium setup failure", (Throwable)e);
            }
            finally {
                selenium.stop();
                try {
                    server.stop();
                }
                catch (Exception e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
    }

    void evalTestOutput(String testResultXml) throws ParserConfigurationException, IOException, SAXException, MojoFailureException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = documentBuilderFactory.newDocumentBuilder();
        StringReader inStream = new StringReader(testResultXml);
        InputSource inSource = new InputSource(inStream);
        Document d = dBuilder.parse(inSource);
        NodeList nl = d.getChildNodes();
        NamedNodeMap namedNodeMap = nl.item(0).getAttributes();
        String failures = namedNodeMap.getNamedItem("failures").getNodeValue();
        String errors = namedNodeMap.getNamedItem("errors").getNodeValue();
        String tests = namedNodeMap.getNamedItem("tests").getNodeValue();
        this.getLog().info((CharSequence)("Tests run: " + tests + ", Failures: " + failures + ", Errors: " + errors + ", Skipped: 0"));
        if (!(this.testFailureIgnore || Integer.parseInt(errors) <= 0 && Integer.parseInt(failures) <= 0)) {
            throw new MojoFailureException("There are test failures");
        }
    }

    private Server startJetty(Handler handler) throws MojoExecutionException {
        Server server;
        if (this.jooUnitJettyPortUpperBound != this.jooUnitJettyPortLowerBound) {
            Random r = new Random(System.currentTimeMillis());
            int jooUnitJettyPort = r.nextInt(this.jooUnitJettyPortUpperBound - this.jooUnitJettyPortLowerBound) + this.jooUnitJettyPortLowerBound;
            server = new Server(jooUnitJettyPort);
            try {
                server.setHandler(handler);
                server.start();
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("Failed starting Jetty on port " + jooUnitJettyPort + " failed. Retrying ..."));
                try {
                    server.stop();
                }
                catch (Exception e1) {
                    this.getLog().error((CharSequence)"Stopping Jetty failed. Never mind.");
                }
                jooUnitJettyPort = r.nextInt(this.jooUnitJettyPortUpperBound - this.jooUnitJettyPortLowerBound) + this.jooUnitJettyPortLowerBound;
                server = new Server(jooUnitJettyPort);
                try {
                    server.setHandler(handler);
                    server.start();
                }
                catch (Exception e1) {
                    this.getLog().info((CharSequence)("Failed starting Jetty on port " + jooUnitJettyPort + " failed. Retrying ..."));
                    try {
                        server.stop();
                    }
                    catch (Exception e2) {
                        this.getLog().error((CharSequence)"Stopping Jetty failed. Never mind.");
                    }
                    jooUnitJettyPort = r.nextInt(this.jooUnitJettyPortUpperBound - this.jooUnitJettyPortLowerBound) + this.jooUnitJettyPortLowerBound;
                    server = new Server(jooUnitJettyPort);
                    try {
                        server.setHandler(handler);
                        server.start();
                    }
                    catch (Exception e2) {
                        this.getLog().error((CharSequence)("Failed starting Jetty on port " + jooUnitJettyPort + " failed. Stop retrying!!"));
                        try {
                            server.stop();
                        }
                        catch (Exception e3) {
                            this.getLog().error((CharSequence)"Stopping Jetty failed. Never mind.");
                        }
                        throw new MojoExecutionException("Cannot start jetty server");
                    }
                }
            }
        } else {
            server = new Server(this.jooUnitJettyPortLowerBound);
            try {
                server.setHandler(handler);
                server.start();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed starting Jetty on port " + this.jooUnitJettyPortLowerBound + " failed."));
                try {
                    server.stop();
                }
                catch (Exception e1) {
                    this.getLog().error((CharSequence)"Stopping Jetty failed. Never mind.");
                }
                throw new MojoExecutionException("Cannot start jetty server on port " + this.jooUnitJettyPortLowerBound);
            }
        }
        return server;
    }
}

