/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class PackageMojo
extends AbstractMojo {
    private MavenProject project;
    private File targetDir;
    MavenProjectHelper projectHelper;
    private String[] excludes;
    private String finalName;
    private JarArchiver archiver;
    private File manifest;
    private File outputDirectory;
    private String moduleJsFile;
    private String moduleClassesJsFile;

    public void execute() throws MojoExecutionException {
        File jsarchive = new File(this.targetDir, this.finalName + "." + "jar");
        try {
            if (this.manifest != null) {
                this.archiver.setManifest(this.manifest);
            } else {
                PackageMojo.createDefaultManifest(this.project, this.archiver);
            }
            if (this.outputDirectory.exists()) {
                this.archiver.addDirectory(this.outputDirectory);
                if (!this.getModuleJsFile().exists() && new File(this.outputDirectory, this.moduleClassesJsFile).exists()) {
                    this.createDefaultModuleJsFile();
                }
            }
            String groupId = this.project.getGroupId();
            String artifactId = this.project.getArtifactId();
            this.archiver.addFile(this.project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            this.archiver.setDestFile(jsarchive);
            this.archiver.createArchive();
            this.archiver.reset();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        this.project.getArtifact().setFile(jsarchive);
    }

    private File getModuleJsFile() {
        return new File(this.outputDirectory, this.moduleJsFile);
    }

    private void createDefaultModuleJsFile() throws IOException {
        File moduleJsFile = this.getModuleJsFile();
        File moduleJsDir = moduleJsFile.getParentFile();
        if (moduleJsDir != null) {
            moduleJsDir.mkdirs();
        }
        this.getLog().info((CharSequence)("Creating Jangaroo module classes loader script '" + moduleJsFile.getAbsolutePath() + "'."));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(moduleJsFile), "UTF-8");
        writer.write("joo.loadModule(\"" + this.project.getGroupId() + "\",\"" + this.project.getArtifactId() + "\");\n");
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDefaultManifest(MavenProject project, JarArchiver jarArchiver) throws ManifestException, IOException, ArchiverException {
        Manifest manifest = new Manifest();
        Manifest.Attribute attr = new Manifest.Attribute("Created-By", "Apache Maven");
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Title", project.getName());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Version", project.getVersion());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Vendor-Id", project.getGroupId());
        manifest.addConfiguredAttribute(attr);
        if (project.getOrganization() != null) {
            String vendor = project.getOrganization().getName();
            attr = new Manifest.Attribute("Implementation-Vendor", vendor);
            manifest.addConfiguredAttribute(attr);
        }
        attr = new Manifest.Attribute("Built-By", System.getProperty("user.name"));
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Class-Path", PackageMojo.jangarooDependencies(project));
        manifest.addConfiguredAttribute(attr);
        File mf = File.createTempFile("maven", ".mf");
        mf.deleteOnExit();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(mf));
            manifest.write(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        jarArchiver.setManifest(mf);
    }

    private static String jangarooDependencies(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        Set dependencyArtifacts = project.getDependencyArtifacts();
        for (Artifact artifact : dependencyArtifacts) {
            if (!"jangaroo".equals(artifact.getType())) continue;
            sb.append(artifact.getArtifactId()).append("-").append(artifact.getVersion()).append(".jar ");
        }
        return sb.toString();
    }
}

