/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.JoocOptions;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCompilerMojo
extends AbstractMojo {
    private Log log = this.getLog();
    private MavenProject project;
    private boolean failOnError = true;
    private boolean debug;
    private boolean enableAssertions;
    private boolean allowDuplicateLocalVariables;
    private boolean verbose;
    private int staleMillis;
    private String debuglevel;
    private String autoSemicolon;
    private File generatedSourcesDirectory;

    public abstract String getModuleClassesJsFileName();

    public File getModuleClassesJsFile() {
        return new File(this.getOutputDirectory(), this.getModuleClassesJsFileName());
    }

    protected abstract List<File> getCompileSourceRoots();

    protected abstract File getOutputDirectory();

    protected File getClassesOutputDirectory() {
        return new File(this.getOutputDirectory(), "joo/classes");
    }

    protected abstract File getTempClassesOutputDirectory();

    public File getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    protected abstract File getApiOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        int result;
        boolean compilationError;
        if (this.getCompileSourceRoots().isEmpty()) {
            this.getLog().info((CharSequence)"No sources to compile");
            return;
        }
        JoocConfiguration configuration = new JoocConfiguration();
        configuration.setDebug(this.debug);
        configuration.setEnableAssertions(this.enableAssertions);
        configuration.setAllowDuplicateLocalVariables(this.allowDuplicateLocalVariables);
        configuration.setVerbose(this.verbose);
        if (this.debug && StringUtils.isNotEmpty((String)this.debuglevel)) {
            if (this.debuglevel.equalsIgnoreCase("lines")) {
                configuration.setDebugLines(true);
            } else if (this.debuglevel.equalsIgnoreCase("source")) {
                configuration.setDebugLines(true);
                configuration.setDebugSource(true);
            } else if (!this.debuglevel.equalsIgnoreCase("none")) {
                throw new IllegalArgumentException("The specified debug level: '" + this.debuglevel + "' is unsupported. " + "Legal values are 'none', 'lines', and 'source'.");
            }
        }
        if (StringUtils.isNotEmpty((String)this.autoSemicolon)) {
            if (this.autoSemicolon.equalsIgnoreCase("error")) {
                configuration.setSemicolonInsertionMode(JoocOptions.SemicolonInsertionMode.ERROR);
            } else if (this.autoSemicolon.equalsIgnoreCase("warn")) {
                configuration.setSemicolonInsertionMode(JoocOptions.SemicolonInsertionMode.WARN);
            } else if (this.autoSemicolon.equalsIgnoreCase("quirks")) {
                configuration.setSemicolonInsertionMode(JoocOptions.SemicolonInsertionMode.QUIRKS);
            } else {
                throw new IllegalArgumentException("The specified semicolon insertion mode: '" + this.autoSemicolon + "' is unsupported. " + "Legal values are 'error', 'warn', and 'quirks'.");
            }
        }
        HashSet<File> sources = new HashSet<File>();
        this.getLog().debug((CharSequence)"starting source inclusion scanner");
        sources.addAll(this.computeStaleSources(this.getSourceInclusionScanner(this.staleMillis)));
        if (sources.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
            return;
        }
        configuration.setSourceFiles(new ArrayList(sources));
        configuration.setSourcePath(this.getCompileSourceRoots());
        configuration.setClassPath(this.getActionScriptClassPath());
        configuration.setOutputDirectory(this.getClassesOutputDirectory());
        configuration.setApiOutputDirectory(this.getApiOutputDirectory());
        if (this.getLog().isDebugEnabled()) {
            this.log.debug((CharSequence)("Source path: " + configuration.getSourcePath().toString().replace(',', '\n')));
            this.log.debug((CharSequence)("Class path: " + configuration.getClassPath().toString().replace(',', '\n')));
            this.log.debug((CharSequence)("Output directory: " + configuration.getOutputDirectory()));
            if (configuration.getApiOutputDirectory() != null) {
                this.log.debug((CharSequence)("API output directory: " + configuration.getApiOutputDirectory()));
            }
        }
        boolean bl = compilationError = (result = this.compile(configuration)) != 0;
        if (!compilationError) {
            configuration.setDebug(false);
            configuration.setDebugLines(false);
            configuration.setDebugSource(false);
            configuration.setOutputDirectory(this.getTempClassesOutputDirectory());
            configuration.setApiOutputDirectory(null);
            result = this.compile(configuration);
            if (result == 0) {
                this.buildOutputFile(this.getTempClassesOutputDirectory(), this.getModuleClassesJsFile());
            }
            compilationError &= result != 0;
        }
        List<CompilerError> messages = Collections.emptyList();
        if (compilationError && this.failOnError) {
            this.getLog().info((CharSequence)"-------------------------------------------------------------");
            this.getLog().error((CharSequence)"COMPILATION ERROR : ");
            this.getLog().info((CharSequence)"-------------------------------------------------------------");
            if (messages != null) {
                for (CompilerError message : messages) {
                    this.getLog().error((CharSequence)message.toString());
                }
                this.getLog().info((CharSequence)(messages.size() + (messages.size() > 1 ? " errors " : "error")));
                this.getLog().info((CharSequence)"-------------------------------------------------------------");
            }
            throw new MojoFailureException("Compilation failed");
        }
        for (CompilerError message : messages) {
            this.getLog().warn((CharSequence)message.toString());
        }
    }

    protected List<File> getActionScriptClassPath() {
        ArrayList<File> classPath = new ArrayList<File>();
        classPath.add(new File(this.project.getBasedir(), "src/main/joo-api"));
        Set<Artifact> dependencies = this.getArtifacts();
        for (Artifact dependency : dependencies) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Dependency: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + "type: " + dependency.getType()));
            }
            if (dependency.isOptional() || !"jangaroo".equals(dependency.getType())) continue;
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("adding to classpath: jangaroo dependency [" + dependency.toString() + "]"));
            }
            classPath.add(dependency.getFile());
        }
        return classPath;
    }

    private void buildOutputFile(File tempOutputDir, File outputFile) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.log.debug((CharSequence)("Output file: " + outputFile));
        }
        try {
            File outputFileDirectory = outputFile.getParentFile();
            if (!outputFileDirectory.exists()) {
                outputFileDirectory.mkdirs();
            }
            List files = FileUtils.getFiles((File)tempOutputDir, (String)"**/*.js", (String)"**/*_properties_*.js");
            OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");
            int tempOutputDirPathLength = tempOutputDir.getAbsolutePath().length() + 1;
            for (File file : files) {
                String className = file.getAbsolutePath();
                className = className.substring(tempOutputDirPathLength, className.length() - ".js".length());
                className = className.replace(File.separatorChar, '.');
                fos.write("// class " + className + "\n");
                IOUtil.copy((InputStream)new FileInputStream(file), (Writer)fos, (String)"UTF-8");
                ((Writer)fos).write(10);
            }
            ((Writer)fos).close();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.toString());
        }
    }

    private int compile(JoocConfiguration config) throws MojoExecutionException {
        File outputDirectory = config.getOutputDirectory();
        if (!outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create output directory " + outputDirectory.getAbsolutePath());
        }
        File apiOutputDirectory = this.getApiOutputDirectory();
        if (apiOutputDirectory != null && !apiOutputDirectory.exists() && !apiOutputDirectory.mkdirs()) {
            throw new MojoExecutionException("Failed to create api output directory " + apiOutputDirectory.getAbsolutePath());
        }
        List sources = config.getSourceFiles();
        this.log.info((CharSequence)("Compiling " + sources.size() + " joo source file" + (sources.size() == 1 ? "" : "s") + " to " + outputDirectory));
        Jooc jooc = new Jooc();
        return jooc.run(config);
    }

    private Set<File> computeStaleSources(SourceInclusionScanner scanner) throws MojoExecutionException {
        File outputDirectory = this.getClassesOutputDirectory();
        scanner.addSourceMapping((SourceMapping)new SuffixMapping(".as", ".js"));
        this.getLog().debug((CharSequence)"Searching for");
        HashSet<File> staleSources = new HashSet<File>();
        for (File rootFile : this.getCompileSourceRoots()) {
            if (!rootFile.isDirectory()) continue;
            try {
                this.getLog().debug((CharSequence)("scanner.getIncludedSources(" + rootFile + ", " + outputDirectory + ")"));
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + rootFile.getAbsolutePath() + "' " + "for stale files to recompile.", (Exception)((Object)e));
            }
        }
        return staleSources;
    }

    protected abstract SourceInclusionScanner getSourceInclusionScanner(int var1);

    protected SourceInclusionScanner getSourceInclusionScanner(Set<String> includes, Set<String> excludes, int staleMillis) {
        StaleSourceScanner scanner;
        if (includes.isEmpty() && excludes.isEmpty()) {
            scanner = new StaleSourceScanner((long)staleMillis);
        } else {
            if (includes.isEmpty()) {
                includes.add("**/*.as");
            }
            scanner = new StaleSourceScanner((long)staleMillis, includes, excludes);
        }
        return scanner;
    }

    protected SourceInclusionScanner getSourceInclusionScanner(Set<String> includes, Set<String> excludes, String inputFileEnding) {
        SimpleSourceInclusionScanner scanner;
        if (includes.isEmpty() && excludes.isEmpty()) {
            includes = Collections.singleton("**/*." + inputFileEnding);
            scanner = new SimpleSourceInclusionScanner(includes, Collections.EMPTY_SET);
        } else {
            if (includes.isEmpty()) {
                includes.add("**/*." + inputFileEnding);
            }
            scanner = new SimpleSourceInclusionScanner(includes, excludes);
        }
        return scanner;
    }

    private Set<Artifact> getArtifacts() {
        return this.project.getArtifacts();
    }

    protected boolean isJangarooPackaging() {
        return "jangaroo".equals(this.project.getPackaging());
    }
}

