/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.InputStream;
import java.util.Set;
import net.jangaroo.jooc.mvnplugin.PackageApplicationMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class WarPackageMojo
extends PackageApplicationMojo {
    private File webappDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.excludeFromWarPackaging();
        this.createWebapp(this.webappDirectory);
    }

    private void excludeFromWarPackaging() {
        this.getLog().info((CharSequence)"excludeFromWarPackaging");
        String pluginGroupId = "org.apache.maven.plugins";
        String pluginArtifactId = "maven-war-plugin";
        if (this.project.getBuildPlugins() != null) {
            for (Object o : this.project.getBuildPlugins()) {
                Xpp3Dom excludes;
                Plugin plugin = (Plugin)o;
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                Xpp3Dom dom = (Xpp3Dom)plugin.getConfiguration();
                if (dom == null) {
                    dom = new Xpp3Dom("configuration");
                    plugin.setConfiguration((Object)dom);
                }
                if ((excludes = dom.getChild("packagingExcludes")) == null) {
                    excludes = new Xpp3Dom("packagingExcludes");
                    dom.addChild(excludes);
                    excludes.setValue("");
                } else if (excludes.getValue().trim().length() > 0) {
                    excludes.setValue(excludes.getValue() + ",");
                }
                Set<Artifact> dependencies = this.getArtifacts();
                this.getLog().debug((CharSequence)("Size of getArtifacts: " + dependencies.size()));
                String additionalExcludes = "";
                for (Artifact dependency : dependencies) {
                    this.getLog().debug((CharSequence)("Dependency: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + "type: " + dependency.getType()));
                    if (dependency.isOptional() || !"jangaroo".equals(dependency.getType())) continue;
                    this.getLog().debug((CharSequence)("Excluding jangaroo dependency form war plugin [" + dependency.toString() + "]"));
                    additionalExcludes = additionalExcludes + "WEB-INF" + File.separator + "lib" + File.separator + dependency.getArtifactId() + "-" + dependency.getVersion() + ".jar,";
                    additionalExcludes = additionalExcludes + "WEB-INF" + File.separator + "lib" + File.separator + dependency.getGroupId() + "-" + dependency.getArtifactId() + "-" + dependency.getVersion() + ".jar,";
                }
                excludes.setValue(excludes.getValue() + additionalExcludes);
            }
        }
    }

    private static class WarPackageArchiveFilter
    implements ArchiveFileFilter {
        private WarPackageArchiveFilter() {
        }

        public boolean include(InputStream dataStream, String entryName) throws ArchiveFilterException {
            return !entryName.startsWith("META-INF");
        }
    }
}

