/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.mvnplugin.test.AbstractJooTestMojo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.util.FileUtils;

public class JooGenerateTestResourcesMojo
extends AbstractJooTestMojo {
    private MavenProject project;
    private ZipUnArchiver unarchiver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private File outputDirectory;
    private File outputFileName;
    private MavenProjectBuilder mavenProjectBuilder;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            try {
                if (!this.isTestAvailable()) return;
                this.testOutputDirectory.mkdir();
                this.getLog().info((CharSequence)("Unpacking jangaroo dependencies to " + this.testOutputDirectory));
                this.unpack();
                this.copyMainJsAndClasses();
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot unpack jangaroo dependencies/generate html test page", (Exception)e);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Cannot unpack jangaroo dependencies/generate html test page", (Exception)((Object)e));
            }
        } else {
            this.getLog().info((CharSequence)"Skipping generation of test resources");
        }
    }

    private void copyMainJsAndClasses() throws IOException {
        for (Resource r : this.testResources) {
            FileUtils.copyDirectoryStructureIfModified((File)new File(r.getDirectory()), (File)this.testOutputDirectory);
        }
        File scriptsDir = new File(this.testOutputDirectory, "scripts");
        scriptsDir.mkdirs();
        if (this.outputFileName.exists()) {
            FileUtils.copyFileToDirectoryIfModified((File)this.outputFileName, (File)scriptsDir);
        } else {
            this.getLog().info((CharSequence)("Cannot copy file " + this.outputFileName + ". It does not exist."));
        }
        if (this.outputDirectory.exists()) {
            File dest = new File(scriptsDir, "classes");
            this.getLog().info((CharSequence)("copy " + this.outputDirectory + " to " + dest));
            FileUtils.copyDirectoryStructureIfModified((File)this.outputDirectory, (File)dest);
        } else {
            this.getLog().info((CharSequence)("Cannot copy from " + this.outputDirectory + ". It does not exist."));
        }
    }

    private String getInternalId(Artifact art) {
        return art.getGroupId() + ":" + art.getArtifactId();
    }

    public void unpack() throws IOException, ArchiverException {
        this.unarchiver.setOverwrite(false);
        this.unarchiver.setArchiveFilters(Collections.singletonList(new MetaInfArchiveFileFilter()));
        for (Artifact dependency : this.project.getTestArtifacts()) {
            this.getLog().debug((CharSequence)("Dependency: " + this.getInternalId(dependency) + " type: " + dependency.getType()));
            if (dependency.isOptional() || !"jangaroo".equals(dependency.getType())) continue;
            this.unarchiver.setDestFile(null);
            this.unarchiver.setDestDirectory(this.testOutputDirectory);
            this.unarchiver.setSourceFile(dependency.getFile());
            this.unarchiver.extract();
        }
    }

    private static class MetaInfArchiveFileFilter
    implements ArchiveFileFilter {
        private MetaInfArchiveFileFilter() {
        }

        public boolean include(InputStream dataStream, String entryName) throws ArchiveFilterException {
            return !entryName.startsWith("META-INF");
        }
    }
}

