/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.archiver.ArchiveFileFilter;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class WarPackageMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProjectBuilder mavenProjectBuilder;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private File packageSourceDirectory;
    private File webappDirectory;
    private ZipUnArchiver unarchiver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.webappDirectory.mkdirs();
        try {
            this.excludeFromWarPackaging();
            this.unpack(this.webappDirectory);
            this.copyJangarooOutput(this.webappDirectory);
            this.concatModuleScripts(new File(this.webappDirectory, "scripts"));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to unpack javascript dependencies", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create jangaroo-modules.js", (Exception)e);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Failed to create jangaroo-modules.js", (Exception)((Object)e));
        }
    }

    public void unpack(File target) throws ArchiverException {
        this.unarchiver.setOverwrite(false);
        this.unarchiver.setArchiveFilters(Collections.singletonList(new WarPackageArchiveFilter()));
        Set<Artifact> dependencies = this.getArtifacts();
        for (Artifact dependency : dependencies) {
            this.getLog().debug((CharSequence)("Dependency: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + "type: " + dependency.getType()));
            if (dependency.isOptional() || !"jangaroo".equals(dependency.getType())) continue;
            this.getLog().debug((CharSequence)("Unpacking jangaroo dependency [" + dependency.toString() + "]"));
            this.unarchiver.setSourceFile(dependency.getFile());
            this.unpack(dependency, target);
        }
    }

    public void unpack(Artifact artifact, File target) throws ArchiverException {
        this.unarchiver.setSourceFile(artifact.getFile());
        target.mkdirs();
        this.unarchiver.setDestDirectory(target);
        this.unarchiver.setOverwrite(false);
        try {
            this.unarchiver.extract();
        }
        catch (Exception e) {
            throw new ArchiverException("Failed to extract javascript artifact to " + target, (Throwable)e);
        }
    }

    public static List<String> sort(Map<String, List<String>> artifact2directDependencies) {
        LinkedList<String> alreadyOut = new LinkedList<String>();
        while (!artifact2directDependencies.isEmpty()) {
            String currentDep = WarPackageMojo.goDeep(artifact2directDependencies.keySet().iterator().next(), artifact2directDependencies);
            WarPackageMojo.removeAll(currentDep, artifact2directDependencies);
            alreadyOut.add(currentDep);
        }
        return alreadyOut;
    }

    private static String goDeep(String start, Map<String, List<String>> artifact2directDependencies) {
        while (artifact2directDependencies.get(start) != null && !artifact2directDependencies.get(start).isEmpty()) {
            start = artifact2directDependencies.get(start).iterator().next();
        }
        return start;
    }

    private static void removeAll(String toBeRemoved, Map<String, List<String>> artifact2directDependencies) {
        artifact2directDependencies.remove(toBeRemoved);
        for (List<String> strings : artifact2directDependencies.values()) {
            strings.remove(toBeRemoved);
        }
    }

    private static String getInternalId(Dependency dep) {
        return dep.getGroupId() + ":" + dep.getArtifactId();
    }

    private static String getInternalId(Artifact art) {
        return art.getGroupId() + ":" + art.getArtifactId();
    }

    private void copyJangarooOutput(File target) throws IOException {
        if (!this.packageSourceDirectory.exists()) {
            this.getLog().debug((CharSequence)("No Jangaroo compiler output directory " + this.packageSourceDirectory.getAbsolutePath() + ", skipping copy Jangaroo output."));
        } else {
            this.getLog().info((CharSequence)("Copying Jangaroo output from " + this.packageSourceDirectory + " to " + target));
            FileUtils.copyDirectoryStructureIfModified((File)this.packageSourceDirectory, (File)target);
            if (new File(this.packageSourceDirectory, "jangaroo-module.js").exists()) {
                File copiedJangarooModuleFile = new File(target, "jangaroo-module.js");
                if (copiedJangarooModuleFile.delete()) {
                    this.getLog().info((CharSequence)("File " + copiedJangarooModuleFile.getAbsolutePath() + " removed from copy."));
                } else {
                    this.getLog().warn((CharSequence)("Copied file " + copiedJangarooModuleFile.getAbsolutePath() + " could not be cleaned up."));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void concatModuleScripts(File scriptDirectory) throws IOException, ProjectBuildingException {
        List<Artifact> jooArtifacts = this.getJangarooDependencies();
        Map<String, List<String>> artifact2Project = this.computeDependencyGraph(jooArtifacts);
        this.getLog().debug((CharSequence)("artifact2Project : " + artifact2Project));
        List<String> depsLineralized = WarPackageMojo.sort(artifact2Project);
        this.getLog().debug((CharSequence)("depsLineralized  : " + depsLineralized));
        Writer fw = this.createJangarooModulesFile(scriptDirectory);
        try {
            fw.write("// This file contains collected JavaScript code from dependent Jangaroo modules.\n\n");
            Map<String, Artifact> internalId2Artifact = this.artifactByInternalId(jooArtifacts);
            for (String dependency : depsLineralized) {
                Artifact artifact = internalId2Artifact.get(dependency);
                if (artifact == null) continue;
                this.includeJangarooModuleScript(artifact, fw);
            }
            File jangarooModuleFile = new File(this.packageSourceDirectory, "jangaroo-module.js");
            if (jangarooModuleFile.exists()) {
                this.writeJangarooModuleScript(this.project.getArtifact(), new FileInputStream(jangarooModuleFile), fw);
            } else {
                this.getLog().debug((CharSequence)("No jangaroo-module.js file in " + this.packageSourceDirectory.getAbsolutePath()));
            }
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"IOException on close ignored.", (Throwable)e);
            }
        }
    }

    private Writer createJangarooModulesFile(File scriptDirectory) throws IOException {
        scriptDirectory.mkdirs();
        File f = new File(scriptDirectory, "jangaroo-modules.js");
        this.getLog().info((CharSequence)("Creating Jangaroo collected code script '" + f.getAbsolutePath() + "'."));
        return new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
    }

    private void includeJangarooModuleScript(Artifact artifact, Writer fw) throws IOException {
        ZipFile zipFile = new ZipFile(artifact.getFile());
        ZipEntry zipEntry = zipFile.getEntry("jangaroo-module.js");
        if (zipEntry != null) {
            InputStream jooModuleInputStream = zipFile.getInputStream(zipEntry);
            this.writeJangarooModuleScript(artifact, jooModuleInputStream, fw);
        } else {
            this.getLog().debug((CharSequence)("No jangaroo-module.js in " + artifact));
        }
    }

    private void writeJangarooModuleScript(Artifact artifact, InputStream jooModuleInputStream, Writer fw) throws IOException {
        String fullAtifactName = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        this.getLog().info((CharSequence)("Appending jangaroo-module.js from " + fullAtifactName));
        fw.write("// FROM " + fullAtifactName + ":\n");
        IOUtil.copy((InputStream)jooModuleInputStream, (Writer)fw, (String)"UTF-8");
        fw.write(10);
    }

    private Map<String, Artifact> artifactByInternalId(List<Artifact> jooArtifacts) {
        HashMap<String, Artifact> internalId2Artifact = new HashMap<String, Artifact>();
        for (Artifact artifact : jooArtifacts) {
            String internalId = WarPackageMojo.getInternalId(artifact);
            internalId2Artifact.put(internalId, artifact);
        }
        return internalId2Artifact;
    }

    private List<Artifact> getJangarooDependencies() {
        ArrayList<Artifact> jooArtifacts = new ArrayList<Artifact>();
        for (Artifact dependency : this.getArtifacts()) {
            if (!"jangaroo".equals(dependency.getType())) continue;
            jooArtifacts.add(dependency);
        }
        return jooArtifacts;
    }

    private Map<String, List<String>> computeDependencyGraph(List<Artifact> artifacts) throws ProjectBuildingException {
        HashMap<String, List<String>> artifact2Project = new HashMap<String, List<String>>();
        for (Artifact artifact : artifacts) {
            MavenProject mp = this.mavenProjectBuilder.buildFromRepository(artifact, this.remoteRepositories, this.localRepository, true);
            LinkedList<String> deps = new LinkedList<String>();
            for (Dependency dep : WarPackageMojo.getDependencies(mp)) {
                if (!"jangaroo".equals(dep.getType())) continue;
                deps.add(WarPackageMojo.getInternalId(dep));
            }
            String internalId = WarPackageMojo.getInternalId(artifact);
            artifact2Project.put(internalId, deps);
        }
        return artifact2Project;
    }

    private void excludeFromWarPackaging() {
        this.getLog().info((CharSequence)"excludeFromWarPackaging");
        String pluginGroupId = "org.apache.maven.plugins";
        String pluginArtifactId = "maven-war-plugin";
        if (this.project.getBuildPlugins() != null) {
            for (Object o : this.project.getBuildPlugins()) {
                Xpp3Dom excludes;
                Plugin plugin = (Plugin)o;
                if (!pluginGroupId.equals(plugin.getGroupId()) || !pluginArtifactId.equals(plugin.getArtifactId())) continue;
                Xpp3Dom dom = (Xpp3Dom)plugin.getConfiguration();
                if (dom == null) {
                    dom = new Xpp3Dom("configuration");
                    plugin.setConfiguration((Object)dom);
                }
                if ((excludes = dom.getChild("packagingExcludes")) == null) {
                    excludes = new Xpp3Dom("packagingExcludes");
                    dom.addChild(excludes);
                    excludes.setValue("");
                } else if (excludes.getValue().trim().length() > 0) {
                    excludes.setValue(excludes.getValue() + ",");
                }
                Set<Artifact> dependencies = this.getArtifacts();
                this.getLog().debug((CharSequence)("Size of getArtifacts: " + dependencies.size()));
                String additionalExcludes = "";
                for (Artifact dependency : dependencies) {
                    this.getLog().debug((CharSequence)("Dependency: " + dependency.getGroupId() + ":" + dependency.getArtifactId() + "type: " + dependency.getType()));
                    if (dependency.isOptional() || !"jangaroo".equals(dependency.getType())) continue;
                    this.getLog().debug((CharSequence)("Excluding jangaroo dependency form war plugin [" + dependency.toString() + "]"));
                    additionalExcludes = additionalExcludes + "WEB-INF" + File.separator + "lib" + File.separator + dependency.getArtifactId() + "-" + dependency.getVersion() + ".jar,";
                    additionalExcludes = additionalExcludes + "WEB-INF" + File.separator + "lib" + File.separator + dependency.getGroupId() + "-" + dependency.getArtifactId() + "-" + dependency.getVersion() + ".jar,";
                }
                additionalExcludes = additionalExcludes + "jangaroo-module.js";
                excludes.setValue(excludes.getValue() + additionalExcludes);
            }
        }
    }

    private static List<Dependency> getDependencies(MavenProject mp) {
        return mp.getDependencies();
    }

    private Set<Artifact> getArtifacts() {
        return this.project.getArtifacts();
    }

    private static class WarPackageArchiveFilter
    implements ArchiveFileFilter {
        private WarPackageArchiveFilter() {
        }

        public boolean include(InputStream dataStream, String entryName) throws ArchiveFilterException {
            return !entryName.startsWith("META-INF");
        }
    }
}

