/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mvnplugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class PackageMojo
extends AbstractMojo {
    private MavenProject project;
    private File targetDir;
    MavenProjectHelper projectHelper;
    private String[] excludes;
    private String finalName;
    private JarArchiver archiver;
    private File manifest;
    private File packageSourceDirectory;

    public void execute() throws MojoExecutionException {
        File jsarchive = new File(this.targetDir, this.finalName + "." + "jar");
        try {
            if (this.manifest != null) {
                this.archiver.setManifest(this.manifest);
            } else {
                PackageMojo.createDefaultManifest(this.project, this.archiver);
            }
            if (this.packageSourceDirectory.exists()) {
                this.archiver.addDirectory(this.packageSourceDirectory);
            }
            String groupId = this.project.getGroupId();
            String artifactId = this.project.getArtifactId();
            this.archiver.addFile(this.project.getFile(), "META-INF/maven/" + groupId + "/" + artifactId + "/pom.xml");
            this.archiver.setDestFile(jsarchive);
            this.archiver.createArchive();
            this.archiver.reset();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create the javascript archive", e);
        }
        this.project.getArtifact().setFile(jsarchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createDefaultManifest(MavenProject project, JarArchiver jarArchiver) throws ManifestException, IOException, ArchiverException {
        Manifest manifest = new Manifest();
        Manifest.Attribute attr = new Manifest.Attribute("Created-By", "Apache Maven");
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Title", project.getName());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Version", project.getVersion());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Vendor-Id", project.getGroupId());
        manifest.addConfiguredAttribute(attr);
        if (project.getOrganization() != null) {
            String vendor = project.getOrganization().getName();
            attr = new Manifest.Attribute("Implementation-Vendor", vendor);
            manifest.addConfiguredAttribute(attr);
        }
        attr = new Manifest.Attribute("Built-By", System.getProperty("user.name"));
        manifest.addConfiguredAttribute(attr);
        File mf = File.createTempFile("maven", ".mf");
        mf.deleteOnExit();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(mf));
            manifest.write(writer);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        jarArchiver.setManifest(mf);
    }
}

