/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.jangaroo.jooc.CompressorImpl;
import net.jangaroo.jooc.api.Compressor;
import net.jangaroo.jooc.api.Packager;
import net.jangaroo.jooc.api.Packager2;
import net.jangaroo.jooc.json.JsonArray;
import net.jangaroo.utils.CompilerUtils;
import org.apache.commons.lang.StringUtils;

public class PackagerImpl
implements Packager,
Packager2 {
    private static final String DEFAULT_LOCALE = "en";
    private final Compressor compressor = new CompressorImpl();

    public void doPackage(File sourceDirectory, File overridesDirectory, File localizedOverridesDirectory, File outputDirectory, String outputFilePrefix) throws IOException {
        this.doPackage2("", sourceDirectory, overridesDirectory, localizedOverridesDirectory, outputDirectory, outputFilePrefix);
    }

    public void doPackage2(String extNamespace, File sourceDirectory, File overridesDirectory, File localizedOverridesDirectory, File outputDirectory, String outputFilePrefix) throws IOException {
        this.pack(extNamespace, outputDirectory, this.packageJsFileName(outputFilePrefix), sourceDirectory, new File(localizedOverridesDirectory, DEFAULT_LOCALE));
        this.pack(extNamespace, outputDirectory, this.overridesJsFilename(outputFilePrefix), overridesDirectory);
        File[] children = localizedOverridesDirectory.listFiles();
        if (children != null) {
            for (File child : children) {
                String locale = child.getName();
                if (!child.isDirectory() || DEFAULT_LOCALE.equals(locale)) continue;
                this.pack(extNamespace, outputDirectory, this.overridesJsFilename(outputFilePrefix, locale), child);
            }
        }
    }

    private void pack(String extNamespace, File outputDirectory, String outputFileName, File ... sourceDirectories) throws IOException {
        File outputFile = new File(outputDirectory, outputFileName);
        ArrayList<File> sources = new ArrayList<File>();
        ArrayList<String> sourceClasses = new ArrayList<String>();
        long timestamp = outputFile.lastModified();
        boolean somethingChanged = false;
        for (File dir : sourceDirectories) {
            somethingChanged |= this.scanSources(extNamespace, dir, dir, timestamp, sources, sourceClasses);
        }
        String outputFilePath = outputFile.getAbsolutePath();
        if (somethingChanged && !sources.isEmpty()) {
            System.out.printf("Packing %d js files into %s%n", sources.size(), outputFilePath);
            String initName = (StringUtils.isNotEmpty((String)extNamespace) ? extNamespace + "." : "") + "init";
            if (sourceClasses.contains(initName)) {
                sources.add(PackagerImpl.createAutoLoad(outputDirectory, (List<String>)ImmutableList.of((Object)initName)));
            }
            this.pack(sources, outputFile);
            File inventoryFile = new File(outputDirectory, CompilerUtils.removeExtension((String)outputFileName) + ".json");
            PrintWriter printWriter = new PrintWriter(inventoryFile);
            printWriter.println(new JsonArray(sourceClasses.toArray()).toString());
            printWriter.close();
        } else if (sources.isEmpty()) {
            if (outputFile.exists()) {
                System.out.printf("No js files found, removing %s%n", outputFilePath);
                if (!outputFile.delete()) {
                    throw new IOException(String.format("failed to delete %s", outputFilePath));
                }
            } else {
                System.out.printf("No js files found, skipping generation of %s%n", outputFile.getAbsolutePath());
            }
        } else {
            System.out.printf("Nothing changed, keeping %s%n", outputFilePath);
        }
    }

    private boolean scanSources(String extNamespace, File baseDir, File dir, long timestamp, ArrayList<File> sources, ArrayList<String> sourceClasses) {
        boolean somethingChanged = dir.lastModified() > timestamp;
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    somethingChanged |= this.scanSources(extNamespace, baseDir, child, timestamp, sources, sourceClasses);
                    continue;
                }
                if (!child.getName().endsWith(".js")) continue;
                sources.add(child);
                sourceClasses.add(CompilerUtils.qName((String)extNamespace, (String)CompilerUtils.qNameFromFile((File)baseDir, (File)child)));
                somethingChanged |= child.lastModified() > timestamp;
            }
        }
        return somethingChanged;
    }

    private void pack(Collection<File> inputFiles, File output) throws IOException {
        this.compressor.compress(inputFiles, output);
    }

    private String packageJsFileName(String prefix) {
        return this.packageJsFileName(prefix, "");
    }

    private String packageJsFileName(String prefix, String suffix) {
        return String.format("%s%s.js", prefix, suffix);
    }

    private String overridesJsFilename(String prefix, String locale) {
        return this.packageJsFileName(prefix, "-overrides" + (locale.isEmpty() ? "" : "-") + locale);
    }

    private String overridesJsFilename(String prefix) {
        return this.overridesJsFilename(prefix, "");
    }

    private static File createAutoLoad(File outputDirectory, List<String> autoLoad) throws IOException {
        File autoLoadFile = new File(outputDirectory, "autoLoad.js");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(autoLoadFile), StandardCharsets.UTF_8);){
            for (String item : autoLoad) {
                writer.write(item + "();\n");
            }
        }
        return autoLoadFile;
    }
}

