/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayLiteral;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectFieldOrSpread;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.PropertyDeclaration;
import net.jangaroo.jooc.ast.Spread;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.mxml.MxmlParserHelper;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.jooc.mxml.ast.MxmlAstUtils;
import net.jangaroo.jooc.mxml.ast.MxmlCompilationUnit;
import net.jangaroo.jooc.mxml.ast.RootElementProcessor;
import net.jangaroo.jooc.mxml.ast.XmlAttribute;
import net.jangaroo.jooc.mxml.ast.XmlElement;
import net.jangaroo.utils.AS3Type;

final class MxmlToModelParser {
    private static final String EXML_NAMESPACE_URI = "http://www.jangaroo.net/exml/0.8";
    private static final String EXT_CONFIG_CREATE_FLAG = "create";
    private static final String EXT_CONFIG_EXTRACT_XTYPE_PARAMETER = "extractXType";
    private static final String CONFIG_MODE_ATTRIBUTE_NAME = "mode";
    private static final String UNTYPED_MARKER = "__UNTYPED__";
    public static final List<String> PRIMITIVE_TYPE_NAMES = Arrays.asList("int", "uint", "Number", "Boolean");
    private final JangarooParser jangarooParser;
    private final MxmlParserHelper mxmlParserHelper;
    private final MxmlCompilationUnit compilationUnit;
    private final Collection<Directive> classBodyDirectives = new LinkedList<Directive>();

    MxmlToModelParser(JangarooParser jangarooParser, MxmlParserHelper mxmlParserHelper, MxmlCompilationUnit mxmlCompilationUnit) {
        this.jangarooParser = jangarooParser;
        this.mxmlParserHelper = mxmlParserHelper;
        this.compilationUnit = mxmlCompilationUnit;
    }

    private List<ObjectFieldOrSpread> processAttributes(List<ObjectFieldOrSpread> listenerFields, XmlElement objectNode, CompilationUnit type) {
        ClassDeclaration classModel = type == null ? null : (ClassDeclaration)type.getPrimaryDeclaration();
        boolean hasIdAttribute = false;
        ArrayList<ObjectFieldOrSpread> fields = new ArrayList<ObjectFieldOrSpread>();
        ArrayList<ObjectFieldOrSpread> untypedFields = new ArrayList<ObjectFieldOrSpread>();
        for (XmlAttribute attribute : objectNode.getAttributes()) {
            String className;
            Expr valueExpr;
            if (RootElementProcessor.alreadyProcessed(attribute)) continue;
            String propertyName = attribute.getLocalName();
            boolean noPrefix = attribute.getPrefix() == null;
            hasIdAttribute |= noPrefix && "id".equals(propertyName);
            String attributeNamespaceUri = objectNode.getNamespaceUri(attribute.getPrefix());
            boolean isUntypedAccess = "exml:untyped".equals(attributeNamespaceUri);
            if ((!noPrefix || "id".equals(propertyName)) && !isUntypedAccess) continue;
            JooSymbol value = attribute.getValue();
            TypedIdeDeclaration propertyModel = null;
            if (classModel != null) {
                Annotation eventModel;
                propertyModel = this.findPropertyModel(classModel, propertyName);
                if (propertyModel != null) {
                    if (isUntypedAccess) {
                        this.jangarooParser.getLog().warning((FilePosition)attribute.getSymbol(), String.format("Property '%s' unnecessarily set via untyped MXML attribute (u:...), falling back to typed access.", propertyName));
                        isUntypedAccess = false;
                    }
                } else if (!isUntypedAccess && (eventModel = this.findEvent(classModel, propertyName)) != null) {
                    ObjectField eventHandlerCode = this.createEventHandlerCode(value, eventModel);
                    MxmlToModelParser.transferWhitespace(eventHandlerCode, attribute);
                    listenerFields.add(eventHandlerCode);
                    continue;
                }
            }
            if (propertyModel == null) {
                propertyModel = this.createDynamicPropertyModel(objectNode, type, propertyName, isUntypedAccess);
            }
            if ((valueExpr = this.createValueExprFromTextSymbol(value, className = MxmlToModelParser.getTypeAsClassName(propertyModel))) == null) continue;
            ObjectField propertyAssignmentCode = this.createPropertyAssignmentCode(propertyModel, valueExpr);
            MxmlToModelParser.transferWhitespace(propertyAssignmentCode, attribute);
            if (isUntypedAccess) {
                untypedFields.add(propertyAssignmentCode);
                continue;
            }
            MxmlToModelParser.flushUntypedFields(fields, untypedFields);
            fields.add(propertyAssignmentCode);
        }
        MxmlToModelParser.flushUntypedFields(fields, untypedFields);
        return fields;
    }

    private static void flushUntypedFields(List<ObjectFieldOrSpread> fields, List<ObjectFieldOrSpread> untypedFields) {
        if (!untypedFields.isEmpty()) {
            fields.add(MxmlAstUtils.createSpread(MxmlAstUtils.createObjectLiteral(untypedFields)));
            untypedFields.clear();
        }
    }

    private static String convertMxmlWhitespace(JooSymbol symbol) {
        return MxmlUtils.toASDoc(symbol.getWhitespace());
    }

    private static String getTypeAsClassName(TypedIdeDeclaration propertyModel) {
        String className;
        TypeRelation typeRelation = propertyModel.getOptTypeRelation();
        String string = className = typeRelation == null ? "*" : typeRelation.getType().getIde().getQualifiedNameStr();
        if (UNTYPED_MARKER.equals(className)) {
            className = "*";
        }
        return className;
    }

    private static Annotation getAnnotationAtSetter(TypedIdeDeclaration memberModel, String annotationName) {
        Iterator<Annotation> annotations;
        TypedIdeDeclaration setter = null;
        if (memberModel instanceof PropertyDeclaration) {
            setter = ((PropertyDeclaration)memberModel).getSetter();
        } else if (memberModel instanceof VariableDeclaration && !((VariableDeclaration)memberModel).isConst()) {
            setter = memberModel;
        }
        if (setter != null && (annotations = setter.getAnnotations(annotationName).iterator()).hasNext()) {
            return annotations.next();
        }
        return null;
    }

    ObjectLiteral createObjectLiteralForAttributesAndChildNodes(XmlElement objectNode) {
        return MxmlAstUtils.createObjectLiteral(this.createObjectFieldsForAttributesAndChildNodes(objectNode));
    }

    private List<ObjectFieldOrSpread> createObjectFieldsForAttributesAndChildNodes(XmlElement objectNode) {
        ArrayList<ObjectFieldOrSpread> fields = new ArrayList<ObjectFieldOrSpread>();
        ArrayList<ObjectFieldOrSpread> listenerFields = new ArrayList<ObjectFieldOrSpread>();
        if (!objectNode.getAttributes().isEmpty() || !objectNode.getElements().isEmpty()) {
            CompilationUnit type = this.getCompilationUnitModel(objectNode);
            fields.addAll(this.processAttributes(listenerFields, objectNode, type));
            fields.addAll(this.processChildNodes(listenerFields, objectNode, type));
        }
        if (!listenerFields.isEmpty()) {
            ObjectField listeners = MxmlAstUtils.createObjectField("listeners", MxmlAstUtils.createObjectLiteral(listenerFields));
            listeners.getSymbol().setWhitespace("\n    ");
            fields.add(listeners);
        }
        return fields;
    }

    private List<ObjectFieldOrSpread> processChildNodes(List<ObjectFieldOrSpread> listenerFields, XmlElement objectNode, CompilationUnit type) {
        ClassDeclaration classModel = type == null ? null : (ClassDeclaration)type.getPrimaryDeclaration();
        List<XmlElement> childNodes = objectNode.getElements();
        TypedIdeDeclaration defaultPropertyModel = this.findDefaultPropertyModel(classModel);
        ArrayList<XmlElement> defaultPropertyValues = new ArrayList<XmlElement>();
        ArrayList<ObjectFieldOrSpread> fields = new ArrayList<ObjectFieldOrSpread>();
        for (XmlElement element : childNodes) {
            List<XmlElement> childElements;
            Annotation eventModel;
            if (MxmlUtils.isMxmlNamespace(element.getNamespaceURI())) continue;
            TypedIdeDeclaration propertyModel = null;
            String propertyName = element.getLocalName();
            if (objectNode.getNamespaceURI().equals(element.getNamespaceURI()) && classModel != null && (propertyModel = this.findPropertyModel(classModel, propertyName)) == null && (eventModel = this.findEvent(classModel, propertyName)) != null) {
                JooSymbol textContent = MxmlToModelParser.getTextContent(element);
                listenerFields.add(this.createEventHandlerCode(textContent, eventModel));
                continue;
            }
            if (propertyModel == null && defaultPropertyModel != null) {
                defaultPropertyValues.add(element);
                continue;
            }
            if (propertyModel == null) {
                propertyModel = this.createDynamicPropertyModel(element, type, propertyName, false);
            }
            if ((childElements = element.getElements()).isEmpty()) {
                Object valueExpr = this.createValueExprFromTextSymbol(MxmlToModelParser.getTextContent(element), MxmlToModelParser.getTypeAsClassName(propertyModel));
                if (valueExpr == null && MxmlToModelParser.hasArrayLikeType(propertyModel)) {
                    valueExpr = MxmlAstUtils.createArrayLiteral(Collections.emptyList());
                }
                if (valueExpr == null) continue;
                ObjectField propertyAssignmentCode = this.createPropertyAssignmentCode(propertyModel, (Expr)valueExpr);
                MxmlToModelParser.transferWhitespace(propertyAssignmentCode, element);
                fields.add(propertyAssignmentCode);
                continue;
            }
            if ("__mixins__".equals(MxmlToModelParser.getConfigOptionName(propertyModel))) {
                for (XmlElement arrayItemNode : childElements) {
                    IdeExpr mixinType = new IdeExpr(this.compilationUnit.addImport(this.getClassNameForElement(arrayItemNode)));
                    List<ObjectFieldOrSpread> mixinFields = this.createObjectFieldsForAttributesAndChildNodes(arrayItemNode);
                    if (mixinFields.isEmpty()) continue;
                    Spread spread = MxmlAstUtils.createSpread(MxmlToModelParser.createObjectLiteralTypeAssertion(mixinType, MxmlAstUtils.createObjectLiteral(mixinFields)));
                    MxmlToModelParser.transferWhitespace(spread, arrayItemNode);
                    fields.add(spread);
                }
                continue;
            }
            List<ObjectField> childElementsPropertyAssignmentCode = this.createChildElementsPropertyAssignmentCode(childElements, propertyModel, this.getConfigMode(element, propertyModel));
            childElementsPropertyAssignmentCode.forEach(field -> MxmlToModelParser.transferWhitespace(field, element));
            fields.addAll(childElementsPropertyAssignmentCode);
        }
        if (!defaultPropertyValues.isEmpty()) {
            fields.addAll(this.createChildElementsPropertyAssignmentCode(defaultPropertyValues, defaultPropertyModel, ""));
        }
        return fields;
    }

    private static void transferWhitespace(AstNode node, AstNode element) {
        JooSymbol lastSymbol;
        node.getSymbol().setWhitespace(MxmlToModelParser.convertMxmlWhitespace(element.getSymbol()));
        if (element instanceof XmlElement && (lastSymbol = MxmlToModelParser.findLastSymbol(node)) != null) {
            lastSymbol.setWhitespace(MxmlToModelParser.convertMxmlWhitespace(((XmlElement)element).getLastSymbol()));
        }
    }

    private static JooSymbol findLastSymbol(AstNode node) {
        CommaSeparatedList<Expr> args;
        JooSymbol lastSymbol = MxmlToModelParser.getLastSymbol(node);
        if (lastSymbol != null) {
            return lastSymbol;
        }
        if (node instanceof ObjectField) {
            lastSymbol = MxmlToModelParser.findLastSymbol(((ObjectField)node).getValue());
        } else if (node instanceof AssignmentOpExpr) {
            lastSymbol = MxmlToModelParser.findLastSymbol(((AssignmentOpExpr)node).getArg2());
        } else if (node instanceof NewExpr) {
            lastSymbol = MxmlToModelParser.findLastSymbol(((NewExpr)node).getApplyConstructor());
        } else if (node instanceof ApplyExpr && (args = ((ApplyExpr)node).getArgs().getExpr()) != null) {
            while (args.getTail() != null) {
                args = args.getTail();
            }
            lastSymbol = MxmlToModelParser.findLastSymbol(args.getHead());
        }
        if (lastSymbol == null && node instanceof ApplyExpr) {
            return ((ApplyExpr)node).getArgs().getRParen();
        }
        return lastSymbol;
    }

    private static JooSymbol getLastSymbol(AstNode node) {
        if (node instanceof ArrayLiteral) {
            return ((ArrayLiteral)node).getRParen();
        }
        if (node instanceof ObjectLiteral) {
            return ((ObjectLiteral)node).getRBrace();
        }
        return null;
    }

    private String getConfigMode(XmlElement element, TypedIdeDeclaration propertyModel) {
        if (MxmlToModelParser.hasArrayLikeType(propertyModel)) {
            String configMode;
            XmlAttribute configModeAttribute = element.getAttribute(EXML_NAMESPACE_URI, CONFIG_MODE_ATTRIBUTE_NAME);
            if (configModeAttribute != null && MxmlCompilationUnit.isValidConfigMode(configMode = (String)configModeAttribute.getValue().getJooValue())) {
                if ("plugins".equals(propertyModel.getName()) && element.getParentNode().getParentNode() instanceof XmlElement && "rules".equals(((XmlElement)element.getParentNode().getParentNode()).getName())) {
                    this.jangarooParser.getLog().warning((FilePosition)configModeAttribute.getSymbol(), String.format("Ignoring exml:mode=\"%s\" of <plugins> element inside <rules>, as plugin rules always append the given plugins.", configMode));
                    return "";
                }
                return configMode;
            }
            Annotation extConfigAnnotation = propertyModel.getAnnotation("ExtConfig");
            if (extConfigAnnotation != null) {
                for (CommaSeparatedList<AnnotationParameter> annotationParameters = extConfigAnnotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
                    Object jooValue;
                    AstNode value;
                    Ide name = annotationParameters.getHead().getOptName();
                    if (name == null || !CONFIG_MODE_ATTRIBUTE_NAME.equals(name.getName()) || !((value = annotationParameters.getHead().getValue()) instanceof LiteralExpr) || !((jooValue = value.getSymbol().getJooValue()) instanceof String)) continue;
                    return MxmlCompilationUnit.isValidConfigMode((String)jooValue) ? (String)jooValue : null;
                }
            }
        }
        return "";
    }

    private List<ObjectField> createChildElementsPropertyAssignmentCode(List<XmlElement> childElements, TypedIdeDeclaration propertyModel, String configMode) {
        Object extractXType;
        Map<String, Object> propertiesByName;
        boolean forceArray = MxmlToModelParser.hasArrayLikeType(propertyModel);
        Annotation extConfigAnnotation = MxmlToModelParser.getAnnotationAtSetter(propertyModel, "ExtConfig");
        Boolean useConfigObjects = extConfigAnnotation == null ? null : MxmlToModelParser.useConfigObjects(extConfigAnnotation, null);
        Expr value = this.createArrayExprFromChildElements(childElements, forceArray, useConfigObjects);
        ArrayList<ObjectField> fields = new ArrayList<ObjectField>();
        if (extConfigAnnotation != null && (propertiesByName = extConfigAnnotation.getPropertiesByName()).containsKey(EXT_CONFIG_EXTRACT_XTYPE_PARAMETER) && value instanceof ApplyExpr && ((extractXType = propertiesByName.get(EXT_CONFIG_EXTRACT_XTYPE_PARAMETER)) == null || extractXType instanceof String)) {
            String extractXTypeToProperty = (String)extractXType;
            ApplyExpr typeCastExpr = (ApplyExpr)value;
            value = MxmlToModelParser.reduceTypeCastToTypeAssertion(typeCastExpr);
            if (extractXTypeToProperty != null) {
                fields.add(MxmlAstUtils.createObjectField(extractXTypeToProperty, MxmlAstUtils.createDotExpr(typeCastExpr.getFun(), new Ide("xtype"))));
            }
        }
        if (!configMode.isEmpty()) {
            value = MxmlAstUtils.createApplyExpr(MxmlAstUtils.createDotExpr(this.compilationUnit.addImport("net.jangaroo.ext.Exml"), configMode), value);
        }
        fields.add(this.createPropertyAssignmentCode(propertyModel, value));
        return fields;
    }

    static Expr reduceTypeCastToTypeAssertion(ApplyExpr typeCastExpr) {
        Expr typeCastArgExpr = typeCastExpr.getArgs().getExpr().getHead();
        if (typeCastArgExpr instanceof ObjectLiteral) {
            return MxmlToModelParser.createObjectLiteralTypeAssertion(new IdeExpr(((IdeExpr)typeCastExpr.getFun()).getIde()), (ObjectLiteral)typeCastArgExpr);
        }
        return typeCastArgExpr;
    }

    private static boolean hasArrayLikeType(TypedIdeDeclaration propertyModel) {
        return propertyModel.getIde().getScope() != null && propertyModel.getIde().getScope().getExpressionType(propertyModel.getOptTypeRelation()).isArrayLike();
    }

    private Expr createArrayExprFromChildElements(List<XmlElement> childElements, boolean forceArray, Boolean useConfigObjects) {
        ArrayList<Expr> arrayItems = new ArrayList<Expr>();
        for (XmlElement arrayItemNode : childElements) {
            Expr itemValue = this.createExprFromElement(arrayItemNode, useConfigObjects, true);
            arrayItems.add(itemValue);
        }
        Expr value = arrayItems.size() > 1 || forceArray ? MxmlAstUtils.createArrayLiteral(arrayItems) : (arrayItems.isEmpty() ? MxmlAstUtils.createNullLiteral() : (Expr)arrayItems.get(0));
        return value;
    }

    private boolean isJavaScriptObject() {
        CompilationUnit superCompilationUnit;
        Extends optExtends = ((ClassDeclaration)this.compilationUnit.getPrimaryDeclaration()).getOptExtends();
        if (optExtends != null && (superCompilationUnit = this.jangarooParser.getCompilationUnit(optExtends.getSuperClass().getQualifiedNameStr())) != null) {
            return ((ClassDeclaration)superCompilationUnit.getPrimaryDeclaration()).isJavaScriptObject();
        }
        return false;
    }

    @Nullable
    Expr createExprFromElement(XmlElement objectElement, Boolean defaultUseConfigObjects, boolean generatingConfig) {
        Expr valueExpr;
        JooSymbol textContentSymbol;
        String textContent;
        String className = this.getClassNameForElement(objectElement);
        Ide typeIde = this.compilationUnit.addImport(className);
        XmlAttribute idAttribute = objectElement.getAttribute("id");
        String id = null;
        if (null != idAttribute) {
            JooSymbol idSymbol = idAttribute.getValue();
            id = (String)idSymbol.getJooValue();
            if (id.equals(this.compilationUnit.getConstructorParamName())) {
                return null;
            }
            Ide.verifyIdentifier(id, idSymbol);
            VariableDeclaration variableDeclaration = this.compilationUnit.getVariables().get(id);
            if (null == variableDeclaration) {
                String asDoc = MxmlToModelParser.convertMxmlWhitespace(objectElement.getSymbol());
                int i = asDoc.lastIndexOf(10);
                String additionalDeclaration = asDoc + '[' + (this.isJavaScriptObject() ? "ExtConfig" : "Bindable") + ']' + (i < 0 ? "\n" : asDoc.substring(i)) + "public var " + id + ':' + className + ';';
                List<Directive> directives = this.mxmlParserHelper.parseClassBody(new JooSymbol(additionalDeclaration)).getDirectives();
                Iterator directiveIterator = directives.iterator();
                if (!directiveIterator.hasNext()) {
                    throw new IllegalStateException("MXML: parsing generated field declaration with name '" + id + "' failed.");
                }
                variableDeclaration = (VariableDeclaration)directiveIterator.next();
                this.classBodyDirectives.add(variableDeclaration);
            }
            if (generatingConfig && variableDeclaration.isExtConfigOrBindable() && MxmlToModelParser.isMxmlDeclarations(objectElement.getParentNode())) {
                id = null;
            }
        }
        if ((textContent = (textContentSymbol = MxmlToModelParser.getTextContent(objectElement)).getText().trim()).isEmpty()) {
            if (idAttribute != null && objectElement.getElements().isEmpty() && objectElement.getAttributes().size() == 1) {
                return null;
            }
            if ("Array".equals(className)) {
                valueExpr = this.createArrayExprFromChildElements(objectElement.getElements(), true, defaultUseConfigObjects);
            } else {
                ObjectLiteral configObjectLiteral = this.createObjectLiteralForAttributesAndChildNodes(objectElement);
                if ("Object".equals(className)) {
                    valueExpr = configObjectLiteral;
                } else if (idAttribute != null || !this.useConfigObjects(defaultUseConfigObjects, className)) {
                    CompilationUnit classToInstantiate = this.jangarooParser.resolveCompilationUnit(className);
                    FunctionDeclaration constructor = ((ClassDeclaration)classToInstantiate.getPrimaryDeclaration()).getConstructor();
                    if (constructor == null || constructor.getParams() == null) {
                        Expr newExpr = MxmlAstUtils.createNewExpr(typeIde, new Expr[0]);
                        valueExpr = configObjectLiteral.getFields() == null ? newExpr : MxmlAstUtils.createApplyExpr(MxmlAstUtils.createDotExpr(new Ide(AS3Type.OBJECT.name), "assign"), newExpr, configObjectLiteral);
                    } else {
                        valueExpr = MxmlAstUtils.createNewExpr(typeIde, configObjectLiteral);
                    }
                } else {
                    valueExpr = MxmlAstUtils.createCastExpr(typeIde, configObjectLiteral);
                }
            }
        } else {
            valueExpr = this.createValueExprFromTextSymbol(textContentSymbol, className);
            if (valueExpr == null) {
                valueExpr = MxmlAstUtils.createNewExpr(typeIde, new Expr[0]);
            } else {
                if (!objectElement.getElements().isEmpty() || objectElement.getAttributes().size() != (idAttribute == null ? 0 : 1)) {
                    throw Jooc.error(textContentSymbol, String.format("Unexpected text inside MXML element: '%s'.", textContent));
                }
                if (valueExpr instanceof IdeExpr && "undefined".equals(((IdeExpr)valueExpr).getIde().getName())) {
                    return null;
                }
            }
        }
        if (id != null && valueExpr != null) {
            valueExpr = MxmlAstUtils.createAssignmentOpExpr(MxmlAstUtils.createDotExpr(new Ide(new JooSymbol("this")), id), valueExpr);
        }
        if (valueExpr != null) {
            MxmlToModelParser.transferWhitespace(valueExpr, objectElement);
        }
        return valueExpr;
    }

    private static ApplyExpr createObjectLiteralTypeAssertion(Expr type, ObjectLiteral objectLiteral) {
        return MxmlAstUtils.createApplyExpr(new IdeExpr(new Ide("__typeCheckObjectLiteral__")), type, objectLiteral);
    }

    private String getClassNameForElement(XmlElement objectElement) {
        String className;
        try {
            className = this.mxmlParserHelper.getClassNameForElement(this.jangarooParser, objectElement);
        }
        catch (CompilerError e) {
            throw JangarooParser.error(objectElement.getSymbol(), e.getMessage(), e.getCause());
        }
        return className;
    }

    private static boolean isMxmlDeclarations(AstNode mxmlNode) {
        return mxmlNode instanceof XmlElement && MxmlToModelParser.isMxmlDeclarations((XmlElement)mxmlNode);
    }

    private static boolean isMxmlDeclarations(XmlElement mxmlNode) {
        return MxmlUtils.isMxmlNamespace(mxmlNode.getNamespaceURI()) && "Declarations".equals(mxmlNode.getName());
    }

    private Expr createValueExprFromTextSymbol(JooSymbol textContentSymbol, String className) {
        String textContent = ((String)textContentSymbol.getJooValue()).trim();
        if (textContent.isEmpty()) {
            if (PRIMITIVE_TYPE_NAMES.contains(className)) {
                return new IdeExpr(new Ide("undefined"));
            }
            if (AS3Type.ANY.name.equals(className) || AS3Type.STRING.name.equals(className)) {
                return new LiteralExpr(new JooSymbol(98, "", -1, -1, "", "\"\"", ""));
            }
            return null;
        }
        String value = MxmlUtils.mxmlValueToActionScriptExpr(textContent, className);
        Expr valueExpr = this.mxmlParserHelper.parseExpression(value.equals(textContentSymbol.getText()) ? textContentSymbol : textContentSymbol.replacingSymAndTextAndJooValue(textContentSymbol.sym, value, value));
        if (!(!"String".equals(className) || valueExpr instanceof LiteralExpr && ((LiteralExpr)valueExpr).getValue().getJooValue() instanceof String)) {
            valueExpr = MxmlAstUtils.createApplyExpr(MxmlAstUtils.createDotExpr(this.compilationUnit.addImport("net.jangaroo.ext.Exml"), "asString"), valueExpr);
        }
        return valueExpr;
    }

    private boolean useConfigObjects(Boolean defaultUseConfigObjects, String className) {
        if (defaultUseConfigObjects != null) {
            return defaultUseConfigObjects;
        }
        ClassDeclaration classModel = (ClassDeclaration)this.jangarooParser.resolveCompilationUnit(className).getPrimaryDeclaration();
        CompilationUnit extPluginCompilationUnit = this.jangarooParser.getCompilationUnit("ext.Plugin");
        if (extPluginCompilationUnit != null && classModel.isAssignableTo((ClassDeclaration)extPluginCompilationUnit.getPrimaryDeclaration())) {
            return true;
        }
        for (ClassDeclaration current = classModel; current != null; current = current.getSuperTypeDeclaration()) {
            Iterator<Annotation> extConfigAnnotations = current.getAnnotations("ExtConfig").iterator();
            if (!extConfigAnnotations.hasNext()) continue;
            Annotation extConfigAnnotation = extConfigAnnotations.next();
            return MxmlToModelParser.useConfigObjects(extConfigAnnotation, true);
        }
        return false;
    }

    private static Boolean useConfigObjects(Annotation extConfigAnnotation, Boolean defaultValue) {
        for (CommaSeparatedList<AnnotationParameter> annotationParameters = extConfigAnnotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
            AnnotationParameter annotationParameter = annotationParameters.getHead();
            Ide annotationParameterName = annotationParameter.getOptName();
            if (annotationParameterName == null) continue;
            if (EXT_CONFIG_CREATE_FLAG.equals(annotationParameterName.getName())) {
                AstNode value = annotationParameter.getValue();
                return value instanceof LiteralExpr && Boolean.FALSE.equals(((LiteralExpr)value).getValue().getJooValue());
            }
            if (!EXT_CONFIG_EXTRACT_XTYPE_PARAMETER.equals(annotationParameterName.getName())) continue;
            return true;
        }
        return defaultValue;
    }

    private ObjectField createEventHandlerCode(@Nonnull JooSymbol value, @Nonnull Annotation event) {
        Map<String, Object> eventPropertiesByName = event.getPropertiesByName();
        Object eventType = eventPropertiesByName.get("type");
        Ide eventTypeIde = this.compilationUnit.addImport(eventType instanceof String ? (String)eventType : "Object");
        Object eventNameModel = eventPropertiesByName.get("name");
        String eventName = (String)(eventNameModel != null ? eventNameModel : eventPropertiesByName.get(null));
        if (eventName.startsWith("on")) {
            eventName = eventName.substring(2).toLowerCase();
        }
        String eventNameConstant = (eventName.substring(0, 1) + eventName.substring(1).replaceAll("([A-Z])", "_$1")).toUpperCase();
        String eventHandlerName = "$on_" + eventName.replace('-', '_') + "_" + value.getLine() + "_" + value.getColumn();
        String classBodyCode = "\n    private function " + eventHandlerName + " (event" + ':' + eventTypeIde.getQualifiedNameStr() + ") :void {\n      " + value.getJooValue() + "\n    }";
        this.classBodyDirectives.addAll(this.mxmlParserHelper.parseClassBody(new JooSymbol(classBodyCode)).getDirectives());
        return MxmlAstUtils.createObjectField(eventName, MxmlAstUtils.createApplyExpr(MxmlAstUtils.createDotExpr(this.compilationUnit.addImport("net.jangaroo.ext.Exml"), "eventHandler"), MxmlAstUtils.createDotExpr(eventTypeIde, eventNameConstant), new IdeExpr(eventTypeIde), new IdeExpr(new Ide(eventHandlerName))));
    }

    private ObjectField createPropertyAssignmentCode(@Nonnull TypedIdeDeclaration propertyModel, @Nonnull Expr value) {
        return MxmlAstUtils.createObjectField(MxmlToModelParser.getConfigOptionName(propertyModel), value);
    }

    private static String getConfigOptionName(TypedIdeDeclaration propertyModel) {
        Object configOption;
        Iterator<Annotation> configOptionAnnotations;
        TypedIdeDeclaration setter;
        TypedIdeDeclaration typedIdeDeclaration = setter = propertyModel instanceof PropertyDeclaration ? ((PropertyDeclaration)propertyModel).getSetter() : propertyModel;
        if (setter != null && (configOptionAnnotations = setter.getAnnotations("ExtConfig").iterator()).hasNext() && (configOption = configOptionAnnotations.next().getPropertiesByName().get(null)) instanceof String) {
            return (String)configOption;
        }
        return propertyModel.getName();
    }

    @Nonnull
    private CompilationUnit getCompilationUnitModel(XmlElement element) {
        String fullClassName = this.mxmlParserHelper.getClassNameForElement(this.jangarooParser, element);
        try {
            return this.jangarooParser.resolveCompilationUnit(fullClassName);
        }
        catch (CompilerError e) {
            this.jangarooParser.getLog().error((FilePosition)element.getSymbol(), "While trying to resolve element <" + element.getName() + ">:");
            throw e;
        }
    }

    private TypedIdeDeclaration findPropertyModel(ClassDeclaration classModel, String propertyName) {
        for (ClassDeclaration currentClassModel = classModel; currentClassModel != null; currentClassModel = currentClassModel.getSuperTypeDeclaration()) {
            TypedIdeDeclaration memberModel = currentClassModel.getMemberDeclaration(propertyName);
            if (memberModel == null || memberModel.isPrivate() || !memberModel.isWritable()) continue;
            return memberModel;
        }
        return null;
    }

    private Annotation findEvent(ClassDeclaration classModel, String propertyName) {
        for (ClassDeclaration current = classModel; current != null; current = current.getSuperTypeDeclaration()) {
            Annotation eventModel = this.getEvent(current, propertyName);
            if (eventModel == null) continue;
            return eventModel;
        }
        return null;
    }

    private Annotation getEvent(ClassDeclaration classDeclaration, String propertyName) {
        for (Annotation eventAnnotation : classDeclaration.getAnnotations("Event")) {
            for (CommaSeparatedList<AnnotationParameter> annotationParameters = eventAnnotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
                AstNode value;
                Ide name = annotationParameters.getHead().getOptName();
                if (name == null || !"name".equals(name.getName()) || !((value = annotationParameters.getHead().getValue()) instanceof LiteralExpr) || !propertyName.equals(value.getSymbol().getJooValue())) continue;
                return eventAnnotation;
            }
        }
        return null;
    }

    private TypedIdeDeclaration findDefaultPropertyModel(ClassDeclaration classModel) {
        for (ClassDeclaration current = classModel; current != null; current = current.getSuperTypeDeclaration()) {
            TypedIdeDeclaration defaultPropertyModel = this.findPropertyWithAnnotation(current, "DefaultProperty");
            if (defaultPropertyModel == null) continue;
            return defaultPropertyModel;
        }
        return null;
    }

    private TypedIdeDeclaration findPropertyWithAnnotation(ClassDeclaration current, String annotation) {
        for (TypedIdeDeclaration member : current.getMembers()) {
            if (member.getAnnotations(annotation).isEmpty()) continue;
            return member;
        }
        return null;
    }

    @Nonnull
    private TypedIdeDeclaration createDynamicPropertyModel(XmlElement element, CompilationUnit compilationUnitModel, String name, boolean allowAnyProperty) {
        if (!allowAnyProperty && compilationUnitModel != null && compilationUnitModel.getPrimaryDeclaration() != null && !compilationUnitModel.getPrimaryDeclaration().isDynamic()) {
            this.jangarooParser.getLog().error((FilePosition)element.getSymbol(), "MXML: property " + name + " not found in class " + compilationUnitModel.getQualifiedNameStr() + ".");
        }
        return new VariableDeclaration(new JooSymbol("var"), new Ide(name), new TypeRelation(new JooSymbol(allowAnyProperty ? UNTYPED_MARKER : "*")));
    }

    @Nonnull
    private static JooSymbol getTextContent(XmlElement element) {
        return (JooSymbol)((Object)Iterables.getFirst(element.getTextNodes(), (Object)((Object)new JooSymbol(""))));
    }

    Collection<Directive> getClassBodyDirectives() {
        return this.classBodyDirectives;
    }
}

