/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.CompilationUnitResolver;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.BinaryOpExpr;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.EmptyStatement;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.ForInStatement;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectFieldOrSpread;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.PropertyDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.Spread;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeDeclaration;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.ast.VectorLiteral;
import net.jangaroo.jooc.backend.CodeGeneratorBase;
import net.jangaroo.jooc.backend.TypeScriptModuleResolver;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.jooc.mxml.ast.MxmlCompilationUnit;
import net.jangaroo.jooc.types.ExpressionType;
import net.jangaroo.jooc.types.FunctionSignature;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class TypeScriptCodeGenerator
extends CodeGeneratorBase {
    private static final Collection<String> TYPESCRIPT_BUILT_IN_TYPES = Arrays.asList("Object", "Array", "Vector$object");
    public static final List<AS3Type> TYPES_ALLOWED_AS_INDEX = Arrays.asList(AS3Type.ANY, AS3Type.STRING, AS3Type.NUMBER, AS3Type.INT, AS3Type.UINT);
    private static final String I_RESOURCE_MANAGER_QUALIFIED_NAME = "mx.resources.IResourceManager";
    private static final String GET_STRING_METHOD_NAME = "getString";
    private static final String REST_RESOURCE_ANNOTATION_NAME = "RestResource";
    private static final String REST_RESOURCE_URI_TEMPLATE_PARAMETER_NAME = "uriTemplate";
    private static final Map<String, Function<Annotation, String>> ANNOTATION_NAME_TO_TSDOC_TAG_RENDERER = new HashMap<String, Function<Annotation, String>>(){
        {
            this.put("PublicApi", annotation -> "\n * @public");
            this.put("Deprecated", annotation -> "\n * @deprecated" + TypeScriptCodeGenerator.renderDeprecatedParameters(annotation));
        }
    };
    private final TypeScriptModuleResolver typeScriptModuleResolver;
    private CompilationUnit compilationUnit;
    private Map<String, String> imports;
    private boolean companionInterfaceMode;
    private boolean needsCompanionInterface;
    private List<ClassDeclaration> mixinClasses;
    private boolean hasOwnConfigClass;
    private static final CodeGenerator ALIAS_THIS_CODE_GENERATOR = (out, first) -> out.write("const this$=this;");
    private static final Pattern SET_METHOD_NAME_PATTERN = Pattern.compile("set[A-Z].*");
    private static final Pattern ENDS_WITH_4_SPACES_INDENTATION = Pattern.compile("^([\\s\\S]*)\n( ?| {3,})$");
    private int staticCodeCounter = 0;

    private static String renderDeprecatedParameters(Annotation annotation) {
        Object replacements;
        ArrayList<String> parts = new ArrayList<String>();
        Map<String, Object> propertiesByName = annotation.getPropertiesByName();
        Object since = propertiesByName.get("since");
        if (since instanceof String) {
            parts.add(" since " + since);
        }
        if ((replacements = propertiesByName.get("replacement")) instanceof String) {
            parts.add(" Use {@link " + replacements + "} instead.");
        }
        return String.join((CharSequence)".", parts);
    }

    public static boolean generatesCode(IdeDeclaration primaryDeclaration) {
        return !TYPESCRIPT_BUILT_IN_TYPES.contains(primaryDeclaration.getQualifiedNameStr()) && primaryDeclaration.getAnnotation("Mixin") == null;
    }

    TypeScriptCodeGenerator(TypeScriptModuleResolver typeScriptModuleResolver, JsWriter out, CompilationUnitResolver compilationUnitModelResolver) {
        super(out, compilationUnitModelResolver);
        this.typeScriptModuleResolver = typeScriptModuleResolver;
    }

    @Override
    void visitDeclarationAnnotationsAndModifiers(IdeDeclaration declaration) throws IOException {
        Annotation nativeAnnotation;
        List<Annotation> annotations = declaration.getAnnotations();
        ArrayList<JooSymbol> whitespaceSymbols = new ArrayList<JooSymbol>();
        ArrayList<Annotation> tsdocTags = new ArrayList<Annotation>();
        for (Annotation annotation : annotations) {
            whitespaceSymbols.add(annotation.getSymbol());
            if (!ANNOTATION_NAME_TO_TSDOC_TAG_RENDERER.containsKey(annotation.getMetaName())) continue;
            tsdocTags.add(annotation);
        }
        Collections.addAll(whitespaceSymbols, declaration.getSymModifiers());
        whitespaceSymbols.add(declaration.getDeclarationSymbol());
        whitespaceSymbols.add(declaration.getIde().getSymbol());
        if (!tsdocTags.isEmpty()) {
            String newWhitespace;
            int lastSymbolWithASDocIndex;
            String tsDoc = TypeScriptCodeGenerator.toTsdoc(tsdocTags);
            JooSymbol lastSymbolWithASDoc = whitespaceSymbols.stream().reduce(null, (symbolWithASDoc, currentSymbol) -> TypeScriptCodeGenerator.containsASDoc(currentSymbol) ? currentSymbol : symbolWithASDoc);
            if (lastSymbolWithASDoc == null) {
                lastSymbolWithASDocIndex = whitespaceSymbols.size();
                newWhitespace = "/**" + tsDoc + "\n */\n";
            } else {
                String whitespace = lastSymbolWithASDoc.getWhitespace();
                Matcher matcher = Pattern.compile("\n? *\\*/").matcher(whitespace);
                if (!matcher.find()) {
                    throw new CompilerError(declaration.getSymbol(), "Internal error: End of ASDoc not found.");
                }
                StringBuffer builder = new StringBuffer();
                matcher.appendReplacement(builder, tsDoc + Matcher.quoteReplacement(matcher.group()));
                newWhitespace = matcher.appendTail(builder).toString();
                this.out.suppressWhitespace(lastSymbolWithASDoc);
                lastSymbolWithASDocIndex = whitespaceSymbols.indexOf((Object)lastSymbolWithASDoc);
                whitespaceSymbols.remove((Object)lastSymbolWithASDoc);
            }
            whitespaceSymbols.add(lastSymbolWithASDocIndex, new JooSymbol(71, "", -1, -1, newWhitespace, ""));
        }
        this.out.writeNonTrivialWhitespace(whitespaceSymbols);
        this.writeModifiers(declaration);
        if (declaration.isPrimaryDeclaration() && (nativeAnnotation = declaration.getAnnotation("Native")) != null && !TypeScriptCodeGenerator.isInterface(declaration)) {
            if (this.typeScriptModuleResolver.getNativeAnnotationRequireValue(nativeAnnotation) == null && declaration.getTargetQualifiedNameStr().contains(".")) {
                this.out.writeToken("export");
            } else {
                this.out.writeToken("declare");
            }
        }
    }

    private static String toTsdoc(List<Annotation> tsdocTags) {
        return tsdocTags.stream().map(tsdocTag -> ANNOTATION_NAME_TO_TSDOC_TAG_RENDERER.get(tsdocTag.getMetaName()).apply((Annotation)tsdocTag)).collect(Collectors.joining());
    }

    @Override
    protected void writeModifiers(IdeDeclaration declaration) throws IOException {
        if (!this.companionInterfaceMode && declaration.isClassMember()) {
            if (declaration.isProtected()) {
                this.out.writeToken("protected");
            }
            if (declaration.isStatic() && !(declaration instanceof ClassDeclaration)) {
                this.out.writeToken("static");
            }
            if (declaration.getSuperDeclaration() != null) {
                this.out.writeToken("override");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCompilationUnit(CompilationUnit compilationUnit) throws IOException {
        ClassDeclaration classDeclaration;
        ClassDeclaration configClassDeclaration;
        this.compilationUnit = compilationUnit;
        this.imports = new HashMap<String, String>();
        IdeDeclaration primaryDeclaration = compilationUnit.getPrimaryDeclaration();
        String targetQualifiedNameStr = primaryDeclaration.getTargetQualifiedNameStr();
        String primaryLocalName = CompilerUtils.className((String)targetQualifiedNameStr);
        this.imports.put(primaryDeclaration.getQualifiedNameStr(), primaryLocalName);
        this.out.writeSymbolWhitespace(compilationUnit.getPackageDeclaration().getSymbol());
        boolean isModule = this.typeScriptModuleResolver.getRequireModuleName(compilationUnit, primaryDeclaration) != null;
        String targetNamespace = null;
        HashSet<String> localNames = new HashSet<String>();
        if (isModule) {
            Set<String> usedBuiltInIdentifiers;
            if (!TypeScriptCodeGenerator.getMetadata(primaryDeclaration).isEmpty()) {
                compilationUnit.addBuiltInIdentifierUsage("metadata");
            }
            if (primaryDeclaration instanceof VariableDeclaration && this.isLazy((VariableDeclaration)primaryDeclaration)) {
                compilationUnit.addBuiltInIdentifierUsage(this.getLazyFactoryFunctionName((VariableDeclaration)primaryDeclaration));
            }
            if (primaryDeclaration instanceof ClassDeclaration && (((ClassDeclaration)primaryDeclaration).getConstructorConfigParameterType() != null || ((ClassDeclaration)primaryDeclaration).hasConfigClass() && ((ClassDeclaration)primaryDeclaration).getSuperTypeDeclaration().hasConfigClass())) {
                compilationUnit.addBuiltInIdentifierUsage("Config");
            }
            if (!(usedBuiltInIdentifiers = compilationUnit.getUsedBuiltInIdentifiers()).isEmpty()) {
                localNames.addAll(usedBuiltInIdentifiers);
                if (usedBuiltInIdentifiers.remove("Config")) {
                    this.out.write("import Config from \"@jangaroo/runtime/AS3/Config\";\n");
                }
                if (!usedBuiltInIdentifiers.isEmpty()) {
                    this.out.write(String.format("import { %s } from \"@jangaroo/runtime/AS3\";\n", String.join((CharSequence)", ", usedBuiltInIdentifiers)));
                }
            }
        } else {
            targetNamespace = CompilerUtils.packageName((String)targetQualifiedNameStr);
            if (!targetNamespace.isEmpty()) {
                this.out.writeToken("declare namespace");
                this.out.writeToken(targetNamespace);
                this.out.writeSymbol(compilationUnit.getLBrace());
            }
        }
        localNames.add(primaryLocalName);
        if (primaryDeclaration instanceof ClassDeclaration && (configClassDeclaration = (classDeclaration = (ClassDeclaration)primaryDeclaration).getConfigClassDeclaration()) != null && !configClassDeclaration.equals(classDeclaration.getSuperTypeDeclaration())) {
            localNames.add(primaryLocalName + "Config");
        }
        HashSet<String> localNameClashes = new HashSet<String>();
        Collection dependentCompilationUnitModels = compilationUnit.getCompileDependencies().stream().map(this.compilationUnitModelResolver::resolveCompilationUnit).filter(TypeScriptCodeGenerator::isNoFlExtEventClass).collect(Collectors.toList());
        for (CompilationUnit dependentCompilationUnitModel : dependentCompilationUnitModels) {
            if (this.typeScriptModuleResolver.getRequireModuleName(compilationUnit, dependentCompilationUnitModel.getPrimaryDeclaration()) == null && dependentCompilationUnitModel.getPrimaryDeclaration().getTargetQualifiedNameStr().contains(".")) continue;
            CompilationUnit compilationUnit2 = this.getCompilationUnitToRequire(dependentCompilationUnitModel);
            if (compilationUnit2 != null) {
                if (dependentCompilationUnitModels.contains(compilationUnit2)) continue;
                dependentCompilationUnitModel = compilationUnit2;
            }
            String localName = this.typeScriptModuleResolver.getDefaultImportName(dependentCompilationUnitModel.getPrimaryDeclaration());
            if (localNames.add(localName = localName.split("\\.")[0])) continue;
            localNameClashes.add(localName);
        }
        TreeMap<String, String> moduleNameToLocalName = new TreeMap<String, String>();
        for (CompilationUnit compilationUnit3 : dependentCompilationUnitModels) {
            String localName;
            void var12_16;
            IdeDeclaration dependentPrimaryDeclaration;
            String requireModuleName;
            CompilationUnit pseudoSingletonCompilationUnit = null;
            CompilationUnit compilationUnitToRequire = this.getCompilationUnitToRequire(compilationUnit3);
            if (compilationUnitToRequire != null) {
                pseudoSingletonCompilationUnit = compilationUnit3;
                CompilationUnit compilationUnit4 = compilationUnitToRequire;
            }
            if ((requireModuleName = this.typeScriptModuleResolver.getRequireModuleName(compilationUnit, dependentPrimaryDeclaration = var12_16.getPrimaryDeclaration())) == null) {
                localName = TypeScriptModuleResolver.getNonRequireNativeName(dependentPrimaryDeclaration);
            } else if (!isModule) {
                localName = String.format("import(\"%s\").default", requireModuleName);
            } else {
                localName = (String)moduleNameToLocalName.get(requireModuleName);
                if (localName == null) {
                    localName = this.typeScriptModuleResolver.getDefaultImportName(dependentPrimaryDeclaration);
                    if (localNameClashes.contains(localName)) {
                        localName = TypeScriptModuleResolver.toLocalName(dependentPrimaryDeclaration.getQualifiedName());
                    }
                    moduleNameToLocalName.put(requireModuleName, localName);
                }
                if (pseudoSingletonCompilationUnit != null) {
                    this.imports.put(pseudoSingletonCompilationUnit.getQualifiedNameStr(), localName + ".getInstance()");
                }
            }
            this.imports.put(dependentPrimaryDeclaration.getQualifiedNameStr(), localName);
        }
        for (Map.Entry entry : moduleNameToLocalName.entrySet()) {
            this.out.write(String.format("import %s from \"%s\";\n", entry.getValue(), entry.getKey()));
        }
        primaryDeclaration.visit(this);
        if (isModule) {
            if (!TypeScriptCodeGenerator.isPropertiesSubclass(primaryDeclaration) && !this.isInitFunction(primaryDeclaration)) {
                this.out.write("\nexport default " + primaryLocalName + ";\n");
            }
        } else if (!targetNamespace.isEmpty()) {
            this.out.writeSymbol(compilationUnit.getRBrace());
            this.out.write("\n");
        }
    }

    private CompilationUnit getCompilationUnitToRequire(CompilationUnit compilationUnit) {
        String requireValue;
        Annotation nativeAnnotation = compilationUnit.getPrimaryDeclaration().getAnnotation("Native");
        if (nativeAnnotation != null && (requireValue = this.typeScriptModuleResolver.getNativeAnnotationRequireValue(nativeAnnotation)) != null && !requireValue.isEmpty()) {
            return compilationUnit.getPrimaryDeclaration().getType().getDeclaration().getCompilationUnit();
        }
        return null;
    }

    private static boolean isNoFlExtEventClass(CompilationUnit compilationUnit) {
        return !(compilationUnit.getPrimaryDeclaration() instanceof ClassDeclaration) || !((ClassDeclaration)compilationUnit.getPrimaryDeclaration()).inheritsFromFlExtEvent();
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
        JooSymbol myMixinSymbolWithASDoc;
        ClassDeclaration myMixinInterface;
        if (TypeScriptCodeGenerator.isPropertiesClass(classDeclaration)) {
            this.visitPropertiesClassDeclaration(classDeclaration);
            return;
        }
        this.needsCompanionInterface = false;
        ArrayList<Ide> mixins = new ArrayList<Ide>();
        this.mixinClasses = new ArrayList<ClassDeclaration>();
        String classDeclarationLocalName = this.compilationUnitAccessCode(classDeclaration);
        ArrayList<String> configMixins = new ArrayList<String>();
        ArrayList<Ide> realInterfaces = new ArrayList<Ide>();
        if (classDeclaration.getOptImplements() != null) {
            CommaSeparatedList<Ide> superTypes = classDeclaration.getOptImplements().getSuperTypes();
            do {
                ClassDeclaration maybeMixinDeclaration;
                CompilationUnit mixinCompilationUnit;
                if ((mixinCompilationUnit = CompilationUnit.getMixinCompilationUnit(maybeMixinDeclaration = (ClassDeclaration)superTypes.getHead().getDeclaration(false))) != null && mixinCompilationUnit != this.compilationUnit) {
                    this.mixinClasses.add(maybeMixinDeclaration);
                    mixins.add(superTypes.getHead());
                    if (!maybeMixinDeclaration.hasConfigClass()) continue;
                    configMixins.add(this.configType(maybeMixinDeclaration));
                    continue;
                }
                realInterfaces.add(superTypes.getHead());
            } while ((superTypes = superTypes.getTail()) != null);
        }
        ClassDeclaration configClassDeclaration = classDeclaration.getConfigClassDeclaration();
        ClassDeclaration superTypeDeclaration = classDeclaration.getSuperTypeDeclaration();
        boolean bl = this.hasOwnConfigClass = configClassDeclaration != null;
        if (this.hasOwnConfigClass) {
            List configs = classDeclaration.getMembers().stream().filter(typedIdeDeclaration -> !typedIdeDeclaration.isMixinMemberRedeclaration() && typedIdeDeclaration.isExtConfigOrBindable()).collect(Collectors.toList());
            if (configClassDeclaration.equals(superTypeDeclaration)) {
                if (configs.isEmpty() && configMixins.isEmpty()) {
                    this.hasOwnConfigClass = false;
                } else {
                    classDeclaration.getIde().getScope().getCompiler().getLog().warning((FilePosition)((Parameter)classDeclaration.getConstructor().getParams().getHead()).getSymbol(), "A class reusing the Config type of its superclass in its config constructor parameter may not define own Configs or add Configs from mixins. Please change the constructor parameter type or (re)move the additional Configs.");
                }
            }
            if (this.hasOwnConfigClass) {
                ArrayList<String> configExtends = new ArrayList<String>();
                if (superTypeDeclaration != null && superTypeDeclaration.hasConfigClass()) {
                    configExtends.add(this.configType(superTypeDeclaration));
                }
                configExtends.addAll(configMixins);
                if (!configs.isEmpty()) {
                    String configNamesType = configs.stream().map(config -> CompilerUtils.quote((String)config.getName())).collect(Collectors.joining(" |\n  "));
                    configExtends.add(String.format("Partial<Pick<%s,\n  %s\n>>", classDeclarationLocalName, configNamesType));
                }
                this.out.write(String.format("interface %s%s {\n}\n\n", classDeclarationLocalName + "Config", configExtends.isEmpty() ? "" : " extends " + String.join((CharSequence)", ", configExtends)));
            }
        }
        if ((myMixinInterface = classDeclaration.getMyMixinInterface()) != null && (myMixinSymbolWithASDoc = this.findSymbolWithASDoc(myMixinInterface)) != null) {
            this.out.writeSymbolWhitespace(myMixinSymbolWithASDoc);
            JooSymbol classSymbolWithASDoc = this.findSymbolWithASDoc(classDeclaration);
            if (classSymbolWithASDoc != null) {
                this.out.suppressWhitespace(classSymbolWithASDoc);
            }
        }
        this.visitDeclarationAnnotationsAndModifiers(classDeclaration);
        if (TypeScriptCodeGenerator.isAmbientInterface(classDeclaration.getCompilationUnit())) {
            this.out.writeToken("interface");
        } else {
            if (classDeclaration.isInterface()) {
                this.out.writeToken("abstract");
            }
            this.out.writeToken("class");
        }
        this.writeSymbolReplacement(classDeclaration.getIde().getSymbol(), this.getLocalName(classDeclaration, false));
        this.visitIfNotNull(classDeclaration.getOptExtends());
        if (classDeclaration.getOptImplements() != null) {
            JooSymbol extendsOrImplements;
            if (classDeclaration.isInterface() && classDeclaration.getOptImplements().getSuperTypes().getTail() != null) {
                extendsOrImplements = new JooSymbol("implements");
                this.needsCompanionInterface = true;
                mixins = realInterfaces;
            } else {
                extendsOrImplements = classDeclaration.getOptImplements().getSymImplements();
            }
            this.visitImplementsFiltered(extendsOrImplements, classDeclaration.getOptImplements(), realInterfaces);
        }
        classDeclaration.getBody().visit(this);
        if (this.needsCompanionInterface) {
            this.out.write("\ninterface " + classDeclarationLocalName);
            this.visitImplementsFiltered(new JooSymbol("extends"), classDeclaration.getOptImplements(), mixins);
            this.companionInterfaceMode = true;
            classDeclaration.getBody().visit(this);
            this.companionInterfaceMode = false;
            this.out.write("\n");
        }
        this.generateClassMetadata(classDeclaration);
        if (classDeclaration.isPrimaryDeclaration()) {
            this.visitAll(classDeclaration.getSecondaryDeclarations());
        }
    }

    private static List<Annotation> getMetadata(IdeDeclaration declaration) {
        return declaration.getAnnotations().stream().filter(annotation -> !REST_RESOURCE_ANNOTATION_NAME.equals(annotation.getMetaName()) && !Jooc.ANNOTATIONS_FOR_COMPILER_ONLY.contains(annotation.getMetaName())).collect(Collectors.toList());
    }

    private void generateClassMetadata(ClassDeclaration classDeclaration) throws IOException {
        String classDeclarationLocalName = this.compilationUnitAccessCode(classDeclaration);
        if (classDeclaration.getAnnotation("Native") == null) {
            List<Annotation> metadata;
            if (!(classDeclaration.getOptImplements() == null || classDeclaration.isInterface() && classDeclaration.getOptImplements().getSuperTypes().getTail() == null)) {
                boolean foundNonMixinInterface = false;
                for (CommaSeparatedList<Ide> superTypes = classDeclaration.getOptImplements().getSuperTypes(); superTypes != null; superTypes = superTypes.getTail()) {
                    if (this.isCurrentMixinInterface(superTypes.getHead())) continue;
                    if (!foundNonMixinInterface) {
                        this.out.write("\nmixin(" + classDeclarationLocalName);
                        foundNonMixinInterface = true;
                    }
                    this.out.write(", ");
                    superTypes.getHead().visit(this);
                }
                if (foundNonMixinInterface) {
                    this.out.write(");\n");
                }
            }
            if (!(metadata = TypeScriptCodeGenerator.getMetadata(classDeclaration)).isEmpty()) {
                this.out.write("\nmetadata(" + classDeclarationLocalName + ", [");
                boolean firstAnnotation = true;
                for (Annotation runtimeAnnotation : metadata) {
                    CommaSeparatedList<AnnotationParameter> annotationParameters;
                    if (firstAnnotation) {
                        firstAnnotation = false;
                    } else {
                        this.out.write(",\n    ");
                    }
                    this.out.write(CompilerUtils.quote((String)runtimeAnnotation.getMetaName()));
                    if (annotationParameters != null) {
                        this.out.write(", {");
                        boolean firstParameter = true;
                        for (annotationParameters = runtimeAnnotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
                            AnnotationParameter annotationParameter = annotationParameters.getHead();
                            if (firstParameter) {
                                firstParameter = false;
                            } else {
                                this.out.write(", ");
                            }
                            this.visitIfNotNull(annotationParameter.getOptName(), "\"\"");
                            this.out.write(": ");
                            this.visitIfNotNull(annotationParameter.getValue(), "true");
                        }
                        this.out.write("}");
                    }
                    this.out.write("]");
                }
                this.out.write(");\n");
            }
        }
    }

    private void visitPropertiesClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
        this.visitDeclarationAnnotationsAndModifiers(classDeclaration);
        this.out.writeSymbolWhitespace(classDeclaration.getSymClass());
        FunctionDeclaration constructorDeclaration = classDeclaration.getConstructor();
        List<AssignmentOpExpr> propertyAssignments = this.getPropertiesClassAssignments(constructorDeclaration, true, true);
        if (TypeScriptCodeGenerator.isPropertiesSubclass(classDeclaration)) {
            this.out.write("ResourceBundleUtil.override(" + this.compilationUnitAccessCode(classDeclaration.getSuperTypeDeclaration()) + ", {");
            this.renderPropertiesClassValues(propertyAssignments, true, false, false);
            this.out.write("\n});\n");
        } else {
            String classDeclarationLocalName = this.getLocalName(classDeclaration, false);
            this.out.write("interface " + classDeclarationLocalName + " {");
            for (AssignmentOpExpr propertyAssignment : propertyAssignments) {
                AstNode index = this.getObjectAndProperty(propertyAssignment).getValue();
                if (index instanceof Ide && ((Ide)index).getDeclaration(false) != null) {
                    IdeDeclaration declaration = ((Ide)index).getDeclaration();
                    this.out.writeSymbolWhitespace(declaration.getSymbol());
                    this.out.write("  ");
                } else {
                    this.out.writeSymbolWhitespace(propertyAssignment.getSymbol());
                }
                index.visit(this);
                this.out.writeToken(": string;");
            }
            this.out.write("\n}");
            TypedIdeDeclaration instanceDeclaration = classDeclaration.getStaticMemberDeclaration("INSTANCE");
            this.out.writeSymbolWhitespace(instanceDeclaration != null ? instanceDeclaration.getSymbol() : (constructorDeclaration != null ? constructorDeclaration.getSymbol() : new JooSymbol("\n")));
            this.out.write(String.format("const %s: %s = {", classDeclarationLocalName, classDeclarationLocalName));
            this.renderPropertiesClassValues(propertyAssignments, false, false, false);
            this.out.write("\n};\n");
        }
    }

    private boolean isCurrentMixinInterface(Ide head) {
        return CompilationUnit.mapMixinInterface(head.getDeclaration().getCompilationUnit()).equals(this.compilationUnit);
    }

    private void visitImplementsFiltered(JooSymbol symImplementsOrExtends, Implements optImplements, List<Ide> filter) throws IOException {
        JooSymbol lastSym = symImplementsOrExtends;
        if (optImplements != null) {
            CommaSeparatedList<Ide> current = optImplements.getSuperTypes();
            do {
                Ide head;
                if (!filter.contains(head = current.getHead()) || this.isCurrentMixinInterface(head)) continue;
                this.out.writeSymbol(lastSym);
                lastSym = current.getSymComma();
                head.visit(this);
            } while ((current = current.getTail()) != null);
        }
    }

    @Override
    public void visitTypeRelation(TypeRelation typeRelation) throws IOException {
        AstNode parentNode = typeRelation.getParentNode();
        if (parentNode instanceof FunctionExpr) {
            parentNode = parentNode.getParentNode();
        }
        if (parentNode instanceof IdeDeclaration) {
            String tsType;
            this.out.writeSymbol(typeRelation.getSymbol());
            ExpressionType expressionType = ((IdeDeclaration)parentNode).getType();
            if (expressionType instanceof FunctionSignature) {
                expressionType = expressionType.getTypeParameter();
            }
            if ("any".equals(tsType = this.getTypeScriptTypeForActionScriptType(expressionType)) && parentNode instanceof VariableDeclaration && this.hasObjectLiteralInitializer((VariableDeclaration)parentNode)) {
                tsType = "Record<string,any>";
            }
            this.writeSymbolReplacement(typeRelation.getType().getSymbol(), tsType);
        } else {
            super.visitTypeRelation(typeRelation);
        }
    }

    private boolean hasObjectLiteralInitializer(VariableDeclaration variableDeclaration) {
        return variableDeclaration.getOptInitializer() != null && variableDeclaration.getOptInitializer().getValue() instanceof ObjectLiteral;
    }

    @Override
    public void visitType(Type type) throws IOException {
        String tsType = this.getTypeScriptTypeForActionScriptType(type);
        this.writeSymbolReplacement(type.getSymbol(), tsType);
    }

    private String getTypeScriptTypeForActionScriptType(Type type) {
        return this.getTypeScriptTypeForActionScriptType(new ExpressionType(type));
    }

    private String getTypeScriptTypeForActionScriptType(ExpressionType expressionType) {
        AS3Type as3Type = expressionType == null ? AS3Type.ANY : expressionType.getAS3Type();
        switch (as3Type) {
            case OBJECT: {
                TypeDeclaration declaration = expressionType.getDeclaration();
                String qualifiedNameStr = declaration.getQualifiedNameStr();
                if (as3Type.name.equals(qualifiedNameStr)) {
                    return "any";
                }
                if ("js.Promise".equals(qualifiedNameStr)) {
                    return "Promise<any>";
                }
                if ("js.Map".equals(qualifiedNameStr)) {
                    return "Map<any, any>";
                }
                String tsType = this.getLocalName(declaration, true);
                return expressionType.isConfigType() ? this.configType(tsType) : tsType;
            }
            case ANY: {
                return "any";
            }
            case VECTOR: 
            case ARRAY: {
                return "Array<" + this.getTypeScriptTypeForActionScriptType(expressionType.getTypeParameter()) + ">";
            }
            case UINT: 
            case INT: {
                return this.imports.get(expressionType.getDeclaration().getQualifiedNameStr());
            }
            case BOOLEAN: 
            case NUMBER: 
            case STRING: {
                return as3Type.name.toLowerCase();
            }
            case FUNCTION: {
                return "AnyFunction";
            }
        }
        return as3Type.name;
    }

    @Override
    public void visitParameter(Parameter parameter) throws IOException {
        boolean isOptional;
        this.writeOptSymbol(parameter.getOptSymRest());
        parameter.getIde().visit(this);
        Initializer initializer = parameter.getOptInitializer();
        boolean bl = isOptional = initializer != null && (TypeScriptCodeGenerator.isAmbientOrInterface(this.compilationUnit) || TypeScriptCodeGenerator.isUndefined(initializer.getValue()) || this.companionInterfaceMode);
        if (isOptional) {
            this.out.write("?");
        }
        this.visitParameterTypeRelation(parameter);
        if (initializer != null && !isOptional) {
            initializer.visit(this);
        }
    }

    private static boolean isUndefined(Expr expr) {
        return expr instanceof IdeExpr && "undefined".equals(((IdeExpr)expr).getIde().getName());
    }

    private boolean isCompilationUnitAmbient() {
        return TypeScriptCodeGenerator.isAmbient(this.compilationUnit);
    }

    private static boolean isAmbientOrInterface(CompilationUnit compilationUnit) {
        return TypeScriptCodeGenerator.isAmbient(compilationUnit) || TypeScriptCodeGenerator.isInterface(compilationUnit.getPrimaryDeclaration());
    }

    private static boolean isAmbientInterface(CompilationUnit compilationUnit) {
        return TypeScriptCodeGenerator.isAmbient(compilationUnit) && TypeScriptCodeGenerator.isInterface(compilationUnit.getPrimaryDeclaration());
    }

    private static boolean isNonAmbientInterface(CompilationUnit compilationUnit) {
        return !TypeScriptCodeGenerator.isAmbient(compilationUnit) && TypeScriptCodeGenerator.isInterface(compilationUnit.getPrimaryDeclaration());
    }

    private static boolean isAmbient(CompilationUnit compilationUnit) {
        IdeDeclaration primaryDeclaration = compilationUnit.getPrimaryDeclaration();
        return primaryDeclaration.getAnnotation("Native") != null || primaryDeclaration.isNative();
    }

    private static boolean isInterface(IdeDeclaration primaryDeclaration) {
        return primaryDeclaration instanceof ClassDeclaration && ((ClassDeclaration)primaryDeclaration).isInterface();
    }

    @Override
    public void visitInitializer(Initializer initializer) throws IOException {
        if (!TypeScriptCodeGenerator.isAmbientOrInterface(this.compilationUnit)) {
            super.visitInitializer(initializer);
        }
    }

    @Override
    protected void visitObjectFieldValue(ObjectField objectField) throws IOException {
        Expr fieldValue = objectField.getValue();
        JooSymbol symbol = fieldValue.getSymbol();
        if (Pattern.matches("[\\s]+", symbol.getWhitespace())) {
            this.out.suppressWhitespace(symbol);
            this.out.write(" ");
        }
        if (fieldValue instanceof ApplyExpr && TypeScriptCodeGenerator.isApiCall((ApplyExpr)fieldValue, "net.jangaroo.ext.Exml", "eventHandler", true)) {
            ((ApplyExpr)fieldValue).getArgs().getExpr().getTail().getTail().getHead().visit(this);
        } else {
            super.visitObjectFieldValue(objectField);
        }
    }

    @Override
    public void visitVectorLiteral(VectorLiteral vectorLiteral) throws IOException {
        vectorLiteral.getArrayLiteral().visit(this);
    }

    @Override
    public void visitImportDirective(ImportDirective importDirective) {
    }

    @Override
    public void visitEmptyStatement(EmptyStatement emptyStatement) throws IOException {
        if (!emptyStatement.isClassMember()) {
            super.visitEmptyStatement(emptyStatement);
        }
    }

    @Override
    public void visitAnnotation(Annotation annotation) throws IOException {
        if (Jooc.ANNOTATIONS_FOR_COMPILER_ONLY.contains(annotation.getMetaName())) {
            this.out.writeSymbolWhitespace(annotation.getSymbol());
            return;
        }
        this.out.beginComment();
        this.writeSymbolReplacement(annotation.getLeftBracket(), "@");
        annotation.getIde().visit(this);
        this.writeOptSymbol(annotation.getOptLeftParen());
        CommaSeparatedList<AnnotationParameter> annotationParameters = annotation.getOptAnnotationParameters();
        if (annotationParameters != null) {
            this.out.write("{");
            annotationParameters.visit(this);
            this.out.write("}");
        }
        this.writeOptSymbol(annotation.getOptRightParen());
        this.out.endComment();
        this.out.writeSymbolWhitespace(annotation.getRightBracket());
    }

    @Override
    public void visitAnnotationParameter(AnnotationParameter annotationParameter) throws IOException {
        this.visitIfNotNull(annotationParameter.getOptName(), "\"_\"");
        if (annotationParameter.getOptSymEq() != null) {
            this.writeSymbolReplacement(annotationParameter.getOptSymEq(), ":");
        }
        this.visitIfNotNull(annotationParameter.getValue(), "true");
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
        if (this.companionInterfaceMode) {
            return;
        }
        if (variableDeclaration.isClassMember()) {
            ClassDeclaration classDeclaration = variableDeclaration.getClassDeclaration();
            if (TypeScriptCodeGenerator.isNonAmbientInterface(classDeclaration.getCompilationUnit())) {
                this.out.writeSymbolWhitespace(variableDeclaration.getSymbol());
                this.out.writeToken("abstract");
            }
            boolean bindable = variableDeclaration.isBindable();
            for (VariableDeclaration currentVariableDeclaration = variableDeclaration; currentVariableDeclaration != null; currentVariableDeclaration = currentVariableDeclaration.getOptNextVariableDeclaration()) {
                if (bindable) {
                    this.out.write("\n\n ");
                    this.visitVariableDeclarationBase(currentVariableDeclaration);
                    this.writeOptSymbol(variableDeclaration.getOptSymSemicolon(), "\n");
                    String accessor = currentVariableDeclaration.getName();
                    this.visitDeclarationAnnotationsAndModifiers(variableDeclaration);
                    this.out.writeToken("get");
                    this.out.write(" " + accessor + "()");
                    this.visitIfNotNull(currentVariableDeclaration.getOptTypeRelation());
                    this.out.write(String.format(" { return this.#%s; }", accessor));
                    String setMethodName = (Object)((Object)MethodType.SET) + MxmlUtils.capitalize(accessor);
                    TypedIdeDeclaration setMethodDeclaration = classDeclaration.getMemberDeclaration(setMethodName);
                    if (setMethodDeclaration != null && !setMethodDeclaration.isPrivate()) continue;
                    this.out.write("\n  ");
                    if (currentVariableDeclaration.getSuperDeclaration() != null) {
                        this.out.write("override ");
                    }
                    this.out.write(String.format("set %s(value", accessor));
                    this.visitIfNotNull(currentVariableDeclaration.getOptTypeRelation());
                    this.out.write(String.format(") { this.#%s = value; }", accessor));
                    continue;
                }
                if (currentVariableDeclaration == variableDeclaration) {
                    this.visitDeclarationAnnotationsAndModifiers(variableDeclaration);
                } else {
                    this.visitAll(variableDeclaration.getAnnotations());
                    this.out.writeSymbolWhitespace(currentVariableDeclaration.getIde().getSymbol());
                    this.writeModifiers(variableDeclaration);
                }
                if (variableDeclaration.isConst()) {
                    this.writeReadonlySuppressWhitespace(currentVariableDeclaration.getIde().getSymbol());
                }
                this.visitVariableDeclarationBase(currentVariableDeclaration);
                this.writeOptSymbol(variableDeclaration.getOptSymSemicolon(), "\n");
            }
        } else {
            super.visitVariableDeclaration(variableDeclaration);
        }
    }

    @Override
    void writeVarOrConst(VariableDeclaration variableDeclaration) throws IOException {
        if (this.isPrimaryVariableDeclaration(variableDeclaration)) {
            this.writeSymbolReplacement(variableDeclaration.getOptSymConstOrVar(), "const");
        } else {
            super.writeVarOrConst(variableDeclaration);
        }
    }

    private void writeReadonlySuppressWhitespace(JooSymbol suppressWhitespaceOf) throws IOException {
        this.out.writeToken("readonly");
        this.out.write(" ");
        this.out.suppressWhitespace(suppressWhitespaceOf);
    }

    @Override
    void visitVariableDeclarationBase(VariableDeclaration variableDeclaration) throws IOException {
        TypeRelation typeRelation = variableDeclaration.getOptTypeRelation();
        Initializer initializer = variableDeclaration.getOptInitializer();
        Ide ide = variableDeclaration.getIde();
        if (variableDeclaration.isClassMember()) {
            if (variableDeclaration.isPrivate() || variableDeclaration.isBindable()) {
                this.writeSymbolReplacement(ide.getSymbol(), this.getHashPrivateName(variableDeclaration));
            } else {
                ide.visit(this);
            }
            this.visitIfNotNull(typeRelation);
            if (!TypeScriptCodeGenerator.isAmbientOrInterface(this.compilationUnit)) {
                this.generateInitializer(variableDeclaration);
            }
        } else if (this.isPrimaryVariableDeclaration(variableDeclaration)) {
            this.writeSymbolReplacement(ide.getSymbol(), CompilerUtils.className((String)variableDeclaration.getTargetQualifiedNameStr()));
            if (typeRelation != null) {
                this.out.writeSymbol(typeRelation.getSymRelation());
                this.out.write("{");
                if (variableDeclaration.isConst()) {
                    this.out.write("readonly ");
                }
                this.out.write("_: ");
                typeRelation.getType().visit(this);
                this.out.write("}");
            }
            if (!this.isCompilationUnitAmbient()) {
                if (initializer != null) {
                    this.out.writeSymbol(initializer.getSymEq());
                } else {
                    this.out.write("=");
                }
                if (this.isLazy(variableDeclaration)) {
                    this.out.write(this.getLazyFactoryFunctionName(variableDeclaration) + "(() =>");
                    if (initializer != null) {
                        this.visitExprWithParenthesisIfObjectLiteral(initializer.getValue());
                    } else {
                        this.out.write(VariableDeclaration.getDefaultValue(typeRelation));
                    }
                    this.out.write(")");
                } else {
                    this.out.write("{_: ");
                    if (initializer != null) {
                        initializer.getValue().visit(this);
                    } else {
                        this.out.write(VariableDeclaration.getDefaultValue(typeRelation));
                    }
                    this.out.write("}");
                }
            }
        } else {
            ide.visit(this);
            if (typeRelation != null && (initializer == null || TypeScriptCodeGenerator.isAmbientOrInterface(this.compilationUnit) || initializer.getValue().getType() == null || initializer.getValue() instanceof ObjectLiteral || !initializer.getValue().getType().equals(variableDeclaration.getType()))) {
                typeRelation.visit(this);
            }
            this.visitIfNotNull(initializer);
        }
    }

    private boolean isPrimaryVariableDeclaration(VariableDeclaration variableDeclaration) {
        return variableDeclaration.isPrimaryDeclaration() && (!variableDeclaration.isConst() || this.isLazy(variableDeclaration)) && this.typeScriptModuleResolver.getRequireModuleName(this.compilationUnit, variableDeclaration) != null;
    }

    private boolean isLazy(VariableDeclaration variableDeclaration) {
        return variableDeclaration.getAnnotation("Lazy") != null;
    }

    private String getLazyFactoryFunctionName(VariableDeclaration variableDeclaration) {
        return variableDeclaration.isConst() ? "lazyConst" : "lazyVar";
    }

    private void generateInitializer(VariableDeclaration variableDeclaration) throws IOException {
        Initializer initializer = variableDeclaration.getOptInitializer();
        if (initializer != null) {
            if (!variableDeclaration.isStatic() && initializer.getValue() instanceof FunctionExpr && ((FunctionExpr)initializer.getValue()).isThisAliased(true)) {
                this.out.writeSymbol(initializer.getSymEq());
                this.out.write(" (this$ =>");
                initializer.getValue().visit(this);
                this.out.write(")(this)");
            } else {
                initializer.visit(this);
            }
        } else {
            String implicitDefaultValue = VariableDeclaration.getDefaultValue(variableDeclaration.getOptTypeRelation());
            if (!"undefined".equals(implicitDefaultValue)) {
                this.out.write(" = " + implicitDefaultValue);
            }
        }
    }

    private String getHashPrivateName(IdeDeclaration varOrFunDeclaration) {
        return "#" + varOrFunDeclaration.getIde().getName();
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) throws IOException {
        if (!this.isCompilationUnitAmbient()) {
            super.visitBlockStatement(blockStatement);
        }
    }

    private static TypedIdeDeclaration getAccessorNameFromSetMethod(FunctionDeclaration functionDeclaration) {
        TypedIdeDeclaration maybeBindablePropertyDeclaration;
        String setAccessorName;
        String methodName;
        if (!functionDeclaration.isPrivate() && functionDeclaration.getParams() != null && functionDeclaration.getParams().getTail() == null && SET_METHOD_NAME_PATTERN.matcher(methodName = functionDeclaration.getName()).matches() && (setAccessorName = CompilerUtils.uncapitalize((String)methodName.substring(3))) != null && ((maybeBindablePropertyDeclaration = functionDeclaration.getClassDeclaration().getMemberDeclaration(setAccessorName)) instanceof PropertyDeclaration || maybeBindablePropertyDeclaration instanceof VariableDeclaration) && maybeBindablePropertyDeclaration.isBindable()) {
            return maybeBindablePropertyDeclaration;
        }
        return null;
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
        FunctionExpr functionExpr = functionDeclaration.getFun();
        if (functionDeclaration.isClassMember()) {
            boolean renderIntoInterface;
            boolean convertToProperty;
            boolean isAmbientOrInterface = TypeScriptCodeGenerator.isAmbientOrInterface(functionDeclaration.getCompilationUnit());
            boolean bl = convertToProperty = functionDeclaration.isGetterOrSetter() && (functionDeclaration.isNative() && !functionDeclaration.isBindable() || isAmbientOrInterface);
            if (convertToProperty && functionDeclaration.isSetter()) {
                return;
            }
            if (functionDeclaration.isNative()) {
                for (ClassDeclaration mixinClass : this.mixinClasses) {
                    if (mixinClass.resolvePropertyDeclaration(functionDeclaration.getName()) == null) continue;
                    this.needsCompanionInterface = true;
                    return;
                }
            }
            boolean bl2 = renderIntoInterface = !convertToProperty && !isAmbientOrInterface && functionDeclaration.isNative() && !functionDeclaration.isBindable();
            if (renderIntoInterface) {
                this.needsCompanionInterface = true;
            }
            if (this.companionInterfaceMode != renderIntoInterface) {
                return;
            }
            ClassDeclaration myMixinInterface = functionDeclaration.getClassDeclaration().getMyMixinInterface();
            if (myMixinInterface != null) {
                JooSymbol interfaceSymbolWithASDoc;
                TypedIdeDeclaration interfaceMethod = myMixinInterface.getMemberDeclaration(functionDeclaration.getName());
                if (interfaceMethod instanceof PropertyDeclaration) {
                    interfaceMethod = ((PropertyDeclaration)interfaceMethod).getAccessor(functionDeclaration.isSetter());
                }
                if (interfaceMethod != null && (interfaceSymbolWithASDoc = this.findSymbolWithASDoc(interfaceMethod)) != null) {
                    this.out.writeSymbolWhitespace(interfaceSymbolWithASDoc);
                    JooSymbol implMethodSymbolWithASDoc = this.findSymbolWithASDoc(functionDeclaration);
                    if (implMethodSymbolWithASDoc != null) {
                        String implMethodWhitespace = implMethodSymbolWithASDoc.getWhitespace();
                        if (!implMethodWhitespace.contains("@inheritDoc") && !implMethodWhitespace.contains("@private")) {
                            functionDeclaration.getIde().getScope().getCompiler().getLog().warning((FilePosition)implMethodSymbolWithASDoc, "Mixin method implementation has non-inheriting ASDoc. Please move such documentation to the mixin interface before TypeScript conversion.");
                        }
                        this.out.suppressWhitespace(implMethodSymbolWithASDoc);
                    }
                }
            }
            TypedIdeDeclaration setAccessor = TypeScriptCodeGenerator.getAccessorNameFromSetMethod(functionDeclaration);
            if (functionDeclaration.isNative() && functionDeclaration.isBindable() && !this.companionInterfaceMode && functionDeclaration.isGetter()) {
                this.out.write("\n  #" + functionDeclaration.getName());
                this.visitIfNotNull(functionDeclaration.getOptTypeRelation());
                this.out.write(";\n");
            }
            this.visitDeclarationAnnotationsAndModifiers(functionDeclaration);
            if (TypeScriptCodeGenerator.isNonAmbientInterface(functionDeclaration.getClassDeclaration().getCompilationUnit())) {
                this.out.writeSymbolWhitespace(functionDeclaration.getSymbol());
                this.out.writeToken("abstract");
            }
            this.writeOptSymbolWhitespace(functionDeclaration.getSymbol());
            if (convertToProperty) {
                if (!TypeScriptCodeGenerator.hasSetter(functionDeclaration)) {
                    this.writeReadonlySuppressWhitespace(functionDeclaration.getIde().getSymbol());
                }
            } else if (setAccessor != null) {
                this.out.writeToken(MethodType.SET.toString());
            } else {
                this.writeOptSymbol(functionDeclaration.getSymGetOrSet());
            }
            if (functionDeclaration.isConstructor()) {
                this.writeSymbolReplacement(functionDeclaration.getIde().getSymbol(), "constructor");
            } else if (functionDeclaration.isPrivate()) {
                this.writeSymbolReplacement(functionDeclaration.getIde().getSymbol(), this.getHashPrivateName(functionDeclaration));
            } else if (setAccessor != null) {
                this.writeSymbolReplacement(functionDeclaration.getIde().getSymbol(), setAccessor.getName());
            } else {
                functionDeclaration.getIde().visit(this);
            }
            if (!convertToProperty) {
                this.out.writeSymbol(functionExpr.getLParen());
                this.visitIfNotNull(functionExpr.getParams());
                this.out.writeSymbol(functionExpr.getRParen());
            }
            if (!functionDeclaration.isConstructor() && !functionDeclaration.isSetter() && setAccessor == null) {
                this.generateFunctionExprReturnTypeRelation(functionExpr);
            }
            if (functionDeclaration.isConstructor() && !functionDeclaration.containsSuperConstructorCall() && functionDeclaration.getClassDeclaration().getOptExtends() != null) {
                this.addBlockStartCodeGenerator(functionDeclaration.getBody(), (out, first) -> out.write("\n    super();"));
            }
            if (functionDeclaration.isThisAliased(true) && !functionDeclaration.isContainsSuperConstructorCall()) {
                this.addBlockStartCodeGenerator(functionDeclaration.getBody(), ALIAS_THIS_CODE_GENERATOR);
            }
            if (functionDeclaration.isNative() && functionDeclaration.isBindable() && !this.companionInterfaceMode) {
                if (functionDeclaration.isGetter()) {
                    this.out.write(" { return this.#" + functionDeclaration.getName() + "; }");
                } else {
                    this.out.write(" { this.#" + functionDeclaration.getName() + " = " + ((Parameter)functionDeclaration.getParams().getHead()).getName() + "; }");
                }
            } else {
                this.visitIfNotNull(functionExpr.getBody());
                this.writeOptSymbol(functionDeclaration.getOptSymSemicolon());
            }
        } else {
            if (functionDeclaration.isPrimaryDeclaration()) {
                if (this.isInitFunction(functionDeclaration)) {
                    this.visitAll(functionDeclaration.getBody().getDirectives());
                    this.out.writeSymbolWhitespace(functionDeclaration.getBody().getRBrace());
                    return;
                }
                this.visitDeclarationAnnotationsAndModifiers(functionDeclaration);
            }
            functionExpr.visit(this);
            this.writeOptSymbolWhitespace(functionDeclaration.getOptSymSemicolon());
        }
    }

    private boolean isInitFunction(IdeDeclaration ideDeclaration) {
        if ("init".equals(ideDeclaration.getExtNamespaceRelativeTargetQualifiedNameStr()) && ideDeclaration instanceof FunctionDeclaration) {
            FunctionDeclaration functionDeclaration = (FunctionDeclaration)ideDeclaration;
            return functionDeclaration.getParams() == null && (functionDeclaration.getOptTypeRelation() == null || AS3Type.VOID.name.equals(functionDeclaration.getOptTypeRelation().getType().getIde().getName()));
        }
        return false;
    }

    JooSymbol findSymbolWithASDoc(IdeDeclaration declaration) {
        if (TypeScriptCodeGenerator.containsASDoc(declaration.getSymbol())) {
            return declaration.getSymbol();
        }
        for (JooSymbol symModifier : declaration.getSymModifiers()) {
            if (!TypeScriptCodeGenerator.containsASDoc(symModifier)) continue;
            return symModifier;
        }
        for (Annotation annotation : declaration.getAnnotations()) {
            if (!TypeScriptCodeGenerator.containsASDoc(annotation.getSymbol())) continue;
            return annotation.getSymbol();
        }
        return null;
    }

    private static boolean containsASDoc(JooSymbol symbol) {
        return symbol.getWhitespace().contains("/**");
    }

    @Override
    void generateFunctionExprReturnTypeRelation(FunctionExpr functionExpr) throws IOException {
        TypeRelation optTypeRelation = functionExpr.getOptTypeRelation();
        String returnTypeFromAnnotation = functionExpr.getReturnTypeFromAnnotation();
        if (returnTypeFromAnnotation != null) {
            this.writeOptSymbol(optTypeRelation == null ? null : optTypeRelation.getSymRelation(), ": ");
            this.out.write(returnTypeFromAnnotation);
        } else {
            this.visitIfNotNull(optTypeRelation);
        }
    }

    @Override
    protected void visitBlockStatementDirectives(BlockStatement body) throws IOException {
        if (!(this.compilationUnit.getPrimaryDeclaration() instanceof ClassDeclaration && body.usesInstanceThis() && body.getParentNode() instanceof FunctionExpr && body.getParentNode().getParentNode() instanceof FunctionDeclaration && ((FunctionDeclaration)body.getParentNode().getParentNode()).containsSuperConstructorCall() && ((FunctionDeclaration)body.getParentNode().getParentNode()).getClassDeclaration().notExtendsObject())) {
            super.visitBlockStatementDirectives(body);
            return;
        }
        boolean isExtClass = ((ClassDeclaration)this.compilationUnit.getPrimaryDeclaration()).inheritsFromExtBaseExplicitly();
        Iterator<Directive> iterator = body.getDirectives().iterator();
        ArrayList<Directive> directivesToWrap = null;
        while (iterator.hasNext()) {
            Directive directive = iterator.next();
            if (directivesToWrap == null && directive.usesInstanceThis()) {
                directivesToWrap = new ArrayList<Directive>();
            }
            if (directive instanceof SuperConstructorCallStatement) {
                if (directivesToWrap == null) {
                    directive.visit(this);
                    break;
                }
                if (!isExtClass) {
                    this.compilationUnit.getPrimaryDeclaration().getIde().getScope().getCompiler().getLog().warning((FilePosition)(directivesToWrap.isEmpty() ? directive : (Directive)directivesToWrap.get(0)).getSymbol(), "Constructor code of non-Ext class may not access 'this' before calling 'super()'. Either move code or make this class an Ext class by inheriting from ext.Base.");
                }
                this.visitSuperCallWithWrappedDirectives((SuperConstructorCallStatement)directive, directivesToWrap);
                break;
            }
            if (directivesToWrap == null) {
                directive.visit(this);
                continue;
            }
            directivesToWrap.add(directive);
        }
        while (iterator.hasNext()) {
            iterator.next().visit(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void visitSuperCallWithWrappedDirectives(SuperConstructorCallStatement superCall, List<Directive> directivesToWrap) throws IOException {
        boolean hasOneParameter;
        ArrayList<VariableDeclaration> pulledOutVariableDeclarations = new ArrayList<VariableDeclaration>();
        Iterator<Directive> iterator = directivesToWrap.iterator();
        while (iterator.hasNext()) {
            Directive directive = iterator.next();
            if (!(directive instanceof VariableDeclaration)) continue;
            VariableDeclaration variableDeclaration = (VariableDeclaration)directive;
            AstNode body = directive.getParentNode();
            if (!variableDeclaration.getUsages().stream().anyMatch(usage -> !directivesToWrap.contains(TypeScriptCodeGenerator.getParentDirective(usage, body)))) continue;
            pulledOutVariableDeclarations.add(variableDeclaration);
            this.visitDeclarationAnnotationsAndModifiers(variableDeclaration);
            this.writeSymbolReplacement(variableDeclaration.getOptSymConstOrVar(), "var");
            variableDeclaration.getIde().visit(this);
            variableDeclaration.getOptTypeRelation().visit(this);
            this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
            this.writeOptSymbol(variableDeclaration.getOptSymSemicolon());
            if (variableDeclaration.getOptInitializer() != null) continue;
            iterator.remove();
        }
        superCall.getFun().visit(this);
        ParenthesizedExpr<CommaSeparatedList<Expr>> args = superCall.getArgs();
        this.out.writeSymbol(args.getLParen());
        CommaSeparatedList<Expr> superCallParams = args.getExpr();
        boolean bl = hasOneParameter = superCallParams != null && superCallParams.getTail() == null;
        if (!hasOneParameter) {
            this.out.write("...");
        }
        this.out.write("(()");
        if (superCallParams != null && superCallParams.getTail() != null) {
            void var8_10;
            ArrayList<String> types = new ArrayList<String>();
            CommaSeparatedList<Expr> commaSeparatedList = superCallParams;
            while (var8_10 != null) {
                types.add("any");
                CommaSeparatedList commaSeparatedList2 = var8_10.getTail();
            }
            this.out.write(":[" + String.join((CharSequence)",", types) + "]");
        }
        this.out.write("=>");
        if (!directivesToWrap.isEmpty()) {
            this.out.write("{");
            for (AstNode astNode : directivesToWrap) {
                if (astNode instanceof VariableDeclaration && pulledOutVariableDeclarations.contains(astNode)) {
                    this.renderVariableDeclarationAsAssignment((VariableDeclaration)astNode);
                    continue;
                }
                astNode.visit(this);
            }
            this.out.write("\n    return ");
        }
        if (!hasOneParameter) {
            this.out.write("[");
        }
        this.visitIfNotNull(superCallParams);
        if (!hasOneParameter) {
            this.out.write("]");
        }
        if (!directivesToWrap.isEmpty()) {
            this.out.write(";}");
        }
        this.out.write(")()");
        this.out.writeSymbol(args.getRParen());
        this.writeOptSymbol(superCall.getSymSemicolon());
    }

    private static Directive getParentDirective(IdeExpr usage, AstNode container) {
        AstNode current;
        for (current = usage; current != null && !container.equals(current.getParentNode()); current = current.getParentNode()) {
        }
        return current instanceof Directive ? (Directive)current : null;
    }

    private void renderVariableDeclarationAsAssignment(VariableDeclaration variableDeclaration) throws IOException {
        this.out.write(variableDeclaration.getOptSymConstOrVar().getWhitespace());
        variableDeclaration.getIde().visit(this);
        variableDeclaration.getOptInitializer().visit(this);
        this.writeOptSymbol(variableDeclaration.getOptSymSemicolon());
    }

    private static boolean hasSetter(FunctionDeclaration getter) {
        TypedIdeDeclaration maybePropertyDeclaration = getter.getClassDeclaration().getMemberDeclaration(getter.getName());
        return maybePropertyDeclaration instanceof PropertyDeclaration && ((PropertyDeclaration)maybePropertyDeclaration).getSetter() != null;
    }

    @Override
    public void visitSuperConstructorCallStatement(SuperConstructorCallStatement superConstructorCallStatement) throws IOException {
        FunctionDeclaration functionDeclaration = TypeScriptCodeGenerator.findFunctionDeclaration(superConstructorCallStatement);
        if (functionDeclaration == null || functionDeclaration.getClassDeclaration().notExtendsObject()) {
            super.visitSuperConstructorCallStatement(superConstructorCallStatement);
            if (functionDeclaration != null && functionDeclaration.isThisAliased(true)) {
                ALIAS_THIS_CODE_GENERATOR.generate(this.out, false);
            }
        }
    }

    @Override
    public void visitFunctionExpr(FunctionExpr functionExpr) throws IOException {
        boolean needsParenthesis = false;
        if (functionExpr.rewriteToArrowFunction()) {
            this.out.writeSymbolWhitespace(functionExpr.getFunSymbol());
            needsParenthesis = functionExpr.getParentNode() instanceof BinaryOpExpr;
            if (needsParenthesis) {
                this.out.write("(");
            }
            this.out.suppressWhitespace(functionExpr.getLParen());
            this.generateFunctionExprSignature(functionExpr);
            this.out.write(" =>");
            List<Directive> statements = functionExpr.getBody().getDirectives();
            if (statements.size() == 1) {
                Expr returnExpr;
                ReturnStatement returnStatement = null;
                Directive firstStatement = statements.get(0);
                if (firstStatement instanceof ReturnStatement) {
                    returnStatement = (ReturnStatement)firstStatement;
                    returnExpr = returnStatement.getOptExpr();
                    if (returnExpr == null) {
                        returnExpr = new IdeExpr(new JooSymbol(99, "undefined"));
                    }
                } else {
                    returnExpr = this.getExpressionIfVoid(firstStatement);
                }
                if (returnExpr != null) {
                    this.out.writeSymbolWhitespace(functionExpr.getBody().getLBrace());
                    if (returnStatement != null) {
                        this.out.writeSymbolWhitespace(returnStatement.getSymKeyword());
                    }
                    this.visitExprWithParenthesisIfObjectLiteral(returnExpr);
                    this.out.writeSymbolWhitespace(functionExpr.getBody().getRBrace());
                    if (needsParenthesis) {
                        this.out.write(")");
                    }
                    return;
                }
            }
        } else {
            this.out.writeSymbol(functionExpr.getSymFunction());
            this.visitIfNotNull(functionExpr.getIde());
            this.generateFunctionExprSignature(functionExpr);
        }
        this.visitIfNotNull(functionExpr.getBody());
        if (needsParenthesis) {
            this.out.write(")");
        }
    }

    private void visitExprWithParenthesisIfObjectLiteral(Expr returnExpr) throws IOException {
        boolean needsInnerParenthesis = returnExpr instanceof ObjectLiteral;
        if (needsInnerParenthesis) {
            this.out.writeSymbolWhitespace(returnExpr.getSymbol());
            this.out.write("(");
        }
        returnExpr.visit(this);
        if (needsInnerParenthesis) {
            this.out.write(")");
        }
    }

    private Expr getExpressionIfVoid(Directive firstStatement) {
        Expr expr;
        AstNode statement;
        if (firstStatement.getClass().equals(SemicolonTerminatedStatement.class) && (statement = ((SemicolonTerminatedStatement)firstStatement).getOptStatement()) instanceof Expr && (expr = (Expr)statement).isOfAS3Type(AS3Type.VOID)) {
            return expr;
        }
        return null;
    }

    @Override
    public void visitApplyExpr(ApplyExpr applyExpr) throws IOException {
        ParenthesizedExpr<CommaSeparatedList<Expr>> args = applyExpr.getArgs();
        if (applyExpr.isTypeCheckObjectLiteralFunctionCall()) {
            ExpressionType typeParameter;
            CommaSeparatedList<Expr> typeAndObjectLiteral = args.getExpr();
            Expr typeExpr = typeAndObjectLiteral.getHead();
            Expr objectLiteral = typeAndObjectLiteral.getTail().getHead();
            if (!this.renderSingleSpreadValue(objectLiteral, typeParameter = typeExpr.getType().getTypeParameter())) {
                this.writeSymbolReplacement(applyExpr.getSymbol(), "Config");
                this.out.writeToken("<");
                this.out.write(this.getTypeScriptTypeForActionScriptType(typeParameter));
                this.out.writeToken(">");
                this.out.writeSymbol(args.getLParen());
                objectLiteral.visit(this);
                this.out.writeSymbol(args.getRParen());
            }
        } else if (applyExpr.isTypeCast()) {
            IdeDeclaration declaration = ((IdeExpr)applyExpr.getFun()).getIde().getDeclaration();
            if (declaration instanceof ClassDeclaration) {
                ClassDeclaration castToClass = (ClassDeclaration)declaration;
                Expr firstParameter = args.getExpr().getHead();
                boolean isExtConfig = castToClass.inheritsFromExtBaseExplicitly();
                if (!castToClass.hasConfigClass() && !isExtConfig && firstParameter instanceof ObjectLiteral) {
                    this.out.writeSymbolWhitespace(applyExpr.getFun().getSymbol());
                    this.out.write("Object.setPrototypeOf");
                    this.out.writeSymbol(args.getLParen());
                    firstParameter.visit(this);
                    this.out.writeToken(", ");
                    if (castToClass.isInterface()) {
                        this.out.writeToken("mixin(");
                        this.out.writeToken("class {}, ");
                        applyExpr.getFun().visit(this);
                        this.out.writeToken(")");
                    } else {
                        applyExpr.getFun().visit(this);
                    }
                    this.out.write(".prototype");
                    this.out.writeSymbol(args.getRParen());
                    return;
                }
                ExpressionType castToType = applyExpr.getFun().getType().getTypeParameter();
                if (castToType != null && castToType.isConfigType() || TypeScriptCodeGenerator.isOfConfigType(firstParameter) && castToClass.hasConfigClass()) {
                    this.writeSymbolReplacement(applyExpr.getSymbol(), "Config");
                    if (!isExtConfig) {
                        this.out.write("<" + this.compilationUnitAccessCode(declaration) + ">");
                        this.out.writeSymbolWhitespace(args.getLParen());
                    }
                    this.out.write("(");
                    boolean doRenderArg = true;
                    if (isExtConfig) {
                        this.out.write(this.compilationUnitAccessCode(declaration));
                        if (firstParameter instanceof ObjectLiteral && ((ObjectLiteral)firstParameter).getFields() == null) {
                            doRenderArg = false;
                        } else {
                            this.writeSymbolReplacement(args.getLParen(), ", ");
                        }
                    }
                    if (doRenderArg && !this.renderSingleSpreadValue(firstParameter, castToType)) {
                        firstParameter.visit(this);
                    }
                    this.out.writeSymbol(args.getRParen());
                    return;
                }
            }
            this.out.writeSymbolWhitespace(applyExpr.getFun().getSymbol());
            this.out.writeToken(this.builtInIdentifierCode("cast"));
            this.out.writeSymbol(args.getLParen());
            applyExpr.getFun().visit(this);
            this.out.writeToken(",");
            args.getExpr().visit(this);
            this.out.writeSymbol(args.getRParen());
        } else if (TypeScriptCodeGenerator.isIResourceManager_getString(applyExpr)) {
            Object jooValue;
            this.out.writeSymbolWhitespace(applyExpr.getSymbol());
            CommaSeparatedList<Expr> argExpressions = args.getExpr();
            ClassDeclaration propertiesClass = applyExpr.getPropertiesClass(argExpressions.getHead());
            this.out.write(this.compilationUnitAccessCode(propertiesClass));
            Expr propertyKey = argExpressions.getTail().getHead();
            String key = null;
            if (propertyKey instanceof LiteralExpr && (jooValue = propertyKey.getSymbol().getJooValue()) instanceof String && Ide.isValidIdentifier((String)jooValue)) {
                key = (String)jooValue;
            }
            if (key != null) {
                this.out.write("." + key);
            } else {
                this.out.writeToken("[");
                this.out.suppressWhitespace(propertyKey.getSymbol());
                propertyKey.visit(this);
                this.out.writeToken("]");
            }
        } else if (applyExpr.isFlexAddEventListener()) {
            DotExpr eventNameDotExpr;
            ExpressionType eventClass;
            Expr eventNameExpr = args.getExpr().getHead();
            if (eventNameExpr instanceof IdeExpr) {
                eventNameExpr = ((IdeExpr)eventNameExpr).getNormalizedExpr();
            }
            if (eventNameExpr instanceof DotExpr && (eventClass = (eventNameDotExpr = (DotExpr)eventNameExpr).getArg().getType().getTypeParameter()) != null) {
                VariableDeclaration eventNameDeclaration = (VariableDeclaration)eventClass.getDeclaration().getStaticMemberDeclaration(eventNameDotExpr.getIde().getName());
                String eventOnName = (String)((LiteralExpr)eventNameDeclaration.getOptInitializer().getValue()).getValue().getJooValue();
                String eventName = eventOnName.startsWith("on") ? eventOnName.substring(2).toLowerCase() : eventOnName;
                Expr fun = applyExpr.getFun();
                DotExpr funDotExpr = (DotExpr)(fun instanceof IdeExpr ? ((IdeExpr)fun).getNormalizedExpr() : fun);
                funDotExpr.getArg().visit(this);
                this.out.writeSymbol(funDotExpr.getOp());
                this.out.write("addListener");
                this.out.writeSymbol(args.getLParen());
                this.out.write(CompilerUtils.quote((String)eventName));
                this.out.writeSymbol(args.getExpr().getSymComma());
                args.getExpr().getTail().getHead().visit(this);
                this.out.writeSymbol(args.getRParen());
            }
        } else if (args != null && applyExpr.isExtApply()) {
            this.writeSymbolReplacement(applyExpr.getSymbol(), "Object.assign");
            this.out.writeSymbol(args.getLParen());
            CommaSeparatedList<Expr> extApplyArgs = args.getExpr();
            if (extApplyArgs != null) {
                extApplyArgs.getHead().visit(this);
                CommaSeparatedList<Expr> secondArgument = extApplyArgs.getTail();
                if (secondArgument != null) {
                    this.out.writeSymbol(extApplyArgs.getSymComma());
                    if (secondArgument.getTail() != null) {
                        secondArgument.getTail().getHead().visit(this);
                        this.out.writeSymbol(secondArgument.getSymComma());
                    }
                    secondArgument.getHead().visit(this);
                }
            }
            this.out.writeSymbol(args.getRParen());
        } else if (args != null && args.getExpr() != null && args.getExpr().getTail() == null && TypeScriptCodeGenerator.isApiCall(applyExpr, "net.jangaroo.ext.Exml", "asString", true) && args.getExpr().getHead().isOfAS3Type(AS3Type.STRING)) {
            args.getExpr().getHead().visit(this);
        } else if (args != null) {
            CommaSeparatedList<Expr> expr = args.getExpr();
            if (expr != null && expr.getTail() == null) {
                TypedIdeDeclaration accessor;
                DotExpr dotExpr;
                IdeDeclaration declaration;
                Expr fun = applyExpr.getFun();
                if (fun instanceof IdeExpr) {
                    fun = ((IdeExpr)fun).getNormalizedExpr();
                }
                if (fun instanceof DotExpr && (declaration = (dotExpr = (DotExpr)fun).getIde().getDeclaration(false)) instanceof FunctionDeclaration && this.compilationUnit.getPrimaryDeclaration().equals(declaration.getClassDeclaration()) && (accessor = TypeScriptCodeGenerator.getAccessorNameFromSetMethod((FunctionDeclaration)declaration)) != null) {
                    if (!this.isBindableWithoutAccessor(accessor)) {
                        dotExpr.getArg().visit(this);
                    } else {
                        this.out.writeSymbolWhitespace(applyExpr.getSymbol());
                        this.out.write("asConfig");
                        this.out.writeSymbol(args.getLParen());
                        dotExpr.getArg().visit(this);
                        this.out.writeSymbol(args.getRParen());
                    }
                    this.out.writeSymbol(dotExpr.getOp());
                    this.writeSymbolReplacement(dotExpr.getIde().getSymbol(), accessor.getName());
                    this.out.write(" = ");
                    expr.getHead().visit(this);
                    return;
                }
            }
            super.visitApplyExpr(applyExpr);
        }
    }

    @Override
    boolean renderSingleSpreadValue(Expr argument, ExpressionType parameterType) throws IOException {
        if (parameterType != null) {
            if (argument instanceof ObjectLiteral) {
                ObjectLiteral objectLiteral = (ObjectLiteral)argument;
                CommaSeparatedList<ObjectFieldOrSpread> fields = objectLiteral.getFields();
                if (fields != null && fields.getTail() == null && fields.getHead() instanceof Spread) {
                    this.writeOptSymbolWhitespace(objectLiteral.getSymbol());
                    parameterType.markAsConfigTypeIfPossible();
                    this.out.write("<" + this.getTypeScriptTypeForActionScriptType(parameterType) + ">");
                    ((Spread)fields.getHead()).getArg().visit(this);
                    return true;
                }
            } else if (argument instanceof ApplyExpr && ((ApplyExpr)argument).isTypeCast() && parameterType.isConfigType()) {
                if (parameterType.getDeclaration() instanceof ClassDeclaration && !((ClassDeclaration)parameterType.getDeclaration()).inheritsFromExtBaseExplicitly()) {
                    ((ApplyExpr)argument).getArgs().getExpr().getHead().visit(this);
                    return true;
                }
                if (argument.getType() != null) {
                    argument.getType().markAsConfigTypeIfPossible();
                }
            }
        }
        return false;
    }

    private static boolean isApiCall(ApplyExpr applyExpr, String qualifiedClassName, String methodName, boolean isStatic) {
        Expr fun = applyExpr.getFun();
        if (fun instanceof IdeExpr) {
            fun = ((IdeExpr)fun).getNormalizedExpr();
        }
        if (fun instanceof DotExpr && methodName.equals(((DotExpr)fun).getIde().getName())) {
            ExpressionType type = ((DotExpr)fun).getArg().getType();
            if (isStatic) {
                type = type.getTypeParameter();
            }
            return type != null && qualifiedClassName.equals(type.getDeclaration().getQualifiedNameStr());
        }
        return false;
    }

    private static boolean isIResourceManager_getString(ApplyExpr applyExpr) {
        if (TypeScriptCodeGenerator.isApiCall(applyExpr, I_RESOURCE_MANAGER_QUALIFIED_NAME, GET_STRING_METHOD_NAME, false)) {
            CommaSeparatedList<Expr> argsExpressions = applyExpr.getArgs().getExpr();
            return argsExpressions != null && argsExpressions.getTail() != null && argsExpressions.getTail().getTail() == null && applyExpr.getPropertiesClass(argsExpressions.getHead()) != null;
        }
        return false;
    }

    private static String getPackageNameFromReflectionCall(ApplyExpr applyExpr) {
        IdeDeclaration declaration;
        ParenthesizedExpr<CommaSeparatedList<Expr>> args = applyExpr.getArgs();
        if (args.getExpr() != null && args.getExpr().getHead() instanceof LiteralExpr && args.getExpr().getTail() == null && applyExpr.getFun() instanceof IdeExpr && (declaration = ((IdeExpr)applyExpr.getFun()).getIde().getDeclaration(false)) != null && "joo.getOrCreatePackage".equals(declaration.getQualifiedNameStr())) {
            return (String)((LiteralExpr)args.getExpr().getHead()).getValue().getJooValue();
        }
        return null;
    }

    private static boolean isOfConfigType(Expr expr) {
        if (expr instanceof ApplyExpr && ((ApplyExpr)expr).isTypeCheckObjectLiteralFunctionCall()) {
            expr = ((ApplyExpr)expr).getArgs().getExpr().getTail().getHead();
        }
        return expr instanceof ObjectLiteral || expr.getType() != null && expr.getType().isConfigType() || TypeScriptCodeGenerator.isExtApply(expr) && TypeScriptCodeGenerator.isAnyOfConfigType(((ApplyExpr)expr).getArgs().getExpr());
    }

    private static boolean isAnyOfConfigType(CommaSeparatedList<Expr> expr) {
        return expr != null && (TypeScriptCodeGenerator.isOfConfigType(expr.getHead()) || TypeScriptCodeGenerator.isAnyOfConfigType(expr.getTail()));
    }

    @Override
    void generateTypeAssertion(Expr argument, String type) throws IOException {
        argument.visit(this);
        this.out.write(" as " + type);
    }

    @Override
    protected void handleExmlAppendPrepend(ObjectField objectField, DotExpr exmlAppendOrPrepend) throws IOException {
        this.out.writeSymbolWhitespace(objectField.getSymbol());
        this.out.writeToken("...");
        String whitespace = exmlAppendOrPrepend.getSymbol().getWhitespace();
        this.out.suppressWhitespace(exmlAppendOrPrepend.getSymbol());
        exmlAppendOrPrepend.visit(this);
        ParenthesizedExpr<CommaSeparatedList<Expr>> args = ((ApplyExpr)objectField.getValue()).getArgs();
        this.out.writeTokenForSymbol("({", args.getLParen());
        objectField.getLabel().visit(this);
        this.out.writeSymbol(objectField.getSymColon());
        this.out.write(whitespace);
        args.getExpr().visit(this);
        this.out.writeTokenForSymbol("})", args.getRParen());
    }

    private static boolean isExtApply(Expr expr) {
        if (expr instanceof ApplyExpr) {
            DotExpr dotExpr;
            ApplyExpr applyExpr = (ApplyExpr)expr;
            Expr fun = applyExpr.getFun();
            if (fun instanceof IdeExpr) {
                fun = ((IdeExpr)fun).getNormalizedExpr();
            }
            if (fun instanceof DotExpr && "apply".equals((dotExpr = (DotExpr)fun).getIde().getName())) {
                String argFQN = TypeScriptCodeGenerator.getArgFQN(dotExpr);
                return "net.jangaroo.ext.Exml".equals(argFQN) || "ext.Ext".equals(argFQN);
            }
        }
        return false;
    }

    @Override
    public void visitForInStatement(ForInStatement forInStatement) throws IOException {
        VariableDeclaration decl = forInStatement.getDecl();
        ExpressionType exprType = forInStatement.getExpr().getType();
        this.out.writeSymbol(forInStatement.getSymKeyword());
        this.out.writeSymbol(forInStatement.getLParen());
        if (decl != null) {
            this.writeOptSymbol(decl.getOptSymConstOrVar());
            decl.getIde().visit(this);
        } else if (forInStatement.getLValue() != null) {
            forInStatement.getLValue().visit(this);
        }
        if (forInStatement.getSymEach() != null) {
            String tsType;
            Type declType;
            this.writeSymbolReplacement(forInStatement.getSymIn(), "of");
            Type type = declType = decl == null || decl.getOptTypeRelation() == null ? null : decl.getOptTypeRelation().getType();
            if (exprType != null && exprType.isArrayLike()) {
                forInStatement.getExpr().visit(this);
                if (declType != null && new ExpressionType(declType).equals(exprType.getTypeParameter())) {
                    declType = null;
                }
            } else {
                this.out.writeSymbolWhitespace(forInStatement.getExpr().getSymbol());
                this.out.write("Object.values");
                this.out.write("(");
                forInStatement.getExpr().visit(this);
                this.out.write(" || {})");
            }
            if (declType != null && !"any".equals(tsType = this.getTypeScriptTypeForActionScriptType(declType))) {
                this.out.write(" as " + tsType + "[]");
            }
        } else {
            this.out.writeSymbol(forInStatement.getSymIn());
            forInStatement.getExpr().visit(this);
        }
        this.out.writeSymbol(forInStatement.getRParen());
        forInStatement.getBody().visit(this);
    }

    @Override
    public final void visitLiteralExpr(LiteralExpr literalExpr) throws IOException {
        JooSymbol value = literalExpr.getValue();
        if (value.getJooValue() instanceof String) {
            String string = (String)value.getJooValue();
            if (value.getText().charAt(0) == '\'' && !string.contains("\"")) {
                this.writeSymbolReplacement(literalExpr.getSymbol(), CompilerUtils.quote((String)string, (boolean)false));
                return;
            }
        }
        super.visitLiteralExpr(literalExpr);
    }

    @Override
    public void visitDotExpr(DotExpr dotExpr) throws IOException {
        Ide ide = dotExpr.getIde();
        if (ide.isBound()) {
            this.out.writeToken("bind(");
            dotExpr.getArg().visit(this);
            this.writeSymbolReplacement(dotExpr.getOp(), ",");
            this.internalVisitDotExpr(dotExpr);
            this.out.writeToken(")");
        } else {
            String packageNameFromReflectionCall;
            this.internalVisitDotExpr(dotExpr);
            if (dotExpr.getArg() instanceof ApplyExpr && (packageNameFromReflectionCall = TypeScriptCodeGenerator.getPackageNameFromReflectionCall((ApplyExpr)dotExpr.getArg())) != null) {
                VariableDeclaration targetPrimaryDeclaration;
                String localName = dotExpr.getIde().getName();
                String qName = CompilerUtils.qName((String)packageNameFromReflectionCall, (String)localName);
                CompilationUnit targetCompilationUnit = ide.getScope().getCompiler().getCompilationUnit(qName);
                if (targetCompilationUnit == null) {
                    Object renamedQName;
                    Annotation renameAnnotation;
                    String guessedRenamedQName = CompilerUtils.qName((String)packageNameFromReflectionCall, (String)localName.toUpperCase());
                    CompilationUnit renamedTargetCompilationUnit = ide.getScope().getCompiler().getCompilationUnit(guessedRenamedQName);
                    if (renamedTargetCompilationUnit != null && (renameAnnotation = renamedTargetCompilationUnit.getPrimaryDeclaration().getAnnotation("Rename")) != null && qName.equals(renamedQName = renameAnnotation.getPropertiesByName().get(null))) {
                        targetCompilationUnit = renamedTargetCompilationUnit;
                    }
                }
                if (targetCompilationUnit != null && targetCompilationUnit.getPrimaryDeclaration() instanceof VariableDeclaration && (!(targetPrimaryDeclaration = (VariableDeclaration)targetCompilationUnit.getPrimaryDeclaration()).isConst() || targetPrimaryDeclaration.getAnnotation("Lazy") != null)) {
                    this.out.write("._");
                }
            }
        }
    }

    @Override
    public void visitParameters(Parameters parameters) throws IOException {
        TypeDeclaration declaration;
        if (((Parameter)parameters.getHead()).getOptTypeRelation() != null && parameters.getTail() == null && (declaration = ((Parameter)parameters.getHead()).getOptTypeRelation().getType().getDeclaration(false)) instanceof ClassDeclaration && ((ClassDeclaration)declaration).inheritsFromFlExtEvent()) {
            return;
        }
        super.visitParameters(parameters);
    }

    private void internalVisitDotExpr(DotExpr dotExpr) throws IOException {
        Expr arg = dotExpr.getArg();
        ExpressionType type = arg.getType();
        if (type != null) {
            Ide ide = dotExpr.getIde();
            IdeDeclaration memberDeclaration = type.resolvePropertyDeclaration(ide.getName());
            if (memberDeclaration == null) {
                if (type.getAS3Type() != AS3Type.ANY && !type.isObject()) {
                    arg.visit(this);
                    this.writeSymbolReplacement(dotExpr.getOp(), "[");
                    this.writeSymbolReplacement(ide.getSymbol(), '\"' + ide.getName() + '\"');
                    this.out.write("]");
                    return;
                }
            } else {
                TypedIdeDeclaration accessor;
                IdeDeclaration bindableConfigDeclarationCandidate;
                Object nativeMemberName;
                if ("INSTANCE".equals(ide.getName()) && type.getAS3Type() == AS3Type.CLASS && type.getTypeParameter() != null && TypeScriptCodeGenerator.isPropertiesClass(type.getTypeParameter().getDeclaration())) {
                    arg.visit(this);
                    this.out.writeSymbolWhitespace(dotExpr.getOp());
                    this.out.writeSymbolWhitespace(dotExpr.getIde().getIde());
                    return;
                }
                Annotation nativeAnnotation = memberDeclaration.getAnnotation("Native");
                String memberName = ide.getName();
                if (nativeAnnotation != null && (nativeMemberName = nativeAnnotation.getPropertiesByName().get(null)) instanceof String) {
                    memberName = (String)nativeMemberName;
                }
                if ((bindableConfigDeclarationCandidate = this.getBindableConfigDeclarationCandidate(type, ide)) != null && (accessor = this.findMemberWithBindableAnnotation(ide, ide.isAssignmentLHS() ? MethodType.SET : MethodType.GET, bindableConfigDeclarationCandidate.getClassDeclaration())) != null) {
                    this.out.writeSymbolWhitespace(arg.getSymbol());
                    this.out.write("asConfig(");
                    arg.visit(this);
                    this.out.write(")");
                    this.out.writeSymbol(dotExpr.getOp());
                    ide.visit(this);
                    return;
                }
                if (!memberName.equals(ide.getName()) || memberDeclaration.isPrivate()) {
                    arg.visit(this);
                    if (memberDeclaration.isPrivate()) {
                        this.out.writeSymbol(dotExpr.getOp());
                        this.writeSymbolReplacement(ide.getSymbol(), "#" + memberName);
                    } else {
                        this.out.writeSymbol(dotExpr.getOp());
                        this.writeSymbolReplacement(ide.getSymbol(), memberName);
                    }
                    return;
                }
            }
        }
        super.visitDotExpr(dotExpr);
    }

    private IdeDeclaration getBindableConfigDeclarationCandidate(ExpressionType type, Ide ide) {
        IdeDeclaration memberDeclaration;
        if (type != null && !type.isConfigType() && ((memberDeclaration = type.getDeclaration().resolvePropertyDeclaration(ide.getName(), false)) instanceof VariableDeclaration || memberDeclaration instanceof PropertyDeclaration || memberDeclaration instanceof FunctionDeclaration && ((FunctionDeclaration)memberDeclaration).isGetterOrSetter()) && !memberDeclaration.isPrivate() && !memberDeclaration.isProtected()) {
            return memberDeclaration;
        }
        return null;
    }

    @Override
    public void visitArrayIndexExpr(ArrayIndexExpr arrayIndexExpr) throws IOException {
        IdeDeclaration memberDeclaration;
        LiteralExpr innerIndexLiteralExpr;
        Object stringValue;
        Expr innerIndexExpr;
        Expr indexedExpr = arrayIndexExpr.getArray();
        ExpressionType type = indexedExpr.getType();
        ParenthesizedExpr<Expr> indexExpr = arrayIndexExpr.getIndexExpr();
        if (type != null && !AS3Type.ANY.equals((Object)type.getAS3Type()) && (innerIndexExpr = indexExpr.getExpr()) instanceof LiteralExpr && (stringValue = (innerIndexLiteralExpr = (LiteralExpr)innerIndexExpr).getValue().getJooValue()) instanceof String && (memberDeclaration = type.resolvePropertyDeclaration((String)stringValue)) != null) {
            if (this.compilationUnit.getPrimaryDeclaration().equals(memberDeclaration.getClassDeclaration()) && memberDeclaration instanceof TypedIdeDeclaration && ((TypedIdeDeclaration)memberDeclaration).isBindable() && (!(memberDeclaration instanceof PropertyDeclaration) || memberDeclaration.isNative())) {
                indexedExpr.visit(this);
                this.writeSymbolReplacement(indexExpr.getLParen(), ".");
                this.writeSymbolReplacement(innerIndexExpr.getSymbol(), type.isConfigType() ? memberDeclaration.getName() : this.getHashPrivateName(memberDeclaration));
            } else {
                this.out.writeSymbolWhitespace(indexedExpr.getSymbol());
                this.out.write("(");
                indexedExpr.visit(this);
                this.out.write(" as unknown)");
                indexExpr.visit(this);
            }
            return;
        }
        ExpressionType indexExprType = indexExpr.getType();
        if (indexExprType != null && !TYPES_ALLOWED_AS_INDEX.contains(indexExprType.getAS3Type())) {
            indexedExpr.visit(this);
            this.out.writeSymbol(indexExpr.getLParen());
            this.out.write("String(");
            indexExpr.getExpr().visit(this);
            this.out.write(")");
            this.out.writeSymbol(indexExpr.getRParen());
        } else {
            super.visitArrayIndexExpr(arrayIndexExpr);
        }
    }

    @Override
    public void visitIdeWithTypeParam(IdeWithTypeParam ideWithTypeParam) throws IOException {
        this.writeSymbolReplacement(ideWithTypeParam.getIde(), "Array");
    }

    @Override
    public void visitQualifiedIde(QualifiedIde qualifiedIde) throws IOException {
        if (this.out.isWritingComment()) {
            super.visitQualifiedIde(qualifiedIde);
        } else {
            this.out.writeSymbolWhitespace(qualifiedIde.getQualifier().getSymbol());
            this.writeSymbolReplacement(qualifiedIde.getSymbol(), this.getLocalName(qualifiedIde, true));
        }
    }

    @Override
    public void visitIde(Ide ide) throws IOException {
        if (this.out.isWritingComment() || ide.getParentNode() == null || ide.getParentNode() instanceof DotExpr) {
            super.visitIde(ide);
        } else {
            this.writeSymbolReplacement(ide.getIde(), this.getLocalName(ide, false));
        }
    }

    private String getLocalName(Ide ide, boolean useQualifiedName) {
        IdeDeclaration declaration;
        if (TypeScriptCodeGenerator.rewriteThis(ide)) {
            return "this$";
        }
        if (ide.getScope() != null && (declaration = ide.getDeclaration(false)) != null) {
            return this.getLocalName(declaration, useQualifiedName);
        }
        return useQualifiedName ? TypeScriptModuleResolver.toLocalName(ide.getQualifiedName()) : ide.getName();
    }

    @Override
    String compilationUnitAccessCode(IdeDeclaration declaration) {
        return this.getLocalName(declaration, false);
    }

    private String getLocalName(IdeDeclaration declaration, boolean useQualifiedName) {
        String localName = null;
        if (declaration.isPrimaryDeclaration()) {
            localName = this.imports.get((declaration = CompilationUnit.mapMixinInterface(declaration.getCompilationUnit()).getPrimaryDeclaration()).getQualifiedNameStr());
            if (localName == null) {
                System.err.println("*** not found in imports: " + declaration.getQualifiedNameStr());
            } else if (declaration instanceof VariableDeclaration && this.isPrimaryVariableDeclaration((VariableDeclaration)declaration)) {
                localName = localName + "._";
            }
        } else if (declaration instanceof Parameter && !declaration.getIde().getSymbol().isVirtual() && "arguments".equals(declaration.getName())) {
            localName = "arguments$";
        }
        if (localName == null) {
            return useQualifiedName ? TypeScriptModuleResolver.toLocalName(declaration.getQualifiedName()) : declaration.getName();
        }
        return localName;
    }

    private String configType(ClassDeclaration targetClass) {
        return this.configType(this.compilationUnitAccessCode(targetClass));
    }

    private String configType(String targetClass) {
        this.compilationUnit.addBuiltInIdentifierUsage("Config");
        return String.format("Config<%s>", targetClass);
    }

    private static boolean rewriteThis(Ide ide) {
        if (ide.isThis() && ide.isRewriteThis()) {
            Scope scope = ide.getScope();
            FunctionExpr functionExpr = scope.getFunctionExpr();
            while (!(functionExpr == null || functionExpr.getFunctionDeclaration() != null && functionExpr.getFunctionDeclaration().isClassMember())) {
                if (!functionExpr.rewriteToArrowFunction()) {
                    return true;
                }
                scope = scope.getParentScope();
                functionExpr = scope.getFunctionExpr();
            }
        }
        return false;
    }

    @Override
    public void visitClassBodyDirectives(List<Directive> classBodyDirectives) throws IOException {
        IdeDeclaration primaryDeclaration = this.compilationUnit.getPrimaryDeclaration();
        if (primaryDeclaration instanceof ClassDeclaration) {
            ClassDeclaration configClassDeclaration;
            TypedIdeDeclaration initialConfigDeclaration;
            ClassDeclaration classDeclaration = (ClassDeclaration)primaryDeclaration;
            this.generateRestResourceUriTemplateConstant(primaryDeclaration.getAnnotation(REST_RESOURCE_ANNOTATION_NAME));
            if (this.compilationUnit instanceof MxmlCompilationUnit) {
                for (Directive directive : classBodyDirectives) {
                    this.setIndentationToTwo(directive.getSymbol());
                    if (!(directive instanceof Declaration)) continue;
                    for (Annotation annotation : ((Declaration)directive).getAnnotations()) {
                        this.setIndentationToTwo(annotation.getSymbol());
                    }
                }
            }
            if (!this.companionInterfaceMode && ((initialConfigDeclaration = classDeclaration.getMemberDeclaration("initialConfig")) == null || initialConfigDeclaration.isPrivate()) && (configClassDeclaration = classDeclaration.getConfigClassDeclaration()) != null) {
                if (!(classDeclaration.equals(configClassDeclaration) || classDeclaration.equals(((TypeDeclaration)configClassDeclaration).getSuperTypeDeclaration()) || configClassDeclaration.equals(classDeclaration.getSuperTypeDeclaration()))) {
                    TypeRelation configParameterType = classDeclaration.getConstructorConfigParameterType();
                    classDeclaration.getIde().getScope().getCompiler().getLog().warning((FilePosition)configParameterType.getSymbol(), String.format("Class extends ext.Base, has 'config' constructor parameter, but its type '%s' is not a valid Config type for this class. Still generating a TypeScript Config class, but please fix this.", configParameterType.getType().getIde().getQualifiedNameStr()));
                }
                if (this.hasOwnConfigClass) {
                    this.out.write(String.format("\n  declare Config: %sConfig;", this.compilationUnitAccessCode(classDeclaration)));
                }
            }
        }
        super.visitClassBodyDirectives(classBodyDirectives);
    }

    private void generateRestResourceUriTemplateConstant(Annotation restResourceAnnotation) throws IOException {
        AnnotationParameter annotationParameter;
        CommaSeparatedList<AnnotationParameter> annotationParameters;
        if (restResourceAnnotation != null && (annotationParameters = restResourceAnnotation.getOptAnnotationParameters()) != null && (annotationParameter = annotationParameters.getHead()).getOptName() != null && REST_RESOURCE_URI_TEMPLATE_PARAMETER_NAME.equals(annotationParameter.getOptName().getName())) {
            this.out.write(String.format("\n  static readonly REST_RESOURCE_URI_TEMPLATE = %s;", annotationParameter.getValue().getSymbol().getText()));
        }
    }

    private void setIndentationToTwo(JooSymbol symbol) {
        String whitespace = symbol.getWhitespace();
        Matcher indentationMatcher = ENDS_WITH_4_SPACES_INDENTATION.matcher(whitespace);
        if (indentationMatcher.matches()) {
            symbol.setWhitespace(indentationMatcher.group(1) + "\n  ");
        }
    }

    @Override
    void generateStaticInitializer(List<Directive> directives) throws IOException {
        if (directives.isEmpty() || this.companionInterfaceMode) {
            return;
        }
        Directive firstDirective = directives.get(0);
        this.out.writeSymbolWhitespace(firstDirective.getSymbol());
        String uniqueName = "";
        if (this.staticCodeCounter > 0) {
            uniqueName = String.valueOf(this.staticCodeCounter);
        }
        ++this.staticCodeCounter;
        this.out.writeToken(String.format("static #static%s = (() =>", uniqueName));
        if (directives.size() == 1 && firstDirective instanceof BlockStatement) {
            firstDirective.visit(this);
        } else {
            this.out.writeToken(" {\n    ");
            for (Directive directive : directives) {
                directive.visit(this);
            }
            this.out.writeToken("\n  }");
        }
        this.out.writeToken(")();");
    }

    @Override
    protected String builtInIdentifierCode(String builtInIdentifier) {
        assert (this.compilationUnit.getUsedBuiltInIdentifiers().contains(builtInIdentifier)) : "Usage of built-in identifier '" + builtInIdentifier + "' has not been analyzed.";
        return builtInIdentifier;
    }
}

