/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.jooc.mxml.ast.XmlAttribute;
import net.jangaroo.jooc.mxml.ast.XmlElement;
import org.apache.commons.lang3.StringUtils;

class RootElementProcessor {
    private static final String IMPLEMENTS = "implements";
    private final List<XmlElement> declarations = new LinkedList<XmlElement>();
    private final List<JooSymbol> imports = new LinkedList<JooSymbol>();
    private final List<JooSymbol> metadata = new LinkedList<JooSymbol>();
    private final List<JooSymbol> scripts = new LinkedList<JooSymbol>();
    private JooSymbol impl = null;

    RootElementProcessor() {
    }

    void process(XmlElement rootNode) {
        this.processAttributes(rootNode);
        this.processElements(rootNode);
    }

    private void processElements(XmlElement rootNode) {
        Iterator<XmlElement> it = rootNode.getElements().iterator();
        while (it.hasNext()) {
            XmlElement element = it.next();
            if (!MxmlUtils.isMxmlNamespace(element.getNamespaceURI())) continue;
            it.remove();
            String name = element.getName();
            if ("Declarations".equals(name)) {
                this.declarations.addAll(element.getElements());
                continue;
            }
            if ("Metadata".equals(name)) {
                this.addAll(element.getTextNodes(), this.metadata);
                continue;
            }
            if ("Script".equals(name)) {
                this.addAll(element.getTextNodes(), this.scripts);
                continue;
            }
            throw new CompilerError(element.getSymbol(), "unsupported element");
        }
    }

    private void processAttributes(XmlElement rootNode) {
        List<XmlAttribute> rootNodeAttributes = rootNode.getAttributes();
        for (XmlAttribute xmlAttribute : rootNodeAttributes) {
            if (xmlAttribute.isNamespaceDefinition()) {
                this.imports.add(xmlAttribute.getValue());
                continue;
            }
            if (!RootElementProcessor.isImplements(xmlAttribute)) continue;
            this.impl = xmlAttribute.getValue();
        }
    }

    private static boolean isImplements(XmlAttribute xmlAttribute) {
        return IMPLEMENTS.equals(xmlAttribute.getLocalName()) && StringUtils.isBlank((CharSequence)xmlAttribute.getPrefix());
    }

    private void addAll(List<JooSymbol> textNodes, List<JooSymbol> target) {
        target.addAll(Collections2.filter(textNodes, (Predicate)new Predicate<JooSymbol>(){

            public boolean apply(@Nullable JooSymbol symbol) {
                return null != symbol && StringUtils.isNotBlank((CharSequence)symbol.getText());
            }
        }));
    }

    List<XmlElement> getDeclarations() {
        return this.declarations;
    }

    List<JooSymbol> getImports() {
        return this.imports;
    }

    List<JooSymbol> getMetadata() {
        return this.metadata;
    }

    List<JooSymbol> getScripts() {
        return this.scripts;
    }

    @Nullable
    JooSymbol getImpl() {
        return this.impl;
    }

    static boolean alreadyProcessed(XmlAttribute attribute) {
        return attribute.isNamespaceDefinition() || RootElementProcessor.isImplements(attribute);
    }
}

