/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.NamespacedIde;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.mxml.ast.XmlAttribute;
import net.jangaroo.jooc.mxml.ast.XmlElement;

public class XmlTag
extends NodeImplBase {
    static final String XMLNS = "xmlns";
    private final Map<String, String> xmlNamespaces = new HashMap<String, String>();
    private final String defaultXmlNamespace;
    private final JooSymbol lt;
    private final Ide tagName;
    private final List<XmlAttribute> attributes;
    private final JooSymbol gt;
    private XmlElement xmlElement;

    public XmlTag(JooSymbol lt, Ide tagName, List<XmlAttribute> attributes, JooSymbol gt) {
        this.lt = lt;
        this.tagName = tagName;
        this.attributes = attributes;
        this.gt = gt;
        String defaultNamespace = null;
        if (null != attributes) {
            for (XmlAttribute attribute : attributes) {
                String localName = attribute.getLocalName();
                String namespace = attribute.getPrefix();
                String text = (String)attribute.getValue().getJooValue();
                if (XMLNS.equals(namespace)) {
                    this.xmlNamespaces.put(localName, text);
                    continue;
                }
                if (null != namespace || !XMLNS.equals(localName)) continue;
                defaultNamespace = text;
            }
        }
        this.defaultXmlNamespace = defaultNamespace;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getSymLt();
    }

    public JooSymbol getSymLt() {
        return this.lt;
    }

    public JooSymbol getSymGt() {
        return this.gt;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void scope(Scope scope) {
    }

    @Override
    public void analyze(AstNode parentNode) {
    }

    @Override
    public AstNode getParentNode() {
        return null;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.lt.getSourceCode());
        if (this.tagName instanceof NamespacedIde) {
            NamespacedIde namespacedIde = (NamespacedIde)this.tagName;
            builder.append(namespacedIde.getNamespace().getSymbol().getSourceCode());
            builder.append(namespacedIde.getSymNamespaceSep().getSourceCode());
        }
        builder.append(this.tagName.getIde().getSourceCode());
        if (this.attributes != null) {
            for (XmlAttribute attribute : this.attributes) {
                builder.append(attribute);
            }
        }
        builder.append(this.gt.getSourceCode());
        return builder.toString();
    }

    public String getLocalName() {
        return this.tagName.getIde().getText();
    }

    public String getPrefix() {
        if (this.tagName instanceof NamespacedIde) {
            return ((NamespacedIde)this.tagName).getNamespace().getName();
        }
        return null;
    }

    XmlAttribute getAttribute(final String name) {
        return (XmlAttribute)Iterables.getFirst((Iterable)Iterables.filter(this.attributes, (Predicate)new Predicate<XmlAttribute>(){

            public boolean apply(@Nullable XmlAttribute input) {
                return null != input && Objects.equals(name, input.getSymbol().getText());
            }
        }), null);
    }

    XmlAttribute getAttribute(final String namespaceUri, final String localName) {
        return (XmlAttribute)Iterables.getFirst((Iterable)Iterables.filter(this.attributes, (Predicate)new Predicate<XmlAttribute>(){

            public boolean apply(@Nullable XmlAttribute input) {
                return null != input && Objects.equals(namespaceUri, XmlTag.this.xmlElement.getNamespaceUri(input.getPrefix())) && Objects.equals(localName, input.getLocalName());
            }
        }), null);
    }

    public List<XmlAttribute> getAttributes() {
        return this.attributes;
    }

    String getNamespaceUri(@Nullable String prefix) {
        if (null != prefix) {
            return this.xmlNamespaces.get(prefix);
        }
        return this.defaultXmlNamespace;
    }

    void setElement(XmlElement xmlElement) {
        this.xmlElement = xmlElement;
    }
}

