/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NodeImplBase;

public class AnnotationParameter
extends NodeImplBase {
    private Ide optName;
    private JooSymbol optSymEq;
    private AstNode value;
    private Annotation parentAnnotation;

    public AnnotationParameter(Ide optName, JooSymbol optSymEq, AstNode value) {
        this.optName = optName;
        this.optSymEq = optSymEq;
        this.value = value;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.optName, this.value);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitAnnotationParameter(this);
    }

    public Annotation getParentAnnotation() {
        return this.parentAnnotation;
    }

    public void setParentAnnotation(Annotation parentAnnotation) {
        this.parentAnnotation = parentAnnotation;
    }

    @Override
    public void scope(Scope scope) {
        if (this.getValue() != null) {
            this.getValue().scope(scope);
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        AstNode value = this.getValue();
        if (value != null) {
            value.analyze(this);
            if (value instanceof Ide) {
                ((Ide)value).analyzeAsExpr(this, null);
            }
            JooSymbol valueSymbol = value.getSymbol();
            String metaName = this.parentAnnotation.getMetaName();
            if ("Embed".equals(metaName) && this.getOptName() != null && "source".equals(this.getOptName().getName())) {
                if (valueSymbol.sym != 98) {
                    throw new CompilerError(valueSymbol, "The source parameter of an [Embed] annotation must be a string literal");
                }
            } else if ("ResourceBundle".equals(metaName) && this.getOptName() == null) {
                if (valueSymbol.sym != 98) {
                    throw new CompilerError(valueSymbol, "The parameter of a [ResourceBundle] annotation must be a string literal");
                }
                Scope scope = this.parentAnnotation.getIde().getScope();
                String resourceBundleName = (String)valueSymbol.getJooValue();
                CompilationUnit resourceBundleCompilationUnit = scope.getCompiler().getCompilationUnit(resourceBundleName + "_properties");
                if (resourceBundleCompilationUnit == null) {
                    throw new CompilerError(valueSymbol, "unable to resolve resource bundle " + resourceBundleName);
                }
                scope.getCompilationUnit().addDependency(resourceBundleCompilationUnit, true);
            } else if ("ArrayElementType".equals(metaName) && this.getOptName() == null) {
                if (valueSymbol.sym != 98) {
                    throw new CompilerError(valueSymbol, "An [ArrayElementType] annotation must specify the element type as its only parameter.");
                }
                Scope scope = this.parentAnnotation.getIde().getScope();
                String arrayElementType = (String)valueSymbol.getJooValue();
                CompilationUnit arrayElementTypeCompilationUnit = scope.getCompiler().getCompilationUnit(arrayElementType);
                if (arrayElementTypeCompilationUnit == null) {
                    throw new CompilerError(valueSymbol, "Unable to resolve array element type " + arrayElementType);
                }
                scope.getCompilationUnit().addDependency(arrayElementTypeCompilationUnit, false);
            }
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getOptName() == null ? this.getValue().getSymbol() : this.getOptName().getSymbol();
    }

    public Ide getOptName() {
        return this.optName;
    }

    public JooSymbol getOptSymEq() {
        return this.optSymEq;
    }

    public AstNode getValue() {
        return this.value;
    }

    public void setValue(LiteralExpr value) {
        this.value = value;
    }
}

