/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.mxml.ast;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationsAndModifiers;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.ArrayLiteral;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectFieldOrSpread;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.Spread;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.utils.CompilerUtils;

class MxmlAstUtils {
    static final String INDENT_4 = "\n    ";

    static JooSymbol sym_class() {
        return new JooSymbol(6, "class");
    }

    static JooSymbol sym_colon() {
        return new JooSymbol(70, ":");
    }

    static JooSymbol sym_comma() {
        return new JooSymbol(72, ",");
    }

    static JooSymbol sym_dot() {
        return new JooSymbol(73, ".");
    }

    static JooSymbol sym_eq() {
        return new JooSymbol(58, "=");
    }

    static JooSymbol sym_function() {
        return new JooSymbol(16, "function");
    }

    static JooSymbol sym_import() {
        return new JooSymbol(19, "import");
    }

    static JooSymbol sym_lbrace() {
        return new JooSymbol(90, "{");
    }

    static JooSymbol sym_lbrack() {
        return new JooSymbol(92, "[");
    }

    static JooSymbol sym_lparen() {
        return new JooSymbol(88, "(");
    }

    static JooSymbol sym_null() {
        return new JooSymbol(100, "null");
    }

    static JooSymbol sym_public() {
        return new JooSymbol(29, "public");
    }

    static JooSymbol sym_rbrace() {
        return new JooSymbol(91, "}");
    }

    static JooSymbol sym_rbrack() {
        return new JooSymbol(93, "]");
    }

    static JooSymbol sym_rparen() {
        return new JooSymbol(89, ")");
    }

    static JooSymbol sym_semicolon() {
        return new JooSymbol(71, ";");
    }

    static JooSymbol sym_super() {
        return new JooSymbol(31, "super");
    }

    static JooSymbol sym_this() {
        return new JooSymbol(33, "this");
    }

    static JooSymbol sym_var() {
        return new JooSymbol(38, "var");
    }

    static JooSymbol sym_new() {
        return new JooSymbol(25, "new");
    }

    private MxmlAstUtils() {
    }

    @Nonnull
    static FunctionDeclaration createConstructor(@Nonnull FunctionDeclaration directive, @Nonnull List<Directive> constructorBodyDirectives) {
        BlockStatement constructorBody = new BlockStatement(MxmlAstUtils.sym_lbrace(), constructorBodyDirectives, MxmlAstUtils.sym_rbrace().withWhitespace("\n  "));
        String whitespace = "";
        JooSymbol firstSymbol = (JooSymbol)((Object)Iterables.getFirst(Arrays.asList(directive.getSymModifiers()), null));
        if (null != firstSymbol) {
            whitespace = firstSymbol.getWhitespace();
        }
        return new FunctionDeclaration(new AnnotationsAndModifiers(null, Collections.singletonList(MxmlAstUtils.sym_public().withWhitespace(whitespace))), MxmlAstUtils.sym_function(), directive.getSymGetOrSet(), directive.getIde(), directive.getFun().getLParen(), directive.getParams(), directive.getFun().getRParen(), null, constructorBody, null);
    }

    @Nonnull
    static FunctionDeclaration createConstructor(@Nonnull Ide ide, @Nonnull List<Directive> constructorBodyDirectives) {
        BlockStatement constructorBody = new BlockStatement(MxmlAstUtils.sym_lbrace(), constructorBodyDirectives, MxmlAstUtils.sym_rbrace().withWhitespace("\n"));
        TypeRelation typeRelation = new TypeRelation(MxmlAstUtils.sym_colon(), new Type(ide));
        Parameters params = new Parameters(new Parameter(null, new Ide("config"), typeRelation, new Initializer(MxmlAstUtils.sym_eq(), new LiteralExpr(MxmlAstUtils.sym_null()))));
        return new FunctionDeclaration(new AnnotationsAndModifiers(null, Collections.singletonList(MxmlAstUtils.sym_public())), MxmlAstUtils.sym_function(), null, ide, MxmlAstUtils.sym_lparen(), params, MxmlAstUtils.sym_rparen(), null, constructorBody, null);
    }

    @Nonnull
    static ImportDirective createImport(@Nonnull Ide superClass) {
        return new ImportDirective(MxmlAstUtils.sym_import().withWhitespace("\n"), superClass, MxmlAstUtils.sym_semicolon());
    }

    @Nonnull
    static ClassDeclaration createClassDeclaration(@Nonnull String classQName, @Nonnull JooSymbol rootNodeSymbol, @Nonnull Extends ext, @Nullable Implements impl, @Nonnull List<Directive> classBodyDirectives, @Nonnull InputSource source) {
        ClassBody classBody = new ClassBody(MxmlAstUtils.sym_lbrace(), classBodyDirectives, MxmlAstUtils.sym_rbrace());
        String whitespace = MxmlUtils.toASDoc(rootNodeSymbol.getWhitespace());
        return new ClassDeclaration(new AnnotationsAndModifiers(new LinkedList<Annotation>(), Collections.singletonList(MxmlAstUtils.sym_public().withWhitespace(whitespace))), MxmlAstUtils.sym_class(), new Ide(CompilerUtils.className((String)classQName)), ext, impl, classBody);
    }

    @Nonnull
    static ApplyExpr createCastExpr(@Nonnull Ide type, Expr expr) {
        IdeExpr fun = new IdeExpr(type);
        return MxmlAstUtils.createApplyExpr(fun, expr);
    }

    @Nonnull
    static ApplyExpr createApplyExpr(Expr fun, Expr ... args) {
        return new ApplyExpr(fun, MxmlAstUtils.sym_lparen(), MxmlAstUtils.createCommaSeparatedList((AstNode[])args), MxmlAstUtils.sym_rparen());
    }

    @Nonnull
    static DotExpr createDotExpr(Ide object, String property) {
        return MxmlAstUtils.createDotExpr(new IdeExpr(object), new Ide(property));
    }

    @Nonnull
    static DotExpr createDotExpr(Expr object, Ide property) {
        return new DotExpr(object, MxmlAstUtils.sym_dot(), property);
    }

    @Nonnull
    static ArrayIndexExpr createArrayIndexExpr(Expr expr, String index) {
        return new ArrayIndexExpr(expr, MxmlAstUtils.sym_lbrack(), MxmlAstUtils.createStringLiteral(index), MxmlAstUtils.sym_rbrack());
    }

    @Nonnull
    static LiteralExpr createStringLiteral(String value) {
        return MxmlAstUtils.createStringLiteral(value, "");
    }

    @Nonnull
    static LiteralExpr createStringLiteral(String value, String whiteSpace) {
        return new LiteralExpr(new JooSymbol(98, null, -1, -1, whiteSpace, CompilerUtils.quote((String)value), value));
    }

    @Nonnull
    static VariableDeclaration createVariableDeclaration(@Nonnull Ide name, @Nonnull Ide type, @Nullable Expr initializerExpr) {
        Initializer initializer = initializerExpr == null ? null : new Initializer(MxmlAstUtils.sym_eq(), initializerExpr);
        return new VariableDeclaration(new AnnotationsAndModifiers(null, null), MxmlAstUtils.sym_var().withWhitespace(INDENT_4), name, new TypeRelation(MxmlAstUtils.sym_colon(), new Type(type)), initializer, null, MxmlAstUtils.sym_semicolon());
    }

    @Nonnull
    static SemicolonTerminatedStatement createSemicolonTerminatedStatement(@Nonnull AstNode astNode) {
        return new SemicolonTerminatedStatement(astNode, MxmlAstUtils.sym_semicolon());
    }

    @Nonnull
    static SuperConstructorCallStatement createSuperConstructorCall(Ide superConfigVar) {
        return MxmlAstUtils.createSuperConstructorCall(new IdeExpr(superConfigVar));
    }

    @Nonnull
    static SuperConstructorCallStatement createSuperConstructorCall(Expr ... argExprs) {
        CommaSeparatedList args = MxmlAstUtils.createCommaSeparatedList((AstNode[])argExprs);
        return new SuperConstructorCallStatement(MxmlAstUtils.sym_super().withWhitespace(INDENT_4), MxmlAstUtils.sym_lparen(), args, MxmlAstUtils.sym_rparen(), MxmlAstUtils.sym_semicolon());
    }

    @Nonnull
    static Directive createPropertyAssignment(@Nonnull Ide variable, @Nonnull Expr rightHandSide, @Nonnull String propertyName, boolean untypedAccess) {
        Expr leftHandSide;
        Ide varWithWhitespace = new Ide(variable.getIde());
        if (untypedAccess) {
            leftHandSide = new ArrayIndexExpr(new IdeExpr(varWithWhitespace), MxmlAstUtils.sym_lbrack(), new LiteralExpr(new JooSymbol('\"' + propertyName + '\"')), MxmlAstUtils.sym_rbrack());
        } else {
            Ide propertyNameIde = new Ide(propertyName);
            leftHandSide = "this".equals(varWithWhitespace.getName()) ? new IdeExpr(propertyNameIde) : new DotExpr(new IdeExpr(varWithWhitespace), MxmlAstUtils.sym_dot(), propertyNameIde);
        }
        AssignmentOpExpr assignmentOpExpr = MxmlAstUtils.createAssignmentOpExpr(leftHandSide, rightHandSide);
        return MxmlAstUtils.createSemicolonTerminatedStatement(assignmentOpExpr);
    }

    @Nonnull
    static AssignmentOpExpr createAssignmentOpExpr(Expr leftHandSide, @Nonnull Expr rightHandSide) {
        return new AssignmentOpExpr(leftHandSide, MxmlAstUtils.sym_eq().withWhitespace(" "), rightHandSide);
    }

    @Nonnull
    static ObjectField createObjectField(@Nonnull String propertyName, @Nonnull Expr rightHandSide) {
        return new ObjectField(MxmlAstUtils.createObjectFieldLabel(propertyName), MxmlAstUtils.sym_colon(), rightHandSide);
    }

    @Nonnull
    private static AstNode createObjectFieldLabel(@Nonnull String propertyName) {
        return Ide.isValidIdentifier(propertyName) ? new Ide(new JooSymbol(propertyName)) : MxmlAstUtils.createStringLiteral(propertyName);
    }

    @Nonnull
    static Spread createSpread(@Nonnull Expr expr) {
        return new Spread(new JooSymbol(42, "..."), expr);
    }

    @Nonnull
    static ObjectLiteral createObjectLiteral(@Nonnull List<ObjectFieldOrSpread> objectFields) {
        return new ObjectLiteral(MxmlAstUtils.sym_lbrace(), MxmlAstUtils.createCommaSeparatedList(objectFields), null, MxmlAstUtils.sym_rbrace());
    }

    @Nonnull
    static ArrayLiteral createArrayLiteral(@Nonnull List<Expr> arrayElements) {
        return new ArrayLiteral(MxmlAstUtils.sym_lbrack(), MxmlAstUtils.createCommaSeparatedList(arrayElements), MxmlAstUtils.sym_rbrack());
    }

    @SafeVarargs
    @Nonnull
    static <T extends AstNode> CommaSeparatedList<T> createCommaSeparatedList(T ... elements) {
        return MxmlAstUtils.createCommaSeparatedList(Arrays.asList(elements));
    }

    static <T extends AstNode> CommaSeparatedList<T> createCommaSeparatedList(List<T> elements) {
        CommaSeparatedList<AstNode> result = null;
        JooSymbol comma = null;
        for (int i = elements.size() - 1; i >= 0; --i) {
            AstNode t = (AstNode)elements.get(i);
            result = new CommaSeparatedList<AstNode>(t, comma, result);
            comma = MxmlAstUtils.sym_comma();
        }
        return result;
    }

    @Nonnull
    static Expr createNewExpr(Ide typeIde, Expr ... args) {
        return MxmlAstUtils.createApplyExpr(new NewExpr(MxmlAstUtils.sym_new().withWhitespace(" "), new IdeExpr(typeIde)), args);
    }

    @Nonnull
    static LiteralExpr createNullLiteral() {
        return new LiteralExpr(MxmlAstUtils.sym_null());
    }

    @Nonnull
    static IdeExpr createThisExpr() {
        return new IdeExpr(new Ide(MxmlAstUtils.sym_this()));
    }
}

