/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.utils.AS3Type;

public class FunctionExpr
extends Expr {
    public static final String ARGUMENTS = "arguments";
    public static final Ide ARGUMENTS_IDE = new Ide(new JooSymbol("arguments").virtual());
    public static final Type ANY_TYPE = new Type(new JooSymbol(50, "", -1, -1, "", AS3Type.ANY.toString()));
    private JooSymbol symFunction;
    private Ide ide;
    private JooSymbol lParen;
    private TypeRelation optTypeRelation;
    private Parameters params;
    private JooSymbol rParen;
    private BlockStatement optBody;
    private List<Parameter> implicitParams = new LinkedList<Parameter>();
    private FunctionDeclaration functionDeclaration;
    private VariableDeclaration variableDeclaration;
    private boolean thisDefined = false;
    private boolean explicitThisUsed = false;
    private final Parameter argumentsParameter;
    private boolean argumentsUsed = false;
    private boolean argumentsUsedAsArray = false;
    private IdeDeclaration classDeclaration;
    private Scope bodyScope;
    private boolean thisAliased;
    private Collection<FunctionExpr> functionExprs = new HashSet<FunctionExpr>();

    public FunctionExpr(FunctionDeclaration functionDeclaration, JooSymbol symFunction, Ide ide, JooSymbol lParen, Parameters params, JooSymbol rParen, TypeRelation optTypeRelation, BlockStatement optBody) {
        this.functionDeclaration = functionDeclaration;
        this.ide = ide;
        this.optTypeRelation = optTypeRelation;
        this.symFunction = symFunction;
        this.lParen = lParen;
        this.params = params;
        this.rParen = rParen;
        this.optBody = optBody;
        if (params != null && params.getHead() != null && params.getTail() == null && ((Parameter)params.getHead()).isRest() && ARGUMENTS.equals(((Parameter)params.getHead()).getName())) {
            this.argumentsParameter = (Parameter)params.getHead();
        } else {
            this.argumentsParameter = new Parameter(null, ARGUMENTS_IDE, null, null);
            this.implicitParams.add(this.argumentsParameter);
        }
    }

    public String getReturnTypeFromAnnotation() {
        FunctionDeclaration functionDeclaration = this.getFunctionDeclaration();
        if (functionDeclaration != null) {
            Object defaultPropertyValue;
            IdeDeclaration methodDeclaration;
            ClassDeclaration superTypeDeclaration;
            Annotation returnAnnotation = functionDeclaration.getAnnotation("Return");
            if (returnAnnotation == null && functionDeclaration.isClassMember() && !functionDeclaration.isStatic() && (superTypeDeclaration = functionDeclaration.getClassDeclaration().getSuperTypeDeclaration()) != null && (methodDeclaration = superTypeDeclaration.resolvePropertyDeclaration(functionDeclaration.getIde().getName(), false)) instanceof FunctionDeclaration) {
                return ((FunctionDeclaration)methodDeclaration).getFun().getReturnTypeFromAnnotation();
            }
            if (returnAnnotation != null && (defaultPropertyValue = returnAnnotation.getPropertiesByName().get(null)) instanceof String) {
                return (String)defaultPropertyValue;
            }
        }
        return null;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.ide, this.params, this.optTypeRelation, this.optBody);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitFunctionExpr(this);
    }

    public FunctionDeclaration getFunctionDeclaration() {
        return this.functionDeclaration;
    }

    public Parameters getParams() {
        return this.params;
    }

    public BlockStatement getBody() {
        return this.optBody;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.symFunction;
    }

    public IdeDeclaration getClassDeclaration() {
        return this.classDeclaration;
    }

    @Override
    public void scope(Scope scope) {
        this.classDeclaration = scope.getClassDeclaration();
        if (!this.thisDefined) {
            this.addImplicitParam(new Parameter(null, new Ide("this"), new TypeRelation(null, ANY_TYPE), null));
        }
        this.withNewDeclarationScope(this.functionDeclaration == null ? this : this.functionDeclaration, scope, new NodeImplBase.Scoped(){

            @Override
            public void run(Scope scope) {
                if (!(FunctionExpr.this.functionDeclaration != null && FunctionExpr.this.functionDeclaration.isMethod() || FunctionExpr.this.ide == null || FunctionExpr.this.ide.getScope() != null)) {
                    FunctionExpr.this.variableDeclaration = new VariableDeclaration(null, FunctionExpr.this.ide, null, null);
                    FunctionExpr.this.variableDeclaration.scope(scope);
                }
                FunctionExpr.this.scope(FunctionExpr.this.implicitParams, scope);
                FunctionExpr.this.withNewDeclarationScope(FunctionExpr.this, scope, new NodeImplBase.Scoped(){

                    @Override
                    public void run(Scope scope) {
                        FunctionExpr.this.bodyScope = scope;
                        if (FunctionExpr.this.params != null) {
                            FunctionExpr.this.params.scope(scope);
                        }
                        if (FunctionExpr.this.optTypeRelation != null) {
                            FunctionExpr.this.optTypeRelation.scope(scope);
                        }
                        if (FunctionExpr.this.optBody != null) {
                            FunctionExpr.this.optBody.scope(scope);
                        }
                    }
                });
            }
        });
        this.setType(scope.getFunctionSignature(this.functionDeclaration != null ? this.functionDeclaration.getMethodType() : null, this.params, scope.getExpressionType(this.optTypeRelation)));
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.params != null) {
            this.params.analyze(this);
        }
        if (this.optTypeRelation != null) {
            this.optTypeRelation.analyze(this);
        }
        if (this.optBody != null) {
            TypeRelation typeRelation = this.getOptTypeRelation();
            List<Directive> directives = this.optBody.getDirectives();
            if (typeRelation != null && AS3Type.VOID.name.equals(typeRelation.getType().getIde().getName()) && "this".equals(this.getReturnTypeFromAnnotation()) && (directives.isEmpty() || !(directives.get(directives.size() - 1) instanceof ReturnStatement))) {
                ReturnStatement returnThis = new ReturnStatement(new JooSymbol(30, "return"), null, new JooSymbol(71, ";"));
                returnThis.scope(this.bodyScope);
                this.optBody.getDirectives().add(returnThis);
            }
            this.optBody.analyze(this);
        }
    }

    public void addImplicitParam(Parameter parameter) {
        this.implicitParams.add(parameter);
    }

    public void setThisDefined() {
        this.thisDefined = true;
    }

    public boolean hasBody() {
        return this.getBody() != null;
    }

    public Ide getIde() {
        return this.ide;
    }

    public JooSymbol getSymFunction() {
        return this.symFunction;
    }

    public JooSymbol getLParen() {
        return this.lParen;
    }

    public TypeRelation getOptTypeRelation() {
        return this.optTypeRelation;
    }

    public JooSymbol getRParen() {
        return this.rParen;
    }

    public JooSymbol getFunSymbol() {
        return this.symFunction;
    }

    boolean notifyThisUsed() {
        if (!this.thisAliased) {
            if (this.getFunctionDeclaration() != null && this.getFunctionDeclaration().isClassMember()) {
                return false;
            }
            this.thisAliased = true;
            Scope parentScope = this.bodyScope.getParentScope().getParentScope();
            FunctionExpr parentFunctionExpr = parentScope.getFunctionExpr();
            if (parentFunctionExpr != null) {
                parentFunctionExpr.addFunctionExpr(this);
                parentFunctionExpr.notifyThisUsed();
            }
        }
        return true;
    }

    private void addFunctionExpr(FunctionExpr functionExpr) {
        this.functionExprs.add(functionExpr);
    }

    public boolean isThisAliased(boolean allowArrowFunctions) {
        return this.thisAliased && (!allowArrowFunctions || !this.rewriteToArrowFunction()) || this.functionExprs.stream().anyMatch(functionExpr -> functionExpr.isThisAliased(allowArrowFunctions));
    }

    void notifyExplicitThisUsed() {
        this.explicitThisUsed = true;
    }

    public boolean isExplicitThisUsed() {
        return this.explicitThisUsed;
    }

    public boolean rewriteToArrowFunction() {
        return !this.isExplicitThisUsed() && !this.argumentsUsed && this.getBody() != null && (this.variableDeclaration == null || this.variableDeclaration.getUsages().isEmpty()) && this.getFunctionDeclaration() == null;
    }

    boolean isMyArguments(Parameter maybeArgumentsParameter) {
        return this.argumentsParameter == maybeArgumentsParameter;
    }

    void notifyArgumentsUsed(boolean asArray) {
        this.argumentsUsed = true;
        if (asArray) {
            this.argumentsUsedAsArray = true;
        }
    }

    public boolean isArgumentsUsedAsArray() {
        return this.argumentsUsedAsArray;
    }
}

