/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.LiteralExpr;

public class Annotation
extends Directive {
    private JooSymbol leftBracket;
    private Ide ide;
    private JooSymbol optLeftParen;
    private CommaSeparatedList<AnnotationParameter> optAnnotationParameters;
    private JooSymbol optRightParen;
    private JooSymbol rightBracket;

    public Annotation(JooSymbol leftBracket, Ide ide, JooSymbol rightBracket) {
        this(leftBracket, ide, null, null, null, rightBracket);
    }

    public Annotation(JooSymbol leftBracket, Ide ide, JooSymbol optLeftParen, CommaSeparatedList<AnnotationParameter> optAnnotationParameters, JooSymbol optRightParen, JooSymbol optRightBracket) {
        this.leftBracket = leftBracket;
        this.ide = ide;
        this.optLeftParen = optLeftParen;
        this.optRightParen = optRightParen;
        this.optAnnotationParameters = optAnnotationParameters;
        this.rightBracket = optRightBracket;
        for (CommaSeparatedList<AnnotationParameter> params = optAnnotationParameters; params != null; params = params.getTail()) {
            params.getHead().setParentAnnotation(this);
        }
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.ide, this.optAnnotationParameters);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitAnnotation(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getIde().scope(scope);
        if (this.getOptAnnotationParameters() != null) {
            this.getOptAnnotationParameters().scope(scope);
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.getOptAnnotationParameters() != null) {
            this.getOptAnnotationParameters().analyze(this);
            if ("Embed".equals(this.getMetaName())) {
                Scope scope = this.getIde().getScope();
                scope.getCompilationUnit().addDependency(scope.getCompiler().getCompilationUnit("joo.flash.Embed"), false);
                Object source = this.getPropertiesByName().get("source");
                if (source != null) {
                    scope.getCompilationUnit().getResourceDependencies().add(source.toString());
                }
            }
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getLeftBracket();
    }

    public String getMetaName() {
        return this.getIde().getName();
    }

    public JooSymbol getLeftBracket() {
        return this.leftBracket;
    }

    public Ide getIde() {
        return this.ide;
    }

    public JooSymbol getOptLeftParen() {
        return this.optLeftParen;
    }

    public CommaSeparatedList<AnnotationParameter> getOptAnnotationParameters() {
        return this.optAnnotationParameters;
    }

    public JooSymbol getOptRightParen() {
        return this.optRightParen;
    }

    public JooSymbol getRightBracket() {
        return this.rightBracket;
    }

    public Map<String, Object> getPropertiesByName() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (CommaSeparatedList<AnnotationParameter> annotationParameters = this.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
            ArrayList<Object> value;
            AnnotationParameter annotationParameter = annotationParameters.getHead();
            String key = annotationParameter.getOptName() == null ? null : annotationParameter.getOptName().getName();
            AstNode valueExpression = annotationParameter.getValue();
            ArrayList<Object> arrayList = valueExpression instanceof LiteralExpr ? valueExpression.getSymbol().getJooValue() : (value = valueExpression instanceof Ide ? ((Ide)valueExpression).getQualifiedNameStr() : null);
            if (result.containsKey(key)) {
                ArrayList<Object> valueList;
                Object oldValue = result.get(key);
                if (oldValue instanceof List) {
                    valueList = (ArrayList<Object>)oldValue;
                } else {
                    valueList = new ArrayList<Object>();
                    valueList.add(oldValue);
                }
                valueList.add(value);
                value = valueList;
            }
            result.put(key, value);
        }
        return result;
    }

    public String getEventName() {
        if ("Event".equals(this.getMetaName())) {
            Map<String, Object> propertiesByName = this.getPropertiesByName();
            Object eventName = propertiesByName.get("name");
            if (!(eventName instanceof String)) {
                eventName = propertiesByName.get(null);
            }
            if (eventName instanceof String) {
                return (String)eventName;
            }
        }
        return null;
    }
}

