/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.jooc.json.JsonArray;
import net.jangaroo.jooc.json.JsonObject;

public class DependencyWarningsManager {
    private final List<DependencyWarning> dependencyWarnings = new ArrayList<DependencyWarning>();
    private final Map<String, Boolean> compileDependencies = new HashMap<String, Boolean>();

    public void loadInputSource(InputSource inputSource) {
        this.getCompileDependencies((PathInputSource)inputSource);
    }

    private void getCompileDependencies(PathInputSource classPathInputSource) {
        for (InputSource child : classPathInputSource.getChildren("")) {
            String key;
            if (!child.isInCompilePath() || (key = child.getPath().split("!")[0]) == null) continue;
            this.compileDependencies.putIfAbsent(key, false);
        }
    }

    public List<DependencyWarning> getDependencyWarnings() {
        return this.dependencyWarnings;
    }

    public String createFileString() {
        List undeclaredDependencies = this.dependencyWarnings.stream().map(DependencyWarning::getDependency).collect(Collectors.toList());
        return new JsonObject("undeclaredDependencies", new JsonArray(undeclaredDependencies.toArray()), "unusedDependencies", new JsonArray(this.getUnusedDeclaredDependencies().toArray())).toString(2, 0, true);
    }

    public void addDependencyWarning(String compileDependency, String usageName) {
        Optional<DependencyWarning> warning = this.dependencyWarnings.stream().filter(dependencyWarning -> dependencyWarning.matches(compileDependency)).findFirst();
        if (warning.isPresent()) {
            warning.get().addUsage(usageName);
        } else {
            this.dependencyWarnings.add(new DependencyWarning(compileDependency, usageName));
        }
    }

    public void updateUsedCompileDependencies(List<String> usedCompileDependencies) {
        for (String usedCompileDependency : usedCompileDependencies) {
            if (this.compileDependencies.containsKey(usedCompileDependency)) {
                this.compileDependencies.put(usedCompileDependency, true);
                continue;
            }
            if (this.compileDependencies.keySet().stream().anyMatch(usedCompileDependency::contains)) {
                this.compileDependencies.keySet().stream().filter(usedCompileDependency::contains).findFirst().ifPresent(dependency -> this.compileDependencies.put((String)dependency, true));
                continue;
            }
            this.compileDependencies.put(usedCompileDependency, true);
        }
    }

    public List<String> getUnusedDeclaredDependencies() {
        return this.compileDependencies.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static class DependencyWarning {
        private final String dependency;
        private final Set<String> usages;

        public DependencyWarning(String dependency, String usage) {
            this.dependency = dependency.split("!")[0];
            this.usages = new HashSet<String>();
            this.usages.add(usage.split("!")[0]);
        }

        public String getDependency() {
            return this.dependency;
        }

        public Set<String> getUsages() {
            return this.usages;
        }

        public boolean matches(String dependency) {
            return this.dependency.equals(dependency.split("!")[0]);
        }

        public void addUsage(String usage) {
            this.usages.add(usage);
        }
    }
}

