/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import com.google.common.io.LineReader;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.WarningLevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.jangaroo.jooc.api.Compressor;

public class CompressorImpl
implements Compressor {
    private static final String OUTPUT_CHARSET = "UTF-8";
    private static final String SOURCE_MAP_EXTENSION = ".map";

    public void compress(Collection<File> sources, File output) throws IOException {
        CompilerOptions options = new CompilerOptions();
        CompilationLevel.WHITESPACE_ONLY.setOptionsForCompilationLevel(options);
        options.setOutputCharset(OUTPUT_CHARSET);
        File sourceMap = new File(output.getPath() + SOURCE_MAP_EXTENSION);
        options.setSourceMapFormat(SourceMap.Format.V3);
        options.setSourceMapOutputPath(sourceMap.getPath());
        String outputFilePath = output.getPath();
        String prefix = outputFilePath.substring(0, outputFilePath.lastIndexOf(File.separator) + 1);
        if (File.separatorChar == '\\') {
            prefix = prefix.replace('\\', '/');
        }
        options.setSourceMapLocationMappings(Collections.singletonList(new SourceMap.LocationMapping(prefix, "")));
        Path outputDirPath = output.getParentFile().toPath();
        WarningLevel level = WarningLevel.QUIET;
        level.setOptionsForWarningLevel(options);
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>();
        for (File source : sources) {
            Path sourcePath = source.toPath();
            Path relativeSourcePath = outputDirPath.relativize(sourcePath);
            File file = new File(outputDirPath.toString(), relativeSourcePath.toString());
            SourceFile sourceFile = SourceFile.fromFile((File)file);
            sourceFiles.add(sourceFile);
        }
        Compiler compiler = new Compiler();
        Result result = compiler.compile(Collections.emptyList(), sourceFiles, options);
        if (compiler.hasErrors()) {
            throw new IllegalArgumentException(compiler.getErrors()[0].description);
        }
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), Charset.forName(OUTPUT_CHARSET)));){
            writer.append(compiler.toSource());
            writer.printf("\n//# sourceMappingURL=%s\n", sourceMap.getName());
        }
        StringBuffer sourceMapContent = new StringBuffer();
        result.sourceMap.appendTo((Appendable)sourceMapContent, output.getName());
        try (FileWriter writer = new FileWriter(sourceMap);){
            ((Writer)writer).append(sourceMapContent.toString());
        }
    }

    public void compressFileList(File fileList, File output) throws IOException {
        try (FileReader reader = new FileReader(fileList);){
            String line;
            LineReader in = new LineReader((Readable)reader);
            ArrayList<File> files = new ArrayList<File>();
            File baseDir = fileList.getParentFile();
            String baseDirPath = baseDir.getPath();
            while ((line = in.readLine()) != null) {
                String filename = line.trim();
                if (filename.isEmpty()) continue;
                try {
                    Path path = Paths.get(baseDirPath, filename);
                    path = path.normalize();
                    files.add(path.toFile());
                }
                catch (Exception exception) {}
            }
            this.compress(files, output);
        }
    }
}

