/*
 * Copyright 2008 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package net.jangaroo.jooc.ast;

import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.types.ExpressionType;
import net.jangaroo.utils.AS3Type;

import java.io.IOException;

/**
 * @author Andreas Gawecki
 */
public class ArrayLiteral extends ParenthesizedExpr<CommaSeparatedList<Expr>> {

  private Scope scope;

  public ArrayLiteral(JooSymbol lBracket, CommaSeparatedList<Expr> fields, JooSymbol rBracket) {
    super(lBracket, fields, rBracket);
  }

  @Override
  public void scope(Scope scope) {
    this.scope = scope;
    super.scope(scope);
  }

  @Override
  public void analyze(AstNode parentNode) {
    super.analyze(parentNode);
    setType(scope.getExpressionType(AS3Type.ARRAY));
  }

  @Override
  public void visit(AstVisitor visitor) throws IOException {
    visitor.visitArrayLiteral(this);
  }

}
