/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties;

import java.io.File;
import java.util.Locale;
import net.jangaroo.utils.CompilerUtils;

public class PropcHelper {
    public static final String DEFAULT_LOCALE = "en";

    public static Locale computeLocale(String propertiesClassName) {
        String[] parts = PropcHelper.getLocalBundleName(propertiesClassName).split("_", 4);
        switch (parts.length) {
            case 4: {
                return new Locale(parts[1], parts[2], parts[3]);
            }
            case 3: {
                return new Locale(parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[1]);
            }
        }
        return null;
    }

    public static String computeBaseClassName(String propertiesClassName) {
        String localBundleName = PropcHelper.getLocalBundleName(propertiesClassName);
        int underscorePos = localBundleName.indexOf(95);
        if (underscorePos != -1) {
            return CompilerUtils.qName((String)CompilerUtils.packageName((String)propertiesClassName), (String)(localBundleName.substring(0, underscorePos) + "_properties"));
        }
        return propertiesClassName;
    }

    public static String getBundleName(String propertiesClassName) {
        return propertiesClassName.substring(0, propertiesClassName.length() - "_properties".length());
    }

    private static String getLocalBundleName(String propertiesClassName) {
        return CompilerUtils.className((String)PropcHelper.getBundleName(propertiesClassName));
    }

    public static File computeGeneratedPropertiesAS3File(File apiOutputDirectory, String className, Locale locale) {
        String generatedPropertiesClassFileName = CompilerUtils.fileNameFromQName((String)PropcHelper.insertNonDefaultLocale(className, locale), (char)'/', (String)".as");
        return new File(apiOutputDirectory, generatedPropertiesClassFileName);
    }

    public static File computeGeneratedPropertiesJsFile(File outputDirectory, String className, Locale locale) {
        String subDirWithTrailingSlash = PropcHelper.localeOrDefaultLocaleString(locale) + '/';
        String generatedPropertiesClassFileName = subDirWithTrailingSlash + CompilerUtils.fileNameFromQName((String)className, (char)'/', (String)".js");
        return new File(outputDirectory, generatedPropertiesClassFileName);
    }

    public static String localeOrDefaultLocaleString(Locale locale) {
        return locale == null ? DEFAULT_LOCALE : locale.toString();
    }

    public static String insertNonDefaultLocale(String className, Locale locale) {
        return locale == null || DEFAULT_LOCALE.equals(locale.toString()) ? className : className.substring(0, className.length() - "_properties".length()) + "_" + locale.toString() + "_properties";
    }
}

