/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.util;

import java.util.Stack;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class PreserveLineNumberHandler
extends DefaultHandler2 {
    private static final String LINE_NUMBER_KEY_NAME = "lineNumber";
    private static final String COLUMN_NUMBER_KEY_NAME = "columnNumber";
    private final Stack<Node> elementStack = new Stack();
    private final StringBuilder textBuffer = new StringBuilder();
    private Document doc;
    private Locator locator;

    public PreserveLineNumberHandler(Document doc) {
        this.doc = doc;
        this.elementStack.push(doc);
    }

    public static int getLineNumber(Node node) {
        String lineStr = (String)node.getUserData(LINE_NUMBER_KEY_NAME);
        return lineStr == null ? -1 : Integer.parseInt(lineStr);
    }

    public static int getColumnNumber(Node node) {
        String lineStr = (String)node.getUserData(COLUMN_NUMBER_KEY_NAME);
        return lineStr == null ? -1 : Integer.parseInt(lineStr);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.addTextIfNeeded();
        Element el = this.doc.createElementNS(uri, qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            el.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
        }
        el.setUserData(LINE_NUMBER_KEY_NAME, String.valueOf(this.locator.getLineNumber()), null);
        el.setUserData(COLUMN_NUMBER_KEY_NAME, String.valueOf(this.locator.getColumnNumber()), null);
        this.elementStack.push(el);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.addTextIfNeeded();
        Node closedEl = this.elementStack.pop();
        this.elementStack.peek().appendChild(closedEl);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.textBuffer.append(ch, start, length);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        super.comment(ch, start, length);
        Comment comment = this.doc.createComment(new String(ch, start, length));
        Node parentEl = this.elementStack.peek();
        parentEl.appendChild(comment);
    }

    private void addTextIfNeeded() {
        if (this.textBuffer.length() > 0) {
            Text textNode = this.doc.createTextNode(this.textBuffer.toString());
            this.elementStack.peek().appendChild(textNode);
            this.textBuffer.delete(0, this.textBuffer.length());
        }
    }
}

