/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Statement;

public class SemicolonTerminatedStatement
extends Statement {
    private AstNode optStatement;
    private JooSymbol optSymSemicolon;

    public SemicolonTerminatedStatement(JooSymbol optSymSemicolon) {
        this(null, optSymSemicolon);
    }

    public SemicolonTerminatedStatement(AstNode optStatement, JooSymbol optSymSemicolon) {
        Debug.assertTrue(optStatement != null || optSymSemicolon != null, "Both statement and semicolon not specified in SemicolonTerminatedStatement.");
        this.setOptStatement(optStatement);
        this.setOptSymSemicolon(optSymSemicolon);
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.optStatement);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitSemicolonTerminatedStatement(this);
    }

    @Override
    public void scope(Scope scope) {
        if (this.getOptStatement() != null) {
            this.getOptStatement().scope(scope);
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.getOptStatement() != null) {
            this.getOptStatement().analyze(this);
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getOptStatement() != null ? this.getOptStatement().getSymbol() : this.getOptSymSemicolon();
    }

    public AstNode getOptStatement() {
        return this.optStatement;
    }

    public void setOptStatement(AstNode optStatement) {
        this.optStatement = optStatement;
    }

    public JooSymbol getOptSymSemicolon() {
        return this.optSymSemicolon;
    }

    public void setOptSymSemicolon(JooSymbol optSymSemicolon) {
        this.optSymSemicolon = optSymSemicolon;
    }
}

