/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.types.ExpressionType;
import net.jangaroo.utils.AS3Type;

public class NewExpr
extends Expr {
    private JooSymbol symNew;
    private Expr applyConstructor;

    public NewExpr(JooSymbol symNew, Expr applyConstructor) {
        this.symNew = symNew;
        this.applyConstructor = applyConstructor;
        if (applyConstructor instanceof ApplyExpr) {
            ((ApplyExpr)applyConstructor).setInsideNewExpr(true);
        }
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.applyConstructor);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitNewExpr(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getApplyConstructor().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        Expr applyConstructor = this.getApplyConstructor();
        applyConstructor.analyze(this);
        ExpressionType type = applyConstructor.getType();
        if (!(parentNode instanceof ApplyExpr)) {
            type = type.getAS3Type() == AS3Type.CLASS ? type.getTypeParameter() : null;
        }
        this.setType(type);
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getSymNew();
    }

    public JooSymbol getSymNew() {
        return this.symNew;
    }

    public Expr getApplyConstructor() {
        return this.applyConstructor;
    }
}

