/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NamespaceDeclaration;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class CompilationUnit
extends NodeImplBase {
    protected PackageDeclaration packageDeclaration;
    private JooSymbol lBrace;
    private List<Directive> directives;
    protected IdeDeclaration primaryDeclaration;
    private JooSymbol rBrace;
    private Set<String> compileDependencies = new HashSet<String>();
    private List<String> resourceDependencies = new ArrayList<String>();
    private Set<String> publicApiDependencies = new HashSet<String>();
    private Set<String> usesDependencies = new HashSet<String>();
    private Set<String> requiresDependencies = new HashSet<String>();
    private Set<String> usedBuiltInIdentifiers = new TreeSet<String>();
    private Scope scope;

    public CompilationUnit(PackageDeclaration packageDeclaration, JooSymbol lBrace, List<Directive> directives, IdeDeclaration primaryDeclaration, JooSymbol rBrace, List<IdeDeclaration> secondaryDeclarations) {
        this.packageDeclaration = packageDeclaration;
        this.lBrace = lBrace;
        this.directives = directives;
        this.primaryDeclaration = primaryDeclaration;
        if (primaryDeclaration instanceof ClassDeclaration) {
            ((ClassDeclaration)primaryDeclaration).setSecondaryDeclarations(secondaryDeclarations);
            if (secondaryDeclarations != null) {
                for (IdeDeclaration secondaryDeclaration : secondaryDeclarations) {
                    if (!(secondaryDeclaration instanceof ClassDeclaration)) continue;
                    this.directives.addAll(((ClassDeclaration)secondaryDeclaration).getDirectives());
                }
            }
        }
        this.rBrace = rBrace;
    }

    public String getQualifiedNameStr() {
        return CompilerUtils.qName((String)this.getPackageDeclaration().getQualifiedNameStr(), (String)this.getPrimaryDeclaration().getName());
    }

    public boolean isClass() {
        return this.getPrimaryDeclaration() instanceof ClassDeclaration;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        ArrayList<AstNode> result = new ArrayList<AstNode>(this.makeChildren(super.getChildren(), this.packageDeclaration, this.directives, this.primaryDeclaration));
        if (this.primaryDeclaration instanceof ClassDeclaration) {
            result.addAll(((ClassDeclaration)this.primaryDeclaration).getSecondaryDeclarations());
        }
        return result;
    }

    public List<Directive> getDirectives() {
        return this.directives;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitCompilationUnit(this);
    }

    private void addStarImport(Ide packageIde) {
        ImportDirective importDirective = new ImportDirective(packageIde, AS3Type.ANY.toString());
        this.directives.add(0, importDirective);
    }

    @Override
    public void scope(Scope scope) {
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            @Override
            public void run(Scope scope) {
                Ide packageIde = CompilationUnit.this.packageDeclaration.getIde();
                CompilationUnit.this.packageDeclaration.scope(scope);
                if (packageIde != null) {
                    CompilationUnit.this.addStarImport(packageIde);
                }
                CompilationUnit.this.addStarImport(null);
                for (AstNode astNode : CompilationUnit.this.getDirectives()) {
                    astNode.scope(scope);
                }
                CompilationUnit.this.withNewDeclarationScope(CompilationUnit.this.packageDeclaration, scope, new NodeImplBase.Scoped(){

                    @Override
                    public void run(Scope scope) {
                        CompilationUnit.this.scope = scope;
                        CompilationUnit.this.primaryDeclaration.scope(scope);
                    }
                });
            }
        });
    }

    public PackageDeclaration getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public IdeDeclaration getPrimaryDeclaration() {
        return this.primaryDeclaration;
    }

    public JooSymbol getLBrace() {
        return this.lBrace;
    }

    public JooSymbol getRBrace() {
        return this.rBrace;
    }

    public List<String> getResourceDependencies() {
        return this.resourceDependencies;
    }

    public Set<String> getPublicApiDependencies() {
        return this.publicApiDependencies;
    }

    public Set<String> getRuntimeDependencies() {
        HashSet<String> runtimeDependencies = new HashSet<String>(this.requiresDependencies);
        runtimeDependencies.addAll(this.usesDependencies);
        return runtimeDependencies;
    }

    public Set<String> getRuntimeDependencies(boolean required) {
        return required ? this.requiresDependencies : this.usesDependencies;
    }

    public Set<String> getCompileDependencies() {
        return this.compileDependencies;
    }

    public InputSource getInputSource() {
        return this.scope.getCompiler().getInputSource(this);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.packageDeclaration.analyze(this);
        this.analyze(this.packageDeclaration, this.directives);
        this.primaryDeclaration.analyze(this);
    }

    public List<Annotation> getAnnotations() {
        return this.getPrimaryDeclaration().getAnnotations();
    }

    @Override
    public JooSymbol getSymbol() {
        return this.packageDeclaration.getSymbol();
    }

    public static CompilationUnit mapMixinInterface(CompilationUnit compilationUnit) {
        CompilationUnit mixinCompilationUnit;
        if (compilationUnit != null && compilationUnit.getPrimaryDeclaration() instanceof ClassDeclaration && ((ClassDeclaration)compilationUnit.getPrimaryDeclaration()).isInterface() && (mixinCompilationUnit = CompilationUnit.getMixinCompilationUnit(compilationUnit.getPrimaryDeclaration())) != null) {
            return mixinCompilationUnit;
        }
        return compilationUnit;
    }

    public static CompilationUnit getMixinCompilationUnit(Declaration declaration) {
        Iterator<String> mixinClassNames;
        Annotation mixinAnnotation = declaration.getAnnotation("Mixin");
        if (mixinAnnotation != null && (mixinClassNames = CompilationUnit.getAnnotationDefaultParameterStringValues(mixinAnnotation).iterator()).hasNext()) {
            String mixinClassName = mixinClassNames.next();
            CompilationUnit mixinCompilationUnit = mixinAnnotation.getIde().getScope().getCompiler().getCompilationUnit(mixinClassName);
            if (mixinCompilationUnit == null) {
                throw Jooc.error(declaration, "Mixin annotation refers to unresolvable class '" + mixinClassName + "'.");
            }
            return mixinCompilationUnit;
        }
        return null;
    }

    public void addDependency(CompilationUnit otherUnit, Boolean required) {
        if ((otherUnit = CompilationUnit.mapMixinInterface(otherUnit)) != null && otherUnit != this) {
            String qName = otherUnit.getPrimaryDeclaration().getQualifiedNameStr();
            this.compileDependencies.add(qName);
            if (required != null && !this.requiresDependencies.contains(qName)) {
                if (required.booleanValue() || !otherUnit.isInSourcePath()) {
                    this.requiresDependencies.add(qName);
                    this.usesDependencies.remove(qName);
                } else {
                    this.usesDependencies.add(qName);
                }
            }
        }
    }

    private static List<String> getAnnotationDefaultParameterStringValues(Annotation annotation) {
        ArrayList<String> values = new ArrayList<String>();
        for (CommaSeparatedList<AnnotationParameter> current = annotation.getOptAnnotationParameters(); current != null; current = current.getTail()) {
            LiteralExpr literal;
            Object jooValue;
            AstNode value;
            AnnotationParameter head = current.getHead();
            if (head.getOptName() != null || !((value = head.getValue()) instanceof LiteralExpr) || !((jooValue = (literal = (LiteralExpr)value).getSymbol().getJooValue()) instanceof String)) continue;
            values.add((String)jooValue);
        }
        return values;
    }

    public void addPublicApiDependency(CompilationUnit otherUnit) {
        String qname;
        IdeDeclaration otherUnitPrimaryDeclaration;
        if (otherUnit != null && otherUnit != this && ((otherUnitPrimaryDeclaration = otherUnit.getPrimaryDeclaration()) instanceof ClassDeclaration || otherUnitPrimaryDeclaration instanceof NamespaceDeclaration) && (qname = otherUnitPrimaryDeclaration.getQualifiedNameStr()).indexOf(46) != -1) {
            this.publicApiDependencies.add(qname);
        }
    }

    public String toString() {
        return "CompilationUnit{packageDeclaration=" + this.packageDeclaration + ", primaryDeclaration=" + this.primaryDeclaration + '}';
    }

    public boolean isInSourcePath() {
        return this.getInputSource().isInSourcePath();
    }

    public void addBuiltInIdentifierUsage(String builtInIdentifier) {
        this.usedBuiltInIdentifiers.add(builtInIdentifier);
    }

    public Set<String> getUsedBuiltInIdentifiers() {
        return this.usedBuiltInIdentifiers;
    }

    public String cutOffExtNamespace(String targetName) {
        String extNamespace = this.getInputSource().getExtNamespace();
        if (extNamespace != null && !extNamespace.isEmpty()) {
            if (targetName.equals(extNamespace)) {
                targetName = "";
            } else {
                if (!targetName.startsWith(extNamespace + ".")) {
                    throw JangarooParser.error("Source file fully-qualified name " + targetName + " does not start with configured extNamespace " + extNamespace);
                }
                targetName = targetName.substring(extNamespace.length() + 1);
            }
        }
        return targetName;
    }
}

