/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.jangaroo.jooc.CompilationResultImpl;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.DependencyWarningsManager;
import net.jangaroo.jooc.ImplementedMembersAnalyzer;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.TypeChecker;
import net.jangaroo.jooc.api.CompilationResult;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.TransitiveAstVisitor;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.CompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.backend.MergedOutputCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.SingleFileCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.TypeScriptCodeGenerator;
import net.jangaroo.jooc.backend.TypeScriptModuleResolver;
import net.jangaroo.jooc.cli.CommandLineParseException;
import net.jangaroo.jooc.cli.JoocCommandLineParser;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.JoocOptions;
import net.jangaroo.jooc.config.NamespaceConfiguration;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.PublicApiViolationsMode;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.PathInputSource;
import net.jangaroo.jooc.input.ZipEntryInputSource;
import net.jangaroo.jooc.mxml.CatalogComponentsParser;
import net.jangaroo.jooc.mxml.CatalogGenerator;
import net.jangaroo.jooc.mxml.ComponentPackageManifestParser;
import net.jangaroo.jooc.mxml.ComponentPackageModel;
import net.jangaroo.jooc.mxml.MxmlComponentRegistry;
import net.jangaroo.utils.CompilerUtils;

public class Jooc
extends JangarooParser
implements net.jangaroo.jooc.api.Jooc {
    public static final String PUBLIC_API_EXCLUSION_ANNOTATION_NAME = "ExcludeClass";
    public static final String PUBLIC_API_INCLUSION_ANNOTATION_NAME = "PublicApi";
    public static final String DEPRECATED_ANNOTATION_NAME = "Deprecated";
    public static final String NATIVE_ANNOTATION_NAME = "Native";
    public static final String NATIVE_ANNOTATION_REQUIRE_PROPERTY = "require";
    public static final String RENAME_ANNOTATION_NAME = "Rename";
    public static final String MIXIN_ANNOTATION_NAME = "Mixin";
    public static final String MIXIN_HOOK_ANNOTATION_NAME = "MixinHook";
    public static final String MIXIN_HOOK_ANNOTATION_EXTENDED_ATTRIBUTE_NAME = "extended";
    public static final String MIXIN_HOOK_ANNOTATION_DEFAULT_ATTRIBUTE_NAME = "on";
    public static final Set<String> MIXIN_HOOK_ANNOTATION_ATTRIBUTE_NAMES = new HashSet<String>(Arrays.asList("before", "after", "on", "extended"));
    public static final String BINDABLE_ANNOTATION_NAME = "Bindable";
    public static final String EXT_CONFIG_ANNOTATION_NAME = "ExtConfig";
    public static final String EXT_PRIVATE_ANNOTATION_NAME = "ExtPrivate";
    public static final String EMBED_ANNOTATION_NAME = "Embed";
    public static final String EMBED_ANNOTATION_SOURCE_PROPERTY = "source";
    public static final String EMBED_ANNOTATION_MIME_TYPE_PROPERTY = "mimeType";
    public static final String EMBED_ANNOTATION_FONT_NAME_PROPERTY = "fontName";
    public static final String RESOURCE_BUNDLE_ANNOTATION_NAME = "ResourceBundle";
    public static final String ARRAY_ELEMENT_TYPE_ANNOTATION_NAME = "ArrayElementType";
    public static final String EVENT_ANNOTATION_NAME = "Event";
    public static final String EVENT_ANNOTATION_NAME_ATTRIBUTE_NAME = "name";
    public static final String EVENT_ANNOTATION_TYPE_ATTRIBUTE_NAME = "type";
    public static final String LAZY_ANNOTATION_NAME = "Lazy";
    public static final String PARAMETER_ANNOTATION_NAME = "Parameter";
    public static final String PARAMETER_ANNOTATION_REQUIRED_PROPERTY = "required";
    public static final String PARAMETER_ANNOTATION_COERCE_TO_PROPERTY = "coerceTo";
    public static final String COERCE_TO_VALUE_PROPERTIES_CLASS = "PropertiesClass";
    public static final String COERCE_TO_VALUE_KEYOF_PREFIX = "keyof ";
    public static final String RETURN_ANNOTATION_NAME = "Return";
    public static final List<String> ANNOTATIONS_FOR_COMPILER_ONLY = Arrays.asList("Native", "Rename", "Embed", "Bindable", "ArrayElementType", "ExtConfig", "ResourceBundle", "Mixin", "MixinHook", "ExtPrivate", "PublicApi", "ExcludeClass", "Deprecated", "Event", "Lazy", "Parameter", "Return");
    public static final String TS_SUFFIX = ".ts";
    public static final String D_TS_SUFFIX = ".d.ts";
    private final DependencyWarningsManager dependencyWarningsManager;
    private final List<FileInputSource> compileQueue = new ArrayList<FileInputSource>();
    private static final List<String> IGNORE_DEPENDENCIES = Arrays.asList("Boolean.as", "String.as", "Number.as", "Object.as", "RegExp.as", "int", "uint", "Date.as", "Array.as", "Error.as", "Vector.as", "Class.as", "Function.as", "XML.as");

    public static String getOutputSuffix(boolean isMigrateToTypeScript) {
        return isMigrateToTypeScript ? TS_SUFFIX : ".js";
    }

    public Jooc() {
        this(new JoocConfiguration());
    }

    public Jooc(JoocConfiguration config) {
        this(config, (CompileLog)new StdOutCompileLog());
    }

    public Jooc(JoocConfiguration config, CompileLog log) {
        super((ParserOptions)config, log);
        this.dependencyWarningsManager = new DependencyWarningsManager();
    }

    public JoocConfiguration getConfig() {
        return (JoocConfiguration)super.getConfig();
    }

    public void setConfig(JoocConfiguration config) {
        super.setConfig((ParserOptions)config);
    }

    public String getOutputSuffix() {
        return Jooc.getOutputSuffix(this.getConfig().isMigrateToTypeScript());
    }

    public CompilationResult run() {
        try {
            return this.run1();
        }
        catch (CompilerError e) {
            this.logCompilerError(e);
            return new CompilationResultImpl(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logCompilerError(e);
            return new CompilationResultImpl(2);
        }
    }

    private void logCompilerError(Throwable e) {
        boolean causedBy = false;
        for (Throwable current = e; current != null; current = current.getCause()) {
            String message = current.getMessage();
            if (causedBy) {
                message = "Caused by: " + message;
            }
            if (current instanceof CompilerError && ((CompilerError)current).getSymbol() != null) {
                this.log.error(((CompilerError)current).getSymbol(), message);
            } else {
                this.log.error(message);
            }
            causedBy = true;
        }
    }

    private void findUnusedDependencies(CompilationUnit compilationUnit, InputSource classPathInputSource) {
        this.dependencyWarningsManager.loadInputSource(classPathInputSource);
        this.dependencyWarningsManager.updateUsedCompileDependencies(compilationUnit.getCompileDependencies().stream().map(this::findSource).map(InputSource::getPath).map(path -> path.split("!")[0]).distinct().collect(Collectors.toList()));
    }

    private void checkUndeclaredDependencies(CompilationUnit compilationUnit) {
        List<String> usedUndeclaredDependencies = compilationUnit.getCompileDependencies().stream().map(this::findSource).filter(inputSource -> !IGNORE_DEPENDENCIES.contains(inputSource.getName())).filter(inputSource -> !inputSource.isInSourcePath() && !inputSource.isInCompilePath()).map(InputSource::getPath).filter(Objects::nonNull).distinct().filter(dependency -> !dependency.contains("jangaroo-runtime") && !dependency.contains("jangaroo-browser")).collect(Collectors.toList());
        usedUndeclaredDependencies.forEach(dependency -> this.dependencyWarningsManager.addDependencyWarning((String)dependency, compilationUnit.getInputSource().getName()));
    }

    private CompilationResult run1() {
        PathInputSource classPathInputSource;
        PathInputSource sourcePathInputSource;
        try {
            String extNamespace = this.getConfig().getExtNamespace();
            sourcePathInputSource = PathInputSource.fromFiles(this.getConfig().getSourcePath(), new String[]{""}, true, extNamespace);
            classPathInputSource = PathInputSource.createCompilePathAwareClassPath(this.getConfig().getClassPath(), new String[]{"", "META-INF/joo-api/"}, extNamespace, this.getConfig().getCompilePath());
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        this.setUp(sourcePathInputSource, classPathInputSource);
        HashMap<File, File> outputFileMap = new HashMap<File, File>();
        try {
            this.setUpMxmlComponentRegistry(sourcePathInputSource, classPathInputSource);
            for (File sourceFile : this.getConfig().getSourceFiles()) {
                this.processSource(sourceFile);
            }
            CompilationUnitSinkFactory codeSinkFactory = this.createSinkFactory(this.getConfig(), null);
            CompilationUnitSinkFactory dTsSinkFactory = this.createSinkFactory(this.getConfig(), D_TS_SUFFIX);
            CompilationUnitSinkFactory apiSinkFactory = this.createSinkFactory(this.getConfig(), ".as");
            ImplementedMembersAnalyzer implementedMembersAnalyzer = new ImplementedMembersAnalyzer(this);
            for (InputSource compilationResultImpl : this.compileQueue) {
                CompilationUnit unit = this.importSource(compilationResultImpl);
                if (unit == null) continue;
                this.checkValidFileName(unit);
                unit.analyze(null);
                if (this.getConfig().isFindUnusedDependencies()) {
                    this.findUnusedDependencies(unit, classPathInputSource);
                }
                this.checkUndeclaredDependencies(unit);
                if (this.getConfig().getPublicApiViolationsMode() != PublicApiViolationsMode.ALLOW) {
                    this.reportPublicApiViolations(unit);
                }
                implementedMembersAnalyzer.analyzeImplementedMembers(unit);
                TypeChecker typeChecker = new TypeChecker(this.log);
                unit.visit(new TransitiveAstVisitor(typeChecker));
            }
            if (!this.dependencyWarningsManager.getDependencyWarnings().isEmpty()) {
                ArrayList lines = new ArrayList();
                this.dependencyWarningsManager.getDependencyWarnings().forEach(dependencyWarning -> {
                    lines.add(String.format("Undeclared dependency %s was used by:", Paths.get(dependencyWarning.getDependency(), new String[0]).getFileName()));
                    dependencyWarning.getUsages().forEach(s -> lines.add("    " + s));
                });
                this.getLog().warning(String.join((CharSequence)"\n", lines));
            }
            for (InputSource inputSource : this.compileQueue) {
                File sourceFile = ((FileInputSource)inputSource).getFile();
                File outputFile = null;
                try {
                    String sourceName = inputSource.getName();
                    boolean isPropertiesSource = sourceName.endsWith(".properties");
                    CompilationUnit unit = this.importSource(inputSource);
                    if (unit != null) {
                        boolean generatesCode;
                        IdeDeclaration primaryDeclaration = unit.getPrimaryDeclaration();
                        CompilationUnitSinkFactory currentCodeSinkFactory = codeSinkFactory;
                        if (!this.getConfig().isMigrateToTypeScript()) {
                            generatesCode = JsCodeGenerator.generatesCode(primaryDeclaration);
                        } else {
                            generatesCode = TypeScriptCodeGenerator.generatesCode(primaryDeclaration);
                            if (generatesCode && TypeScriptModuleResolver.getNonRequireNativeName(primaryDeclaration) != null) {
                                currentCodeSinkFactory = dTsSinkFactory;
                            }
                        }
                        if (generatesCode) {
                            outputFile = this.writeOutput(sourceFile, unit, currentCodeSinkFactory, this.getConfig().isVerbose());
                        }
                        if (this.getConfig().isGenerateApi()) {
                            this.writeOutput(sourceFile, unit, apiSinkFactory, this.getConfig().isVerbose());
                            if (isPropertiesSource && this.isDefaultLocale(sourceName)) {
                                File apiOutputDirectory = this.getConfig().getApiOutputDirectory();
                                String relativeSourcePath = inputSource.getRelativePath();
                                File apiFile = new File(apiOutputDirectory, relativeSourcePath);
                                Files.copy(sourceFile.toPath(), apiFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    this.getLog().error(Jooc.fileToSymbol(sourceFile), e.getClass().getName() + ": " + e.getMessage());
                }
                outputFileMap.put(sourceFile, outputFile);
            }
            this.compileQueue.clear();
            this.copySassFiles();
            if (this.getConfig().getDependencyReportOutputFile() != null) {
                File dependencyWarningsFile = new File(this.getConfig().getDependencyReportOutputFile());
                if (!dependencyWarningsFile.getParentFile().exists()) {
                    dependencyWarningsFile.getParentFile().mkdirs();
                }
                if (!dependencyWarningsFile.exists()) {
                    dependencyWarningsFile.createNewFile();
                }
                try (FileWriter fileWriter = new FileWriter(dependencyWarningsFile);){
                    fileWriter.write(this.dependencyWarningsManager.createFileString());
                }
            }
            int result = this.log.hasErrors() ? 1 : 0;
            CompilationResultImpl compilationResultImpl = new CompilationResultImpl(result, outputFileMap);
            return compilationResultImpl;
        }
        catch (IOException e) {
            throw new CompilerError(e.getClass().getName() + ": " + e.getMessage(), e);
        }
        finally {
            this.tearDown();
        }
    }

    private boolean isDefaultLocale(String sourceName) {
        return sourceName.indexOf(95) < 0;
    }

    private void checkValidFileName(CompilationUnit unit) {
        String qname;
        String expectedPath;
        InputSource source = this.getInputSource(unit);
        if (!source.getName().endsWith(".as")) {
            return;
        }
        String path = source.getRelativePath();
        if (path != null && !(expectedPath = CompilerUtils.fileNameFromQName((String)(qname = unit.getPrimaryDeclaration().getQualifiedNameStr()), (char)File.separatorChar, (String)".as")).equals(path)) {
            Jooc.warning(unit.getSymbol(), String.format("expected '%s' as the file name for %s, found: '%s'. -sourcepath not set (correctly)?", expectedPath, qname, path));
        }
    }

    private void setUpMxmlComponentRegistry(InputSource sourcePathInputSource, InputSource classPathInputSource) throws IOException {
        List<InputSource> children = classPathInputSource.getChildren("catalog.xml");
        CatalogComponentsParser catalogParser = new CatalogComponentsParser(this.getMxmlComponentRegistry());
        for (InputSource child : children) {
            catalogParser.parse(child.getInputStream());
        }
        MxmlComponentRegistry localMxmlComponentRegistry = new MxmlComponentRegistry();
        List namespaces = this.getConfig().getNamespaces();
        for (NamespaceConfiguration namespace : namespaces) {
            File componentPackageManifest = namespace.getManifest();
            InputSource componentPackageManifestInputSource = componentPackageManifest == null ? sourcePathInputSource.getChild("manifest.xml") : new FileInputSource(componentPackageManifest, false);
            if (componentPackageManifestInputSource == null) continue;
            InputStream manifestInputStream = componentPackageManifestInputSource.getInputStream();
            ComponentPackageModel componentPackageModel = new ComponentPackageManifestParser(namespace.getUri()).parse(manifestInputStream);
            this.getMxmlComponentRegistry().add(componentPackageModel);
            localMxmlComponentRegistry.add(componentPackageModel);
        }
        File catalogOutputDirectory = this.getConfig().getCatalogOutputDirectory();
        if (catalogOutputDirectory != null && !localMxmlComponentRegistry.getComponentPackageModels().isEmpty()) {
            catalogOutputDirectory.mkdirs();
            new CatalogGenerator(localMxmlComponentRegistry).generateCatalog(new File(catalogOutputDirectory, "catalog.xml"));
        }
    }

    private void reportPublicApiViolations(CompilationUnit unit) {
        HashSet<String> dependenciesForPublicAPICheck = new HashSet<String>(unit.getCompileDependencies());
        for (String qName : dependenciesForPublicAPICheck) {
            CompilationUnit compilationUnit = this.getCompilationUnit(qName);
            if (!(this.getInputSource(compilationUnit) instanceof ZipEntryInputSource) || compilationUnit.getPackageDeclaration().getAnnotation(PUBLIC_API_EXCLUSION_ANNOTATION_NAME) == null) continue;
            String msg = "PUBLIC API VIOLATION: " + compilationUnit.getPrimaryDeclaration().getQualifiedNameStr();
            File sourceFile = new File(unit.getSymbol().getFileName());
            if (this.getConfig().getPublicApiViolationsMode() == PublicApiViolationsMode.WARN) {
                JangarooParser.warning(msg, sourceFile);
                continue;
            }
            throw JangarooParser.error(msg, sourceFile);
        }
    }

    public File writeOutput(File sourceFile, CompilationUnit compilationUnit, CompilationUnitSinkFactory writerFactory, boolean verbose) throws CompilerError {
        CompilationUnitSink sink = writerFactory.createSink(compilationUnit.getPackageDeclaration(), compilationUnit.getPrimaryDeclaration(), sourceFile, verbose);
        return sink.writeOutput(compilationUnit);
    }

    private CompilationUnitSinkFactory createSinkFactory(JoocConfiguration config, String suffix) {
        AbstractCompilationUnitSinkFactory codeSinkFactory = null;
        if (suffix == null) {
            suffix = this.getOutputSuffix();
        }
        boolean generateTypeScriptIndexDTS = D_TS_SUFFIX.equals(suffix);
        boolean generateActionScriptApi = ".as".equals(suffix);
        if (".js".equals(suffix) && config.isMergeOutput() || generateTypeScriptIndexDTS && config.isMigrateToTypeScript()) {
            File outputFile = config.isMergeOutput() ? config.getOutputFile() : new File(this.getConfig().getOutputDirectory(), "index.d.ts");
            codeSinkFactory = new MergedOutputCompilationUnitSinkFactory((JoocOptions)config, outputFile, this, this);
        } else if (!(generateActionScriptApi && !config.isGenerateApi() || generateTypeScriptIndexDTS)) {
            File outputDirectory = generateActionScriptApi ? config.getApiOutputDirectory() : config.getOutputDirectory();
            String nativeSuffix = !generateActionScriptApi && config.isMigrateToTypeScript() ? D_TS_SUFFIX : null;
            codeSinkFactory = new SingleFileCompilationUnitSinkFactory((JoocOptions)config, outputDirectory, generateActionScriptApi, suffix, nativeSuffix, this, this);
        }
        return codeSinkFactory;
    }

    public static String getResultCodeDescription(int resultCode) {
        switch (resultCode) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "compilation failed";
            }
            case 2: {
                return "internal compiler error";
            }
            case 3: {
                return "unrecognized option";
            }
            case 4: {
                return "missing option argument";
            }
            case 5: {
                return "illegal option value";
            }
        }
        return "unknown result code";
    }

    protected void processSource(File file) throws IOException {
        if (file.isDirectory()) {
            throw Jooc.error("Input file is a directory.", file);
        }
        File sourceDir = this.getConfig().findSourceDir(file);
        FileInputSource inputSource = new FileInputSource(sourceDir, file, true, this.getConfig().getExtNamespace());
        this.compileQueue.add(inputSource);
        this.importSource(inputSource);
    }

    protected void copySassFiles() throws IOException {
        String extSassNamespace = this.getConfig().getExtSassNamespace();
        for (String sassSourceSubFolderName : this.getConfig().getSassSourceFilesByType().keySet()) {
            File sassSourceSubFolder = (File)this.getConfig().getSassSourcePathByType().get(sassSourceSubFolderName);
            File sassTargetSubFolder = (File)this.getConfig().getSassOutputDirectoryByType().get(sassSourceSubFolderName);
            if (sassSourceSubFolder == null) {
                this.getLog().error("No sass source folder registered for folder type: " + sassSourceSubFolderName);
                continue;
            }
            if (sassTargetSubFolder == null) {
                this.getLog().error("No sass output folder registered for folder type: " + sassSourceSubFolderName);
                continue;
            }
            for (File sassSourceFile : (List)this.getConfig().getSassSourceFilesByType().get(sassSourceSubFolderName)) {
                File sassTargetFile;
                Path relativeSrcPath = sassSourceSubFolder.toPath().relativize(sassSourceFile.toPath());
                String srcFileName = sassSourceFile.getName();
                if (!srcFileName.endsWith(".scss")) {
                    this.getLog().warning("Cannot handle unknown extension in sass directory for file: " + sassSourceFile);
                    sassTargetFile = sassTargetSubFolder.toPath().resolve(relativeSrcPath).toFile();
                } else {
                    String newFqn;
                    String fqn = CompilerUtils.qNameFromFile((File)sassSourceSubFolder, (File)sassSourceFile);
                    CompilationUnit compilationUnit = this.getCompilationUnit(fqn);
                    if (compilationUnit != null) {
                        newFqn = compilationUnit.getPrimaryDeclaration().getTargetQualifiedNameStr();
                    } else {
                        newFqn = fqn;
                        this.getLog().warning(String.format("Could not find compilation unit %s for SASS file %s", fqn, srcFileName));
                    }
                    if (!extSassNamespace.isEmpty()) {
                        if (!newFqn.startsWith(extSassNamespace) || extSassNamespace.equals(newFqn)) {
                            this.getLog().error(String.format("Invalid extSassNamespace configuration %s! The following file location would be transformed: %s", extSassNamespace, sassSourceFile));
                            continue;
                        }
                        newFqn = newFqn.substring(extSassNamespace.length() + 1);
                    }
                    sassTargetFile = CompilerUtils.fileFromQName((String)newFqn, (File)sassTargetSubFolder, (String)".scss");
                }
                sassTargetFile.getParentFile().mkdirs();
                try {
                    Files.copy(sassSourceFile.toPath(), sassTargetFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                }
                catch (IOException e) {
                    this.getLog().error(String.format("Could not copy file %s to %s", sassSourceFile, sassTargetFile));
                }
            }
        }
    }

    public static int run(String[] argv, CompileLog log) {
        try {
            JoocCommandLineParser commandLineParser = new JoocCommandLineParser();
            JoocConfiguration config = commandLineParser.parse(argv);
            if (config != null) {
                return new Jooc(config, log).run().getResultCode();
            }
        }
        catch (CommandLineParseException e) {
            System.out.println(e.getMessage());
            return e.getExitCode();
        }
        return 0;
    }

    public static void main(String[] argv) {
        int result = Jooc.run(argv, new StdOutCompileLog());
        if (result != 0) {
            System.exit(result);
        }
    }
}

