/*
 * Copyright 2008 CoreMedia AG
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, 
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either 
 * express or implied. See the License for the specific language 
 * governing permissions and limitations under the License.
 */

package net.jangaroo.jooc.ast;

import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;

import java.util.List;

/**
 * A LabelRefStatement is either a break or continue statement
 *
 * @author Andreas Gawecki
 */
public abstract class LabelRefStatement extends KeywordExprStatement {

  LabelRefStatement(JooSymbol symStatement, Ide optLabel, JooSymbol symSemicolon) {
    super(symStatement, null, symSemicolon);
    this.optLabel = optLabel;
  }

  private Ide optLabel;

  private LabeledStatement labelDeclaration = null;

  @Override
  public List<? extends AstNode> getChildren() {
    return makeChildren(super.getChildren(), optLabel);
  }

  @Override
  public void scope(final Scope scope) {
    super.scope(scope);
    if (getOptLabel() == null) {
      Statement loopOrSwitchStatement = scope.getCurrentLoopOrSwitch(); // NOSONAR no, this is not a JDBC statement that must be closed ...
      if (loopOrSwitchStatement == null) {
        throw JangarooParser.error(this, "not inside loop or switch");
      }
    } else {
      setLabelDeclaration(scope.lookupLabel(getOptLabel()));
      checkValidLabeledStatement(getLabelDeclaration());
    }
  }

  protected abstract void checkValidLabeledStatement(final LabeledStatement labelDeclaration);

  public Ide getOptLabel() {
    return optLabel;
  }

  public LabeledStatement getLabelDeclaration() {
    return labelDeclaration;
  }

  public void setLabelDeclaration(LabeledStatement labelDeclaration) {
    this.labelDeclaration = labelDeclaration;
  }
}
