/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.properties;

import freemarker.core.Environment;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import net.jangaroo.properties.PropcException;
import net.jangaroo.properties.PropcHelper;
import net.jangaroo.properties.model.PropertiesClass;
import net.jangaroo.properties.model.ResourceBundleClass;
import net.jangaroo.utils.CompilerUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class Propc {
    public static final String PROPERTIES_CLASS_FTL = "properties_class.ftl";
    public static final String PROPERTIES_SUBCLASS_FTL = "properties_subclass.ftl";
    private static Configuration cfg = new Configuration();
    private static final String OUTPUT_CHARSET = "UTF-8";

    public void generateApi(String propertiesClassName, InputStream sourceInputStream, OutputStreamWriter writer) throws IOException {
        PropertiesClass propertiesClass;
        this.generatePropertiesClass(propertiesClass, writer, (propertiesClass = this.parse(propertiesClassName, sourceInputStream)).getLocale() == null ? PROPERTIES_CLASS_FTL : PROPERTIES_SUBCLASS_FTL);
    }

    private void generatePropertiesClass(PropertiesClass propertiesClass, Writer out, String templateFile) throws IOException {
        Template template = cfg.getTemplate(templateFile);
        try {
            Environment env = template.createProcessingEnvironment((Object)propertiesClass, out);
            env.setOutputEncoding(OUTPUT_CHARSET);
            env.process();
        }
        catch (TemplateException e) {
            throw new IOException("Internal error in property FreeMarker template.", e);
        }
    }

    private File generateCode(PropertiesClass pl, File outputFile, String templateFile) {
        outputFile.getParentFile().mkdirs();
        Writer writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), OUTPUT_CHARSET);
            this.generatePropertiesClass(pl, writer, templateFile);
            File file = outputFile;
            return file;
        }
        catch (Exception e) {
            throw new PropcException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private File generateApi(PropertiesClass pl, File outputDirectory) {
        File apiOutputFile = PropcHelper.computeGeneratedPropertiesAS3File(outputDirectory, pl.getResourceBundle().getFullClassName(), pl.getLocale());
        return this.generateCode(pl, apiOutputFile, PROPERTIES_CLASS_FTL);
    }

    public void generateApi(List<File> sourceFiles, List<File> sourcePath, File outputDirectory) {
        for (File srcFile : sourceFiles) {
            if (srcFile.getName().contains("_")) continue;
            PropertiesClass propertiesClass = this.parse(srcFile, sourcePath);
            this.generateApi(propertiesClass, outputDirectory);
        }
    }

    private PropertiesClass parse(String propertiesClassName, InputStream in) throws IOException {
        PropertiesConfiguration p = new PropertiesConfiguration();
        p.setDelimiterParsingDisabled(true);
        Reader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(in, OUTPUT_CHARSET));
            p.load(r);
        }
        catch (ConfigurationException e) {
            throw new PropcException("Internal error while parsing properties file.", e);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
        ResourceBundleClass bundle = new ResourceBundleClass(PropcHelper.computeBaseClassName(propertiesClassName));
        return new PropertiesClass(bundle, PropcHelper.computeLocale(propertiesClassName), p);
    }

    private PropertiesClass parse(File propertiesFile, List<File> sourcePath) {
        PropertiesClass propertiesClass;
        String className;
        try {
            className = CompilerUtils.qNameFromFile(sourcePath, (File)propertiesFile);
        }
        catch (IOException e1) {
            throw new PropcException(e1);
        }
        String propertiesClassName = className;
        try {
            propertiesClass = this.parse(propertiesClassName, new FileInputStream(propertiesFile));
        }
        catch (IOException e) {
            throw new PropcException("Error while parsing properties file", propertiesFile, e);
        }
        return propertiesClass;
    }

    static {
        cfg.setClassForTemplateLoading(Propc.class, "/net/jangaroo/properties/templates");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setOutputEncoding(OUTPUT_CHARSET);
    }
}

